/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead;

import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModulePackager;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.modules.customerrelationship.lead.LeadGroup;
import org.openconcerto.modules.customerrelationship.lead.LeadSQLElement;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.utils.SQLCreateTable;

public final class Module
extends AbstractModule {
    public static final String TABLE_LEAD = "LEAD";

    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) {
        super.install(ctxt);
        if (ctxt.getRoot().getTable(TABLE_LEAD) == null) {
            SQLCreateTable createTable = ctxt.getCreateTable(TABLE_LEAD);
            createTable.addVarCharColumn("NUMBER", 20);
            createTable.addDateAndTimeColumn("DATE");
            createTable.addVarCharColumn("FIRSTNAME", 64);
            createTable.addVarCharColumn("NAME", 64);
            createTable.addVarCharColumn("COMPANY", 64);
            createTable.addVarCharColumn("PHONE", 16);
            createTable.addVarCharColumn("MOBILE", 16);
            createTable.addVarCharColumn("FAX", 16);
            createTable.addVarCharColumn("EMAIL", 32);
            createTable.addVarCharColumn("WEBSITE", 64);
            createTable.addVarCharColumn("SOURCE", 200);
            createTable.addVarCharColumn("STATUS", 50);
            createTable.addForeignColumn("ADRESSE");
            createTable.addForeignColumn("COMMERCIAL");
            createTable.addVarCharColumn("INFORMATION", 512);
            createTable.addVarCharColumn("INDUSTRY", 200);
            createTable.addVarCharColumn("RATING", 200);
            createTable.addIntegerColumn("REVENUE", 0);
            createTable.addIntegerColumn("EMPLOYEES", 0);
        }
    }

    protected void setupElements(SQLElementDirectory dir) {
        super.setupElements(dir);
        GlobalMapper.getInstance().map("customerrelationship.lead.default", (Object)new LeadGroup());
        LeadSQLElement element = new LeadSQLElement();
        dir.addSQLElement((SQLElement)element);
    }

    protected void setupComponents(ComponentsContext ctxt) {
    }

    protected void setupMenu(MenuContext ctxt) {
        ctxt.addMenuItem((Action)ctxt.createListAction(TABLE_LEAD), "menu.list");
    }

    protected void start() {
    }

    protected void stop() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("org.openconcerto.quickLogin", "true");
        File propsFile = new File("module.properties");
        System.out.println(propsFile.getAbsolutePath());
        RuntimeModuleFactory factory = new RuntimeModuleFactory(propsFile);
        SQLRequestLog.setEnabled((boolean)true);
        SQLRequestLog.showFrame();
        ModulePackager modulePackager = new ModulePackager(propsFile, new File("bin/"));
        modulePackager.writeToDir(new File("../OpenConcerto/Modules"));
        ModuleManager.getInstance().addFactories(new File("../OpenConcerto/Modules"));
        ModuleManager.getInstance().addFactoryAndStart((ModuleFactory)factory, false);
        Gestion.main((String[])args);
    }
}

