/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.ListChange;

public abstract class ListChangeIndex<T>
implements ListChange<T> {
    private final int index0;
    private final int index1;

    protected static final <T> Collection<T> copy(Collection<T> col) {
        Collection<T> res;
        try {
            res = CopyUtils.copy(col);
        }
        catch (RuntimeException e) {
            res = new ArrayList<T>(col);
        }
        return res;
    }

    public ListChangeIndex(int index0, int index1) {
        this.index0 = index0;
        this.index1 = index1;
    }

    protected final int getIndex0() {
        return this.index0;
    }

    protected final int getIndex1() {
        return this.index1;
    }

    public abstract Collection<? extends T> getItemsAdded();

    public abstract List<? extends T> getItemsRemoved();

    public static class Add<T>
    extends ListChangeIndex<T> {
        private final Collection<? extends T> added;

        public Add(int index0, Collection<? extends T> added) {
            super(index0, index0);
            this.added = Add.copy(added);
        }

        @Override
        public <U> void apply(List<U> l, ITransformer<T, U> transf) {
            ArrayList toAdd = new ArrayList();
            for (T t : this.added) {
                toAdd.add(transf.transformChecked(t));
            }
            l.addAll(this.getIndex0(), toAdd);
        }

        @Override
        public Collection<? extends T> getItemsAdded() {
            return this.added;
        }

        @Override
        public List<? extends T> getItemsRemoved() {
            return Collections.emptyList();
        }

        public String toString() {
            return "@" + this.getIndex0() + " added " + this.getItemsAdded();
        }
    }

    public static class Rm<T>
    extends ListChangeIndex<T> {
        private final List<T> removed;

        public Rm(int index0, int index1, List<T> removed) {
            super(index0, index1);
            this.removed = (List)Rm.copy(removed);
        }

        @Override
        public <U> void apply(List<U> l, ITransformer<T, U> transf) {
            l.subList(this.getIndex0(), this.getIndex1() + 1).clear();
        }

        @Override
        public List<? extends T> getItemsAdded() {
            return Collections.emptyList();
        }

        @Override
        public List<T> getItemsRemoved() {
            return this.removed;
        }

        public String toString() {
            return "@" + this.getIndex0() + ";" + this.getIndex1() + " removed " + this.getItemsRemoved();
        }
    }

    public static class Set<T>
    extends ListChangeIndex<T> {
        private final T removed;
        private final T added;

        public Set(int index, T removed, T added) {
            super(index, index);
            this.removed = removed;
            this.added = added;
        }

        @Override
        public <U> void apply(List<U> l, ITransformer<T, U> transf) {
            l.set(this.getIndex0(), transf.transformChecked(this.added));
        }

        @Override
        public List<? extends T> getItemsAdded() {
            return Collections.singletonList(this.added);
        }

        @Override
        public List<? extends T> getItemsRemoved() {
            return Collections.singletonList(this.removed);
        }

        public String toString() {
            return "@" + this.getIndex0() + " replaced " + this.removed + " by " + this.added;
        }
    }
}

