/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openconcerto.ui.EnhancedTableColumn;

public class LightEventJTable
extends JTable {
    private boolean blockRepaint = false;
    long lastRepaint = 0L;

    public LightEventJTable(TableModel model) {
        super(model);
    }

    @Override
    public void createDefaultColumnsFromModel() {
        this.setBlockRepaint(true);
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            int i = 0;
            while (i < m.getColumnCount()) {
                EnhancedTableColumn newColumn = new EnhancedTableColumn(i);
                this.addColumn(newColumn);
                ++i;
            }
        }
        this.setBlockRepaint(false);
    }

    public void setBlockEventOnColumn(boolean blockRepaint) {
        TableColumnModel cm = this.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            EnhancedTableColumn newColumn = (EnhancedTableColumn)cm.getColumn(i);
            newColumn.setBlockEvent(blockRepaint);
            ++i;
        }
    }

    public void setBlockRepaint(boolean blockRepaint) {
        this.blockRepaint = blockRepaint;
    }

    @Override
    public void updateUI() {
        this.setBlockRepaint(true);
        super.updateUI();
        this.setBlockRepaint(false);
    }

    @Override
    public void doLayout() {
        this.setBlockRepaint(true);
        super.doLayout();
        this.setBlockRepaint(false);
    }

    @Override
    protected void initializeLocalVars() {
        this.setBlockRepaint(true);
        super.initializeLocalVars();
        this.setBlockRepaint(false);
    }

    @Override
    public void repaint() {
        if (!this.blockRepaint) {
            super.repaint();
        }
    }
}

