/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;

public class AutoHideTabbedPane
extends JPanel {
    private static final String TITLE_PROP = String.valueOf(AutoHideTabbedPane.class.getName()) + " title prop";
    private static final String ICON_PROP = String.valueOf(AutoHideTabbedPane.class.getName()) + " icon prop";
    private static final String TOOLTIP_PROP = String.valueOf(AutoHideTabbedPane.class.getName()) + " tooltip prop";
    private final JTabbedPane tabbedPane;
    private final Map<JComponent, IClosure<Tuple2<JTabbedPane, Integer>>> customizers;

    public AutoHideTabbedPane() {
        this(new JTabbedPane());
    }

    public AutoHideTabbedPane(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        this.customizers = new IdentityHashMap<JComponent, IClosure<Tuple2<JTabbedPane, Integer>>>();
        this.setLayout(new GridLayout(1, 1));
    }

    public final void addTab(String title, JComponent comp) {
        comp.setOpaque(false);
        this.insertTab(title, null, comp, null, -1);
    }

    public final void insertTab(String title, Icon icon, JComponent comp, String tip, int index) {
        this.insertTab(title, icon, comp, tip, index, null);
    }

    public final void insertTab(String title, Icon icon, JComponent comp, String tip, int index, IClosure<Tuple2<JTabbedPane, Integer>> customize) {
        this.customizers.put(comp, customize);
        if (this.getComponentCount() == 0) {
            this.putClientProps(title, icon, comp, tip);
            this.add(comp);
        } else {
            JTabbedPane tabbedPane = this.getDisplayedTabbedPane();
            if (tabbedPane == null) {
                JComponent onlyComp = (JComponent)this.getComponent(0);
                this.remove(0);
                tabbedPane = this.tabbedPane;
                tabbedPane.addTab((String)onlyComp.getClientProperty(TITLE_PROP), (Icon)onlyComp.getClientProperty(ICON_PROP), onlyComp, (String)onlyComp.getClientProperty(TOOLTIP_PROP));
                IClosure<Tuple2<JTabbedPane, Integer>> closure = this.customizers.get(onlyComp);
                if (closure != null) {
                    closure.executeChecked(Tuple2.create(tabbedPane, 0));
                }
                this.add(tabbedPane);
                assert (tabbedPane == this.getDisplayedTabbedPane());
            }
            int realIndex = index < 0 ? tabbedPane.getTabCount() : index;
            tabbedPane.insertTab(title, icon, comp, tip, realIndex);
            if (customize != null) {
                customize.executeChecked(Tuple2.create(tabbedPane, realIndex));
            }
        }
        assert (this.customizers.size() == this.getTabContainer().getComponentCount());
        this.revalidate();
        this.repaint();
    }

    private final void putClientProps(String title, Icon icon, JComponent comp, String tip) {
        comp.putClientProperty(TITLE_PROP, title);
        comp.putClientProperty(ICON_PROP, icon);
        comp.putClientProperty(TOOLTIP_PROP, tip);
    }

    protected final JTabbedPane getDisplayedTabbedPane() {
        if (this.getComponentCount() == 0) {
            return null;
        }
        Component res = this.getComponent(0);
        return res instanceof JTabbedPane ? (JTabbedPane)res : null;
    }

    private final Container getTabContainer() {
        JTabbedPane tabbedPane = this.getDisplayedTabbedPane();
        return tabbedPane == null ? this : tabbedPane;
    }
}

