/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.apache.commons.collections.CollectionUtils;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.view.list.ChangeAllRunnable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.UpdateRunnable;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.SleepingQueue;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

final class UpdateQueue
extends SleepingQueue {
    private final ITableModel tableModel;
    private final TableListener tableListener;
    private boolean alwaysUpdateAll = false;

    static boolean isUpdate(FutureTask<?> f) {
        return f instanceof IFutureTask && ((IFutureTask)f).getRunnable() instanceof UpdateRunnable;
    }

    private static boolean isCancelableUpdate(FutureTask<?> f) {
        return UpdateQueue.isUpdate(f) && !(((IFutureTask)f).getRunnable() instanceof UpdateRunnable.RmAllRunnable);
    }

    public UpdateQueue(ITableModel model) {
        super(String.valueOf(UpdateQueue.class.getSimpleName()) + " on " + model);
        this.tableModel = model;
        this.tableListener = new TableListener();
        this.addTableListener();
    }

    @Override
    protected void dying() {
        this.rmTableListener();
        super.dying();
    }

    private void addTableListener() {
        for (SQLTable t : this.tableModel.getReq().getTables()) {
            t.addTableModifiedListener(this.tableListener);
        }
        this.tableModel.getLinesSource().addListener(this.tableListener);
    }

    private void rmTableListener() {
        for (SQLTable t : this.tableModel.getReq().getTables()) {
            t.removeTableModifiedListener(this.tableListener);
        }
        this.tableModel.getLinesSource().rmListener(this.tableListener);
    }

    void rowModified(SQLTableEvent evt) {
        int id = evt.getId();
        if (id < 0) {
            this.putUpdateAll();
        } else if (CollectionUtils.containsAny(this.tableModel.getReq().getLineFields(), evt.getFields())) {
            this.put(evt);
        }
    }

    final Set<SQLTable> getNotForeignTables() {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        SQLRowValues maxGraph = this.tableModel.getReq().getMaxGraph();
        maxGraph.getGraph().walk(maxGraph, res, new ITransformer<SQLRowValuesCluster.State<Set<SQLTable>>, Set<SQLTable>>(){

            public Set<SQLTable> transformChecked(SQLRowValuesCluster.State<Set<SQLTable>> input) {
                if (input.getPath().length() == 0 || input.isBackwards()) {
                    input.getAcc().add(input.getCurrent().getTable());
                }
                return input.getAcc();
            }
        }, RecursionType.BREADTH_FIRST, null);
        return res;
    }

    void rowAddedOrDeleted(SQLTableEvent evt) {
        if (evt.getId() < 0) {
            this.putUpdateAll();
        } else if (this.getNotForeignTables().contains(evt.getTable())) {
            this.put(evt);
        }
    }

    private void put(SQLTableEvent evt) {
        this.put(UpdateRunnable.create(this.tableModel, evt));
    }

    public void putUpdateAll() {
        this.put(UpdateRunnable.create(this.tableModel));
    }

    void putRemoveAll() {
        if (!this.isSleeping()) {
            throw new IllegalStateException("not sleeping");
        }
        this.put(UpdateRunnable.createRmAll(this, this.tableModel));
        this.setSleeping(false);
        this.putUpdateAll();
    }

    @Override
    protected void willPut(Runnable qr) throws InterruptedException {
        if (qr instanceof ChangeAllRunnable) {
            this.tasksDo(new IClosure<Deque<FutureTask<?>>>(){

                @Override
                public void executeChecked(Deque<FutureTask<?>> tasks) {
                    FutureTask br;
                    FutureTask<?> current = tasks.peekLast();
                    boolean onlyUpdateRunnable = true;
                    while (current != null && onlyUpdateRunnable) {
                        onlyUpdateRunnable = UpdateQueue.isCancelableUpdate(current);
                        if (!onlyUpdateRunnable) continue;
                        tasks.removeLast();
                        current = tasks.peekLast();
                    }
                    if (onlyUpdateRunnable && (br = UpdateQueue.this.getBeingRun()) != null && UpdateQueue.isCancelableUpdate(br)) {
                        br.cancel(true);
                    }
                }
            });
        }
    }

    private final class TableListener
    implements PropertyChangeListener,
    SQLTableModifiedListener {
        private TableListener() {
        }

        @Override
        public void tableModified(SQLTableEvent evt) {
            if (UpdateQueue.this.alwaysUpdateAll) {
                UpdateQueue.this.putUpdateAll();
            } else if (evt.getMode() == SQLTableEvent.Mode.ROW_UPDATED) {
                UpdateQueue.this.rowModified(evt);
            } else {
                UpdateQueue.this.rowAddedOrDeleted(evt);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            UpdateQueue.this.putUpdateAll();
        }
    }
}

