/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.OrderedSet;

public class RowValuesTableModel
extends AbstractTableModel {
    private List<SQLRowValues> rowValues = new ArrayList<SQLRowValues>();
    private OrderedSet<TableModelListener> tableModelListeners = new OrderedSet();
    protected SQLElement element;
    private int nbColumn;
    private List<SQLTableElement> list;
    private Map<String, Integer> mapColumnField = new HashMap<String, Integer>();
    private List<SQLField> requiredFields;
    private SQLField requiredField;
    private SQLField validationField;
    private SQLRowValues defautRow;
    private List<SQLRowValues> rowValuesDeleted = new ArrayList<SQLRowValues>();
    private boolean editable = true;
    protected static final ExecutorService runnableQueue = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public RowValuesTableModel() {
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField) {
        this(e, list, validField, true);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut) {
        this(e, list, validField, addDefault, rowParDefaut, null);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut, SQLField validationField) {
        this.init(e, list, validField, addDefault, rowParDefaut, validationField);
    }

    public RowValuesTableModel(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault) {
        this(e, list, validField, addDefault, null);
    }

    protected void init(SQLElement e, List<SQLTableElement> list, SQLField validField, boolean addDefault, SQLRowValues rowParDefaut, SQLField validationField) {
        this.element = e;
        this.requiredField = validField;
        this.requiredFields = new ArrayList<SQLField>();
        this.requiredFields.add(validField);
        this.validationField = validationField;
        this.list = list;
        this.nbColumn = list.size();
        this.defautRow = rowParDefaut != null ? rowParDefaut : new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        if (addDefault) {
            this.addRow(new SQLRowValues(this.defautRow));
        }
    }

    @Override
    public synchronized int getColumnCount() {
        return this.nbColumn;
    }

    @Override
    public int getRowCount() {
        this.checkEDT();
        return this.rowValues.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.editable) {
            return false;
        }
        SQLTableElement elt = this.list.get(columnIndex);
        boolean validate = false;
        boolean fieldValidate = false;
        if (this.validationField != null) {
            fieldValidate = elt.getField().getName().equalsIgnoreCase(this.validationField.getName());
            validate = this.getRowValuesAt(rowIndex).getBoolean(this.validationField.getName());
        }
        if (validate && fieldValidate) {
            return this.list.get(columnIndex).isCellEditable(this.getRowValuesAt(rowIndex));
        }
        return !validate && this.list.get(columnIndex).isCellEditable(this.getRowValuesAt(rowIndex));
    }

    @Override
    public synchronized Class<?> getColumnClass(int columnIndex) {
        return this.list.get(columnIndex).getElementClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        this.checkEDT();
        if (rowIndex >= this.rowValues.size()) {
            System.err.println("RowValuesTableModel: get(" + rowIndex + "," + columnIndex + ") rowIndex>" + this.rowValues.size());
            Thread.dumpStack();
            result = new Integer(0);
        } else {
            SQLRowValues val = this.rowValues.get(rowIndex);
            SQLTableElement sqlTableElem = this.list.get(columnIndex);
            result = sqlTableElem.getValueFrom(val);
        }
        return result;
    }

    private void checkEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
    }

    public void putValue(Object value, int rowIndex, String fieldName) {
        this.checkEDT();
        SQLRowValues rowVal = this.rowValues.get(rowIndex);
        rowVal.put(fieldName, value);
        for (SQLTableElement sqlTableElem : this.list) {
            sqlTableElem.fireModification(rowVal);
        }
        this.fireTableModelModified(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SQLRowValues rowVal;
        this.checkEDT();
        if (!this.editable) {
            return;
        }
        if (this.list.size() <= columnIndex) {
            return;
        }
        SQLTableElement sqlTableElem = this.list.get(columnIndex);
        Object realVal = sqlTableElem.convertEditorValueToModel(aValue, rowVal = this.rowValues.get(rowIndex));
        if (realVal == null || realVal.getClass() == this.getColumnClass(columnIndex)) {
            sqlTableElem.setValueFrom(rowVal, realVal);
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
        } else {
            System.err.println("RowValuesTableModel:setValueAt:" + realVal + "(" + realVal.getClass() + ") at (row:" + rowIndex + "/col:" + columnIndex + ")");
            Thread.dumpStack();
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        SQLTableElement sqlTableElem = this.list.get(columnIndex);
        return sqlTableElem.getColumnName();
    }

    public void commitData() {
        this.checkEDT();
        ArrayList<SQLRowValues> rowsToCommmit = new ArrayList<SQLRowValues>();
        rowsToCommmit.addAll(this.rowValues);
        try {
            int size = rowsToCommmit.size();
            int i = 0;
            while (i < size) {
                SQLRowValues r = (SQLRowValues)rowsToCommmit.get(i);
                SQLRow row = r.commit();
                r.setID(row.getIDNumber());
                ++i;
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Unable to commit rows", e);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    public void fireTableModelModified(int line) {
        this.fireTableRowsUpdated(line, line);
    }

    public int getColumnForField(String to) {
        if (this.mapColumnField.get(to) == null) {
            int columnIndex = 0;
            while (columnIndex < this.list.size()) {
                SQLTableElement sqlTableElem = this.list.get(columnIndex);
                if (sqlTableElem.getField() != null && sqlTableElem.getField().getName().equalsIgnoreCase(to)) {
                    this.mapColumnField.put(to, columnIndex);
                    return columnIndex;
                }
                ++columnIndex;
            }
            this.mapColumnField.put(to, -1);
            return -1;
        }
        return this.mapColumnField.get(to);
    }

    public void addNewRowAt(final int index) {
        this.checkEDT();
        if (index > this.getRowCount()) {
            throw new IllegalArgumentException(String.valueOf(index) + " > row count: " + this.getRowCount());
        }
        if (index < 0) {
            throw new IllegalArgumentException(String.valueOf(index) + " <0");
        }
        final SQLRowValues newRowParDefaut = new SQLRowValues(this.defautRow);
        final BigDecimal maxOrder = newRowParDefaut.getTable().getMaxOrder();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Number n;
                String orderField;
                SQLRowValues vals;
                if (index < RowValuesTableModel.this.getRowCount()) {
                    if (index > 0) {
                        SQLRowValues vals1 = (SQLRowValues)RowValuesTableModel.this.rowValues.get(index - 1);
                        SQLRowValues vals2 = (SQLRowValues)RowValuesTableModel.this.rowValues.get(index);
                        String orderField2 = vals1.getTable().getOrderField().getName();
                        Number n1 = (Number)vals1.getObject(orderField2);
                        Number n2 = (Number)vals2.getObject(orderField2);
                        if (n1 != null && n2 != null) {
                            double tmp = n2.doubleValue() - n1.doubleValue();
                            newRowParDefaut.put(orderField2, BigDecimal.valueOf(n1.doubleValue() + tmp / 2.0));
                        } else if (n1 != null) {
                            newRowParDefaut.put(orderField2, BigDecimal.valueOf(n1.doubleValue() + 0.1));
                        }
                    } else {
                        vals = (SQLRowValues)RowValuesTableModel.this.rowValues.get(index);
                        n = (Number)vals.getObject(orderField = vals.getTable().getOrderField().getName());
                        if (n != null) {
                            newRowParDefaut.put(orderField, BigDecimal.valueOf(n.doubleValue() - 0.1));
                        } else {
                            newRowParDefaut.put(orderField, BigDecimal.valueOf(maxOrder.doubleValue() + 0.1));
                        }
                    }
                } else if (RowValuesTableModel.this.getRowCount() > 0) {
                    vals = (SQLRowValues)RowValuesTableModel.this.rowValues.get(index - 1);
                    n = (Number)vals.getObject(orderField = vals.getTable().getOrderField().getName());
                    if (n != null) {
                        newRowParDefaut.put(orderField, BigDecimal.valueOf(n.doubleValue() + 1.0));
                    }
                } else {
                    newRowParDefaut.put(newRowParDefaut.getTable().getOrderField().getName(), maxOrder.doubleValue() + 1.0);
                }
                RowValuesTableModel.this.rowValues.add(index, newRowParDefaut);
                int size = RowValuesTableModel.this.tableModelListeners.size();
                int i = 0;
                while (i < size) {
                    TableModelListener l = (TableModelListener)RowValuesTableModel.this.tableModelListeners.get(i);
                    l.tableChanged(new TableModelEvent(RowValuesTableModel.this, index, index, -1, 1));
                    ++i;
                }
            }
        });
    }

    public void removeRowAt(int index) {
        this.checkEDT();
        if (index < 0) {
            return;
        }
        this.rowValuesDeleted.add(this.rowValues.remove(index));
        this.fireTableRowsDeleted(index, index);
    }

    public void removeRowsAt(int[] index) {
        this.checkEDT();
        if (index.length <= 0) {
            return;
        }
        ArrayList<SQLRowValues> rowVals = new ArrayList<SQLRowValues>(index.length);
        int[] nArray = index;
        int n = index.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            SQLRowValues rowValues2 = this.rowValues.get(i);
            rowVals.add(rowValues2);
            this.rowValuesDeleted.add(rowValues2);
            ++n2;
        }
        this.rowValues.removeAll(rowVals);
        this.fireTableDataChanged();
    }

    public void addNewRow() {
        this.addNewRowAt(this.getRowCount());
    }

    public boolean isLastRowValid() {
        return this.isRowValid(this.rowValues.size() - 1);
    }

    public boolean isRowValid(int index) {
        this.checkEDT();
        if (this.rowValues.size() == 0) {
            return true;
        }
        if (index < 0 || index >= this.rowValues.size()) {
            return false;
        }
        SQLRowValues row = this.rowValues.get(index);
        boolean valid = true;
        for (SQLField f : this.requiredFields) {
            Object object;
            valid = f.isKey() ? (valid &= !row.isForeignEmpty(f.getName())) : (valid &= (object = row.getObject(f.getName())) != null && object.toString().trim().length() > 0);
            if (!valid) break;
        }
        return valid;
    }

    public boolean isValidated() {
        boolean b = true;
        int i = 0;
        while (i < this.getRowCount()) {
            b &= this.isRowValid(i);
            ++i;
        }
        return b;
    }

    public final List<SQLTableElement> getList() {
        return this.list;
    }

    public void updateField(String field, SQLRowValues rowVals, String fieldCondition) {
        this.checkEDT();
        if (rowVals != null) {
            int stop = this.rowValues.size();
            int id = rowVals.getID();
            int i = 0;
            while (i < stop) {
                SQLRowValues r = this.rowValues.get(i);
                if (fieldCondition != null) {
                    Object o = r.getObject(fieldCondition);
                    if (o != null && ((Boolean)o).booleanValue()) {
                        if (id != -1) {
                            r.put(field, id);
                        } else {
                            r.put(field, rowVals);
                        }
                    } else {
                        r.put(field, 1);
                    }
                } else if (id != -1) {
                    r.put(field, id);
                } else {
                    r.put(field, rowVals);
                }
                ++i;
            }
            ArrayList<SQLRowValues> l = new ArrayList<SQLRowValues>(this.rowValuesDeleted);
            int i2 = 0;
            while (i2 < l.size()) {
                SQLRowValues rowVals2 = (SQLRowValues)l.get(i2);
                int idRow = rowVals2.getID();
                if (idRow != -1) {
                    try {
                        this.element.archive(idRow);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                } else {
                    rowVals2.putEmptyLink(field);
                }
                ++i2;
            }
            this.rowValuesDeleted.clear();
            if (id != -1) {
                this.commitData();
            }
        }
    }

    public void updateField(String field, int id) {
        this.updateField(field, id, null);
    }

    public void updateField(String field, int id, String fieldCondition) {
        if (id > 0) {
            this.updateField(field, this.element.getTable().getForeignTable(field).getRow(id).createUpdateRow(), fieldCondition);
        }
    }

    public void insertFrom(String field, int id) {
        this.insertFrom(field, id, -1);
    }

    public void insertFrom(final String field, final int id, final int exceptID) {
        this.checkEDT();
        if (id > 0) {
            runnableQueue.submit(new Runnable(){

                @Override
                public void run() {
                    SQLSelect sel = new SQLSelect();
                    SQLTable table = RowValuesTableModel.this.element.getTable();
                    sel.addSelectStar(table);
                    Where w = new Where((FieldRef)table.getField(field), "=", id);
                    w = w.and(new Where((FieldRef)table.getKey(), "!=", exceptID));
                    sel.setWhere(w);
                    sel.addFieldOrder(table.getOrderField());
                    final List<SQLRow> listOfRows = SQLRowListRSH.execute(sel);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowValuesTableModel.this.rowValues.clear();
                            int i = 0;
                            while (i < listOfRows.size()) {
                                SQLRow sqlRow = (SQLRow)listOfRows.get(i);
                                SQLRowValues row = sqlRow.createUpdateRow();
                                RowValuesTableModel.this.rowValues.add(row);
                                ++i;
                            }
                            RowValuesTableModel.this.fireTableModelModified(RowValuesTableModel.this.rowValues.size());
                        }
                    });
                }
            });
        }
    }

    public void insertFrom(final SQLRowAccessor rowVals) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread.dumpStack();
        }
        if (rowVals != null) {
            runnableQueue.submit(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<SQLRowValues> newRows = new ArrayList<SQLRowValues>();
                    if (rowVals.getID() > 1) {
                        SQLRow row = rowVals.getTable().getRow(rowVals.getID());
                        Collection collection = row.getReferentRows(RowValuesTableModel.this.element.getTable());
                        for (SQLRow row2 : collection) {
                            SQLRowValues rowVals2 = new SQLRowValues(RowValuesTableModel.this.element.getTable());
                            rowVals2.loadAbsolutelyAll(row2);
                            newRows.add(rowVals2);
                        }
                    } else {
                        Collection<? extends SQLRowAccessor> colRows = rowVals.getReferentRows();
                        for (SQLRowAccessor sQLRowAccessor : colRows) {
                            if (!sQLRowAccessor.getTable().getName().equalsIgnoreCase(RowValuesTableModel.this.element.getTable().getName())) continue;
                            newRows.add(sQLRowAccessor.asRowValues());
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RowValuesTableModel.this.rowValues.clear();
                            RowValuesTableModel.this.rowValues.addAll(newRows);
                            RowValuesTableModel.this.fireTableModelModified(RowValuesTableModel.this.rowValues.size());
                        }
                    });
                }
            });
        }
    }

    public void addRow(SQLRowValues row) {
        this.addRow(row, true);
    }

    public void addRow(final SQLRowValues row, final boolean fireModified) {
        this.checkEDT();
        runnableQueue.submit(new Runnable(){

            @Override
            public void run() {
                final BigDecimal maxOrder = RowValuesTableModel.this.element.getTable().getMaxOrder();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BigDecimal valueOf = BigDecimal.valueOf(maxOrder.doubleValue() + (double)RowValuesTableModel.this.rowValues.size() + 1.0);
                        row.put((this).RowValuesTableModel.this.element.getTable().getOrderField().getName(), valueOf);
                        RowValuesTableModel.this.rowValues.add(row);
                    }
                });
                if (fireModified) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (SQLTableElement sqlTableElem : RowValuesTableModel.this.list) {
                                sqlTableElem.fireModification(row);
                            }
                            RowValuesTableModel.this.fireTableRowsInserted(RowValuesTableModel.this.rowValues.size() - 1, RowValuesTableModel.this.rowValues.size() - 1);
                        }
                    });
                }
            }
        });
    }

    public void clearRows() {
        int size = this.rowValues.size();
        if (size > 0) {
            this.rowValues.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    public synchronized SQLTableElement getSQLTableElementAt(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.list.size()) {
            return this.list.get(columnIndex);
        }
        return null;
    }

    public synchronized int getColumnIndexForElement(SQLTableElement e) {
        int columnIndex = 0;
        while (columnIndex < this.list.size()) {
            SQLTableElement sqlTableElem = this.list.get(columnIndex);
            if (sqlTableElem.equals(e)) {
                return columnIndex;
            }
            ++columnIndex;
        }
        return -1;
    }

    public SQLRowValues getRowValuesAt(int rowIndex) {
        this.checkEDT();
        return this.rowValues.get(rowIndex);
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        this.checkEDT();
        int i = 0;
        while (i < this.tableModelListeners.size()) {
            TableModelListener l = (TableModelListener)this.tableModelListeners.get(i);
            l.tableChanged(event);
            ++i;
        }
    }

    @Override
    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    @Override
    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public int moveBy(int rowIndex, int inc) {
        this.checkEDT();
        int destIndex = rowIndex + inc;
        if (rowIndex >= 0 && destIndex >= 0 && rowIndex < this.rowValues.size() && destIndex < this.rowValues.size()) {
            SQLRowValues rowValues1 = this.rowValues.get(rowIndex);
            SQLRowValues rowValues2 = this.rowValues.get(destIndex);
            this.rowValues.set(rowIndex, rowValues2);
            this.rowValues.set(destIndex, rowValues1);
            Object ordre1 = rowValues1.getObject(rowValues1.getTable().getOrderField().getName());
            Object ordre2 = rowValues2.getObject(rowValues2.getTable().getOrderField().getName());
            rowValues1.put(rowValues1.getTable().getOrderField().getName(), ordre2);
            rowValues2.put(rowValues1.getTable().getOrderField().getName(), ordre1);
            this.fireTableRowsUpdated(rowIndex, destIndex);
            this.fireTableDataChanged();
        }
        return destIndex;
    }

    public List<SQLRowValues> getCopyOfValues() {
        this.checkEDT();
        ArrayList<SQLRowValues> vals = new ArrayList<SQLRowValues>(this.rowValues.size());
        for (SQLRowValues sqlRowValues : this.rowValues) {
            vals.add(sqlRowValues.asRowValues());
        }
        return vals;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public SQLElement getSQLElement() {
        return this.element;
    }

    public SQLField getRequiredField() {
        return this.requiredField;
    }

    public List<SQLField> getRequiredsField() {
        return this.requiredFields;
    }
}

