/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JComponentUtils;

public class RowValuesTableControlPanel
extends JPanel {
    private final RowValuesTable table;
    private final RowValuesTableModel model;
    private JButton buttonBas;
    private JButton buttonHaut;
    private JButton buttonAjouter;
    private JButton buttonInserer;
    private JButton buttonClone;
    private JButton buttonSuppr;

    public RowValuesTableControlPanel(RowValuesTable table) {
        this(table, null);
    }

    public RowValuesTableControlPanel(final RowValuesTable table, final List<JButton> l) {
        super(new GridBagLayout());
        if (table == null) {
            throw new IllegalArgumentException("RowValuesTable null");
        }
        this.model = table.getRowValuesTableModel();
        if (this.model == null) {
            throw new IllegalArgumentException("RowValuesTableModel null");
        }
        this.table = table;
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.buttonHaut = new JButton(new ImageIcon(IListFrame.class.getResource("fleche_haut.png")));
        this.buttonHaut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.deplacerDe(-1);
            }
        });
        this.add((Component)this.buttonHaut, c);
        this.buttonHaut.setEnabled(false);
        this.buttonBas = new JButton(new ImageIcon(IListFrame.class.getResource("fleche_bas.png")));
        this.buttonBas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.deplacerDe(1);
            }
        });
        ++c.gridx;
        this.add((Component)this.buttonBas, c);
        this.buttonBas.setEnabled(false);
        this.buttonAjouter = new JButton(TM.tr("addNewLine", new Object[0]));
        this.buttonAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.model.addNewRowAt(table.getRowCount());
            }
        });
        ++c.gridx;
        JComponentUtils.setMinimumWidth(this.buttonAjouter, 88);
        this.add((Component)this.buttonAjouter, c);
        this.buttonInserer = new JButton(TM.tr("insertNewLine", new Object[0]));
        this.buttonInserer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.model.addNewRowAt(table.getSelectedRow());
            }
        });
        this.buttonInserer.setEnabled(false);
        ++c.gridx;
        JComponentUtils.setMinimumWidth(this.buttonInserer, 85);
        this.add((Component)this.buttonInserer, c);
        this.buttonClone = new JButton(TM.tr("duplicateLine", new Object[0]));
        this.buttonClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RowValuesTableControlPanel.this.cloneLine(table.getSelectedRow());
            }
        });
        this.buttonClone.setEnabled(false);
        ++c.gridx;
        JComponentUtils.setMinimumWidth(this.buttonClone, 95);
        this.add((Component)this.buttonClone, c);
        this.buttonSuppr = new JButton(TM.tr("deleteLine", new Object[0]));
        this.buttonSuppr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TableCellEditor cellEditor = RowValuesTableControlPanel.this.table.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                RowValuesTableControlPanel.this.model.removeRowsAt(table.getSelectedRows());
                table.clearSelection();
            }
        });
        this.buttonSuppr.setEnabled(false);
        JComponentUtils.setMinimumWidth(this.buttonSuppr, 95);
        ++c.gridx;
        this.add((Component)this.buttonSuppr, c);
        if (l != null) {
            for (JButton button : l) {
                ++c.gridx;
                button.setEnabled(false);
                this.add((Component)button, c);
            }
        }
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                boolean b = table.getSelectedRow() >= 0;
                RowValuesTableControlPanel.this.buttonClone.setEnabled(b);
                RowValuesTableControlPanel.this.buttonSuppr.setEnabled(b);
                RowValuesTableControlPanel.this.buttonInserer.setEnabled(b);
                RowValuesTableControlPanel.this.buttonHaut.setEnabled(b);
                RowValuesTableControlPanel.this.buttonBas.setEnabled(b);
                if (l != null) {
                    for (JButton button : l) {
                        button.setEnabled(b);
                    }
                }
            }
        });
        ++c.gridx;
        c.weightx = 1.0;
        JPanel panelStuff = new JPanel();
        panelStuff.setOpaque(false);
        this.add((Component)panelStuff, c);
    }

    public void deplacerDe(int inc) {
        int rowIndex = this.table.getSelectedRow();
        int dest = this.model.moveBy(rowIndex, inc);
        this.table.getSelectionModel().setSelectionInterval(dest, dest);
    }

    private void cloneLine(int row) {
        if (row < 0) {
            System.err.println("RowValuesTableControlPanel.cloneLine() wrong selected line, index = " + row);
            Thread.dumpStack();
            return;
        }
        SQLRowValues rowVals = this.model.getRowValuesAt(row);
        SQLRowValues rowValsBis = new SQLRowValues(rowVals);
        rowValsBis.clearPrimaryKeys();
        rowValsBis.put(rowValsBis.getTable().getOrderField().getName(), null);
        this.model.getSQLElement().clearPrivateFields(rowValsBis);
        for (String elt : this.table.getClearCloneTableElement()) {
            if (!rowValsBis.getTable().getFieldsName().contains(elt)) continue;
            rowValsBis.putEmptyLink(elt);
        }
        this.model.addRow(rowValsBis);
    }
}

