/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.ListAccess;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.MoveQueue;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.UpdateQueue;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.TableSorter;

public class ITableModel
extends AbstractTableModel {
    private static Timer autoHibernateTimer = null;
    private static boolean defaultEditable = false;
    private final SQLTableModelLinesSource linesSource;
    private final List<String> colNames;
    private final PropertyChangeListener colListener;
    private final List<ListSQLLine> liste;
    private boolean updating = false;
    private boolean filledOnce = false;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final UpdateQueue updateQ;
    private boolean loading;
    private SleepState wantedState;
    private SleepState actualState;
    private int hibernateDelay;
    private TimerTask autoHibernate;
    private final AtomicInteger runSleep;
    private final SearchQueue searchQ;
    private boolean searching;
    private final MoveQueue moveQ;
    private boolean editable;
    private boolean debug = false;

    public static Timer getAutoHibernateTimer() {
        if (autoHibernateTimer == null) {
            autoHibernateTimer = new Timer(String.valueOf(ITableModel.class.getSimpleName()) + " auto-hibernate timer", true);
        }
        return autoHibernateTimer;
    }

    public static ListSQLLine getLine(TableModel m, int row) {
        if (m instanceof ITableModel) {
            return ((ITableModel)m).getRow(row);
        }
        if (m instanceof TableSorter) {
            TableSorter sorter = (TableSorter)m;
            return ITableModel.getLine(sorter.getTableModel(), sorter.modelIndex(row));
        }
        throw new IllegalArgumentException("neither ITableModel nor TableSorter : " + m);
    }

    public ITableModel(SQLTableModelSource src) {
        this.liste = new ArrayList<ListSQLLine>(100);
        this.editable = defaultEditable;
        this.linesSource = src.createLinesSource(this);
        this.colNames = new ArrayList<String>();
        this.colListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ITableModel.this.updateColNames();
            }
        };
        this.getReq().addColumnListener(this.colListener);
        this.updateColNames();
        this.updateQ = new UpdateQueue(this);
        this.loading = false;
        this.updateQ.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("beingRun")) {
                    final boolean isLoading = UpdateQueue.isUpdate((FutureTask)evt.getNewValue());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ITableModel.this.setLoading(isLoading);
                        }
                    });
                }
            }
        });
        this.wantedState = this.actualState = SleepState.AWAKE;
        this.setHibernateDelay(30);
        this.autoHibernate = null;
        this.runSleep = new AtomicInteger(0);
        this.searchQ = new SearchQueue(new ListAccess(this));
        this.searching = false;
        this.searchQ.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("beingRun")) {
                    final boolean isSearching = SearchQueue.isSearch((FutureTask)evt.getNewValue());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ITableModel.this.setSearching(isSearching);
                        }
                    });
                }
            }
        });
        this.moveQ = new MoveQueue(this);
        this.updateAll();
    }

    void print(String s) {
        this.print(s, Level.FINE);
    }

    void print(String s, Level l) {
        Log.get().log(l, this.getTable() + " " + this.hashCode() + " : " + s);
    }

    public void invokeLater(final Runnable r) {
        if (r == null) {
            return;
        }
        this.runnableAdded();
        this.updateQ.put(new Runnable(){

            @Override
            public void run() {
                try {
                    ITableModel.this.getSearchQueue().put(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(r);
                        }
                    });
                }
                finally {
                    ITableModel.this.runnableCompleted();
                }
            }
        });
    }

    public void updateAll() {
        this.updateQ.putUpdateAll();
    }

    void setList(List<ListSQLLine> liste) {
        this.setUpdating(true);
        this.liste.clear();
        this.liste.addAll(liste);
        this.filledOnce = true;
        this.print("liste filled : " + this.liste.size());
        this.fireTableDataChanged();
        this.setUpdating(false);
    }

    void addToList(ListSQLLine modifiedLine) {
        this.setUpdating(true);
        this.liste.add(modifiedLine);
        Collections.sort(this.liste);
        int index = this.indexFromID(modifiedLine.getID());
        this.fireTableRowsInserted(index, index);
        this.setUpdating(false);
    }

    void fullListChanged(ListSQLLine modifiedLine, Collection<Integer> modifiedFields) {
        boolean orderChanged;
        this.setUpdating(true);
        int index = this.indexFromID(modifiedLine.getID());
        if (index >= 0) {
            this.liste.set(index, modifiedLine);
            boolean afterPred = index > 0 ? modifiedLine.compareTo(this.liste.get(index - 1)) > 0 : true;
            boolean beforeSucc = index < this.liste.size() - 1 ? modifiedLine.compareTo(this.liste.get(index + 1)) < 0 : true;
            orderChanged = !afterPred || !beforeSucc;
        } else {
            this.liste.add(modifiedLine);
            orderChanged = true;
        }
        if (orderChanged) {
            Collections.sort(this.liste);
            this.fireTableDataChanged();
        } else if (modifiedFields == null) {
            this.fireTableRowsUpdated(index, index);
        } else {
            for (Integer i : modifiedFields) {
                if (i >= this.getColumnCount()) continue;
                this.fireTableCellUpdated(index, i);
            }
        }
        this.setUpdating(false);
    }

    void removeFromList(int id) {
        this.setUpdating(true);
        int index = this.indexFromID(id);
        if (index >= 0) {
            this.liste.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
        this.setUpdating(false);
    }

    protected void updateColNames() {
        this.setUpdating(true);
        this.colNames.clear();
        for (SQLTableModelColumn sQLTableModelColumn : this.getCols()) {
            this.colNames.add(this.isDebug() ? String.valueOf(sQLTableModelColumn.getName()) + " " + sQLTableModelColumn.getPaths().toString() : sQLTableModelColumn.getName());
        }
        this.fireTableStructureChanged();
        this.setUpdating(false);
    }

    public List<String> getColumnNames() {
        return this.colNames;
    }

    private List<? extends SQLTableModelColumn> getCols() {
        return this.isDebug() ? this.getReq().getAllColumns() : this.getReq().getColumns();
    }

    @Override
    public int getRowCount() {
        return this.liste.size();
    }

    public int getTotalRowCount() {
        return this.getSearchQueue().getFullListSize();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return String.valueOf(this.getColumnNames().get(columnIndex));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getReq().getColumn(columnIndex).getValueClass();
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.editable) {
            return false;
        }
        SQLTableModelColumn col = this.getReq().getColumn(columnIndex);
        return col.isEditable() && this.hasRight(col);
    }

    private boolean hasRight(SQLTableModelColumn col) {
        UserRights u = UserRightsManager.getCurrentUserRights();
        for (SQLTable t : new SQLFieldsSet(col.getFields()).getTables()) {
            if (TableAllRights.hasRight(u, "UPDATE_ROW", t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new IllegalArgumentException("!!!+ acces a la ligne :" + rowIndex + " et la taille est de:" + this.getRowCount());
        }
        return this.getRow(rowIndex).getList(columnIndex + 1).get(columnIndex);
    }

    public final ListSQLLine getRow(int rowIndex) {
        return this.liste.get(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.getRow(rowIndex).setValueAt(aValue, columnIndex);
    }

    public int idFromIndex(int index) {
        if (index >= 0 && this.liste.size() > index) {
            return this.getRow(index).getID();
        }
        return -1;
    }

    public int indexFromID(int id) {
        return ListSQLLine.indexFromID(this.liste, id);
    }

    final SearchQueue getSearchQueue() {
        return this.searchQ;
    }

    public synchronized void search(SearchSpec list, Runnable r) {
        this.getSearchQueue().setSearch(list);
        if (r != null) {
            this.getSearchQueue().put(r);
        }
    }

    public void moveBy(List<? extends SQLRowAccessor> rows, int inc) {
        this.moveQ.move(rows, inc);
    }

    ListSQLLine getDestLine(int rowID, int inc) {
        int rowIndex = this.indexFromID(rowID);
        if (rowIndex < 0) {
            return null;
        }
        int destIndex = rowIndex + inc;
        boolean min = false;
        int max = this.getRowCount() - 1;
        if (destIndex < 0) {
            destIndex = 0;
        } else if (destIndex > max) {
            destIndex = max;
        }
        if (destIndex != rowIndex) {
            return this.getRow(destIndex);
        }
        return null;
    }

    private synchronized void setUpdating(boolean searching) {
        boolean old = this.updating;
        if (old != searching) {
            this.updating = searching;
            this.supp.firePropertyChange("updating", old, this.updating);
        }
    }

    private void setLoading(boolean isLoading) {
        boolean old = this.loading;
        if (old != isLoading) {
            this.loading = isLoading;
            this.supp.firePropertyChange("loading", old, this.loading);
        }
    }

    public final boolean isLoading() {
        return this.loading;
    }

    private void setSearching(boolean searching) {
        boolean old = this.searching;
        if (old != searching) {
            this.searching = searching;
            this.supp.firePropertyChange("searching", old, this.searching);
        }
    }

    public final boolean isSearching() {
        return this.searching;
    }

    void setSleeping(boolean sleeping) {
        this.setSleeping(sleeping ? SleepState.SLEEPING : SleepState.AWAKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSleeping(SleepState state) {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            this.wantedState = state;
            this.sleepUpdated();
        }
    }

    public final void setHibernateDelay(int seconds) {
        this.hibernateDelay = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runnableAdded() {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            this.runSleep.incrementAndGet();
            this.sleepUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runnableCompleted() {
        AtomicInteger atomicInteger = this.runSleep;
        synchronized (atomicInteger) {
            this.runSleep.decrementAndGet();
            this.sleepUpdated();
        }
    }

    private void sleepUpdated() {
        SleepState res;
        if (this.runSleep.get() > 0) {
            res = SleepState.AWAKE;
        } else if (this.wantedState == this.actualState) {
            res = null;
        } else if (this.actualState == SleepState.AWAKE) {
            res = SleepState.SLEEPING;
        } else if (this.actualState == SleepState.SLEEPING) {
            res = this.wantedState;
        } else if (this.actualState == SleepState.HIBERNATING) {
            res = this.wantedState == SleepState.AWAKE ? this.wantedState : null;
        } else {
            throw new IllegalStateException("unknown state: " + (Object)((Object)this.actualState));
        }
        if (res != null) {
            this.setActual(res);
        }
    }

    private void setActual(SleepState state) {
        if (this.actualState != state) {
            this.print("changing state " + (Object)((Object)this.actualState) + " => " + (Object)((Object)state));
            this.actualState = state;
            if (this.autoHibernate != null) {
                this.autoHibernate.cancel();
            }
            switch (this.actualState) {
                case AWAKE: {
                    this.updateQ.setSleeping(false);
                    break;
                }
                case SLEEPING: {
                    this.updateQ.setSleeping(true);
                    if (this.hibernateDelay < 0) break;
                    this.autoHibernate = new TimerTask(){

                        @Override
                        public void run() {
                            try {
                                ITableModel.this.setSleeping(SleepState.HIBERNATING);
                            }
                            catch (Exception e) {
                                ITableModel.this.print("HIBERNATING failed : " + e.getMessage(), Level.WARNING);
                                e.printStackTrace();
                            }
                        }
                    };
                    ITableModel.getAutoHibernateTimer().schedule(this.autoHibernate, this.hibernateDelay * 1000);
                    break;
                }
                case HIBERNATING: {
                    this.updateQ.putRemoveAll();
                }
            }
            this.sleepUpdated();
        }
    }

    public final SQLTableModelLinesSource getLinesSource() {
        return this.linesSource;
    }

    public final SQLTableModelSource getReq() {
        return this.linesSource.getParent();
    }

    public final SQLTable getTable() {
        return this.getReq().getPrimaryTable();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(propName, l);
    }

    public void rmPropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public void rmPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(propName, l);
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
        this.updateColNames();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + this.hashCode() + " for " + this.getTable();
    }

    @Override
    public synchronized void addTableModelListener(TableModelListener l) {
        if (this.isDead()) {
            throw new IllegalStateException("dead tableModel: " + this);
        }
        super.addTableModelListener(l);
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
        if (this.listenerList.getListenerCount() == 0) {
            this.print("dying");
            if (this.autoHibernate != null) {
                this.autoHibernate.cancel();
            }
            this.updateQ.die();
            this.getSearchQueue().die();
            this.moveQ.die();
            this.getLinesSource().die();
            this.getReq().rmColumnListener(this.colListener);
        }
    }

    private final synchronized boolean isDead() {
        return this.updateQ != null && this.updateQ.isDead();
    }

    public static enum SleepState {
        AWAKE,
        SLEEPING,
        HIBERNATING;

    }
}

