/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.UpdateRunnable;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

abstract class AbstractUpdateOneRunnable
extends UpdateRunnable {
    public AbstractUpdateOneRunnable(ITableModel model, SQLRow r) {
        super(model, r);
        if (this.getID() < 0) {
            throw new IllegalArgumentException("id is not valid : " + this.getID());
        }
    }

    protected final CollectionMap<Path, ListSQLLine> getAffectedPaths() {
        return this.getSearchQ().getAffectedPaths(this.getRow());
    }

    protected final void updateLines(CollectionMap<Path, ListSQLLine> paths) {
        for (Map.Entry<Path, Collection<ListSQLLine>> e : paths.entrySet()) {
            Path p = e.getKey();
            List lines = (List)e.getValue();
            if (lines.isEmpty()) continue;
            SQLRowValues proto = this.getModel().getLinesSource().getParent().getMaxGraph().followPathToOne(p, SQLRowValues.CreateMode.CREATE_NONE, false).deepCopy();
            String lastReferentField = SearchQueue.getLastReferentField(p);
            if (lastReferentField != null) {
                proto.put(lastReferentField, null);
            } else {
                proto.clearReferents();
                proto.retainAll(this.getModifedFields());
            }
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(proto);
            BaseFillSQLRequest.setupForeign(fetcher);
            ITransformer<SQLSelect, SQLSelect> transf = new ITransformer<SQLSelect, SQLSelect>(){

                public SQLSelect transformChecked(SQLSelect input) {
                    if (ListSQLRequest.getDefaultLockSelect()) {
                        input.addWaitPreviousWriteTXTable(AbstractUpdateOneRunnable.this.getTable().getName());
                    }
                    return input.setWhere(new Where((FieldRef)AbstractUpdateOneRunnable.this.getTable().getKey(), "=", AbstractUpdateOneRunnable.this.getID()));
                }
            };
            fetcher.setSelTransf(transf);
            List<SQLRowValues> fetched = fetcher.fetch();
            if (fetched.size() > 1) {
                throw new IllegalStateException("more than one row fetched for " + this + " with " + fetcher.getReq() + " :\n" + fetched);
            }
            if (fetched.size() == 0 && lastReferentField == null) {
                Log.get().fine("no row fetched for " + this + ", lines have been changed without the TableModel knowing : " + lines + " req :\n" + fetcher.getReq());
                this.getModel().updateAll();
                continue;
            }
            SQLRowValues soleFetched = CollectionUtils.getSole(fetched);
            for (ListSQLLine line : lines) {
                line.loadAt(this.getID(), soleFetched, p);
            }
        }
    }

    protected abstract Collection<String> getModifedFields();
}

