/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import com.mysql.jdbc.ConnectionProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.RTInterruptedException;

public class SQLUtils {
    private static final Pattern splitMySQLQueries = Pattern.compile(";\r?\n");
    public static final Pattern SPLIT_PATTERN = Pattern.compile("$jdbcDelimiter$", 16);

    public static final SQLException findWithSQLState(Exception exn) {
        Throwable e = exn;
        while (e != null) {
            SQLException sqlExn;
            if (e instanceof SQLException && (sqlExn = (SQLException)e).getSQLState() != null) {
                return sqlExn;
            }
            e = e.getCause();
        }
        return null;
    }

    public static <T> T executeAtomic(SQLDataSource ds, final SQLFactory<T> f) throws SQLException {
        return SQLUtils.executeAtomic(ds, new ConnectionHandlerNoSetup<T, SQLException>(){

            @Override
            public T handle(SQLDataSource ds) throws SQLException {
                return f.create();
            }
        });
    }

    public static <T, X extends Exception> T executeAtomic(SQLDataSource ds, final ConnectionHandlerNoSetup<T, X> h) throws SQLException, X {
        return ds.useConnection(new ConnectionHandler<T, X>(){
            private Boolean autoCommit = null;

            @Override
            public boolean canRestoreState() {
                return true;
            }

            @Override
            public void setup(Connection conn) throws SQLException {
                this.autoCommit = conn.getAutoCommit();
                if (this.autoCommit.booleanValue()) {
                    conn.setAutoCommit(false);
                }
            }

            @Override
            public T handle(SQLDataSource ds) throws Exception, SQLException {
                return h.handle(ds);
            }

            @Override
            public void restoreState(Connection conn) throws SQLException {
                if (this.autoCommit == Boolean.TRUE) {
                    try {
                        try {
                            this.get();
                            conn.commit();
                        }
                        catch (Exception e) {
                            conn.rollback();
                            conn.setAutoCommit(true);
                        }
                    }
                    finally {
                        conn.setAutoCommit(true);
                    }
                }
            }
        });
    }

    public static void executeScript(String sql, DBSystemRoot sysRoot) throws SQLException {
        SQLSystem sys = sysRoot.getServer().getSQLSystem();
        Pattern p = sys == SQLSystem.MYSQL || sys == SQLSystem.MSSQL ? splitMySQLQueries : SPLIT_PATTERN;
        SQLUtils.executeScript(sql, sysRoot, p);
    }

    public static void executeScript(String sql, DBSystemRoot sysRoot, Pattern p) throws SQLException {
        try {
            String[] stringArray = p.split(sql);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String trimmed = s.trim();
                if (trimmed.length() > 0) {
                    sysRoot.getDataSource().execute(trimmed, (ResultSetHandler)null);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new SQLException("unable to execute " + sql, e);
        }
    }

    public static List<?> executeMultiple(final DBSystemRoot sysRoot, final List<String> queries, final List<? extends ResultSetHandler> handlers) throws SQLException, RTInterruptedException {
        final int size = handlers.size();
        if (queries.size() != size) {
            throw new IllegalArgumentException("Size mismatch " + queries + " / " + handlers);
        }
        final ArrayList results = new ArrayList(size);
        final SQLSystem system = sysRoot.getServer().getSQLSystem();
        if (system.isMultipleResultSetsSupported()) {
            long time;
            final long timeMs = System.currentTimeMillis();
            final long afterCache = time = System.nanoTime();
            StringBuilder sb = new StringBuilder(256 * size);
            for (String q : queries) {
                sb.append(q);
                if (!q.trim().endsWith(";")) {
                    sb.append(';');
                }
                sb.append('\n');
            }
            final String query = sb.toString();
            sysRoot.getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    long afterHandle;
                    long afterExecute;
                    ConnectionProperties connectionProperties;
                    Connection conn = ds.getConnection();
                    if (system == SQLSystem.MYSQL && !(connectionProperties = (ConnectionProperties)((DelegatingConnection)conn).getInnermostDelegate()).getAllowMultiQueries()) {
                        throw new IllegalStateException("Multi queries not allowed and the setting can only be set before connecting");
                    }
                    long afterQueryInfo = System.nanoTime();
                    Statement stmt = conn.createStatement();
                    try {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new RTInterruptedException("Interrupted before executing : " + query);
                        }
                        stmt.execute(query);
                        afterExecute = System.nanoTime();
                        for (ResultSetHandler h : handlers) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new RTInterruptedException("Interrupted while handling results : " + query);
                            }
                            results.add(h == null ? null : h.handle(stmt.getResultSet()));
                            stmt.getMoreResults();
                        }
                        afterHandle = System.nanoTime();
                    }
                    finally {
                        stmt.close();
                    }
                    SQLRequestLog.log(query, "executeMultiple", conn, timeMs, time, afterCache, afterQueryInfo, afterExecute, afterHandle, System.nanoTime());
                    return null;
                }
            });
        } else {
            sysRoot.getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    int i = 0;
                    while (i < size) {
                        ResultSetHandler rsh = (ResultSetHandler)handlers.get(i);
                        results.add(sysRoot.getDataSource().execute((String)queries.get(i), rsh == null ? null : new IResultSetHandler(rsh, false)));
                        ++i;
                    }
                    return null;
                }
            });
        }
        return results;
    }

    public static interface SQLFactory<T> {
        public T create() throws SQLException;
    }
}

