/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.FileUtils;

public class Copy {
    private final boolean store;
    private final boolean noStruct;
    private final boolean noData;
    private final File dir;
    private final DBSystemRoot sysRoot;

    public Copy(boolean store, File dir, DBSystemRoot base, boolean noStruct, boolean noData) throws SQLException, IOException {
        this.store = store;
        this.noStruct = noStruct;
        this.noData = noData;
        this.dir = dir;
        FileUtils.mkdir_p(dir);
        this.sysRoot = base;
    }

    public final void applyTo(String rootName, String tableName) throws SQLException, IOException {
        this.applyTo(rootName, rootName, tableName);
    }

    public final void applyTo(final String rootName, final String newRootName, final String tableName) throws SQLException, IOException {
        SQLUtils.executeAtomic(this.sysRoot.getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException, IOException {
                Copy.this.applyToP(rootName, newRootName == null ? rootName : newRootName, tableName);
                return null;
            }
        });
    }

    private void applyToP(String rootName, String newRootName, String tableName) throws IOException, SQLException {
        DBRoot r;
        DBRoot dBRoot = r = this.sysRoot.contains(rootName) ? this.sysRoot.getRoot(rootName) : null;
        if (!this.noStruct) {
            System.err.print("Structure... ");
            if (this.store) {
                SQLTable t;
                if (r == null) {
                    throw new IllegalArgumentException(String.valueOf(rootName) + " does not exist in " + this.sysRoot);
                }
                if (tableName != null) {
                    t = r.getTable(tableName);
                    if (t == null) {
                        throw new IllegalArgumentException(String.valueOf(tableName) + " does not exist in " + r);
                    }
                } else {
                    t = null;
                }
                File rootDir = this.getDir(newRootName);
                rootDir.delete();
                rootDir.mkdirs();
                SQLSystem[] sQLSystemArray = SQLSystem.values();
                int n = sQLSystemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SQLSystem sys = sQLSystemArray[n2];
                    if (sys.getSyntax() != null) {
                        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.getSQLFile(newRootName, tableName, sys)), "UTF8");
                        if (t != null) {
                            w.write(t.getCreateTable(sys).asString(newRootName));
                        } else {
                            w.write(r.getDefinitionSQL(sys).asString(newRootName));
                        }
                        ((Writer)w).close();
                    }
                    ++n2;
                }
            } else {
                SQLSystem system = this.sysRoot.getServer().getSQLSystem();
                String sql = FileUtils.read(this.getSQLFile(rootName, tableName, system), "UTF8");
                if (system == SQLSystem.MSSQL) {
                    SQLUtils.executeScript(sql, this.sysRoot);
                } else {
                    this.sysRoot.getDataSource().execute(sql);
                }
                this.sysRoot.refetch(Collections.singleton(rootName));
                r = this.sysRoot.getRoot(rootName);
            }
            System.err.println("done");
        }
        if (!this.noData) {
            Set<String> tableNames;
            System.err.println("Data... ");
            SQLSyntax syntax = this.sysRoot.getServer().getSQLSystem().getSyntax();
            Set<String> set = tableNames = tableName == null ? null : Collections.singleton(tableName);
            if (this.store) {
                syntax.storeData(r, tableNames, this.getDir(newRootName));
            } else {
                syntax.loadData(this.getDir(rootName), r, tableNames, Boolean.getBoolean("deleteTable"));
            }
            System.err.println("Data done");
        }
    }

    private File getDir(String rootName) {
        return new File(this.dir, rootName);
    }

    private File getSQLFile(String rootName, String tableName, SQLSystem system) {
        String t = tableName == null ? "" : String.valueOf(tableName) + "-";
        return new File(this.getDir(rootName), String.valueOf(t) + system.name().toLowerCase() + ".sql");
    }
}

