/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.sql.view.search.SearchSpecUtils;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.component.combo.Log;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.SwingWorker2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.MutableValueObject;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.model.NewSelection;

public class IComboModel
extends DefaultIMutableListModel<IComboSelectionItem>
implements SQLTableModifiedListener,
EmptyObj,
MutableValueObject<IComboSelectionItem> {
    private final ComboSQLRequest req;
    private boolean filledOnce = false;
    private ITransformer<List<IComboSelectionItem>, IComboSelectionItem> firstFillTransf = null;
    private boolean isADirtyDrityGirl = true;
    private boolean isOnScreen = false;
    private boolean sleepAllowed = true;
    private final EmptyChangeSupport emptySupp;
    private final PropertyChangeSupport propSupp;
    private SwingWorker2<?, ?> willUpdate;
    protected final List<Runnable> runnables;
    private boolean updating;
    private int idToSelect;
    private Map<Integer, IComboSelectionItem> itemsByID;
    private SearchSpec search;
    private PropertyChangeListener filterListener;
    private boolean running;
    private boolean debug = false;
    private boolean addMissingItem;

    public IComboModel(ComboSQLRequest req) {
        if (req == null) {
            throw new NullPointerException("null request");
        }
        this.req = req;
        this.emptySupp = new EmptyChangeSupport(this);
        this.propSupp = new PropertyChangeSupport(this);
        this.idToSelect = -1;
        this.search = null;
        this.runnables = new ArrayList<Runnable>();
        this.setWillUpdate(null);
        this.itemsByID = new HashMap<Integer, IComboSelectionItem>();
        this.addMissingItem = true;
        this.running = false;
        this.setSelectOnAdd(false);
        this.setOnRemovingOrReplacingSelection(NewSelection.NO);
        this.uiInit();
    }

    public final boolean neverBeenFilled() {
        return !this.filledOnce;
    }

    private final ITransformer<List<IComboSelectionItem>, IComboSelectionItem> getFirstFillSelection() {
        return this.firstFillTransf;
    }

    private boolean isUndefIDEmpty() {
        return this.getRequest().getUndefLabel() == null;
    }

    private boolean isUndefIDEmpty(int id) {
        return this.isUndefIDEmpty() && id == this.getRequest().getPrimaryTable().getUndefinedID();
    }

    private final void uiInit() {
        this.filterListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IComboModel.this.fillCombo();
            }
        };
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() == -1 && e.getIndex1() == -1) {
                    IComboModel.this.comboValueChanged();
                } else {
                    IComboModel.this.itemsChanged();
                }
            }
        });
    }

    void setRunning(boolean b) {
        if (this.running != b) {
            this.running = b;
            if (this.running) {
                this.req.addTableListener(this);
                this.req.addWhereListener(this.filterListener);
                this.fillCombo();
            } else {
                this.req.removeTableListener(this);
                this.req.rmWhereListener(this.filterListener);
            }
        }
    }

    public final ComboSQLRequest getRequest() {
        return this.req;
    }

    private void log(String s) {
        if (this.debug) {
            Log.get().info(s);
        }
    }

    synchronized void setOnScreen(boolean isOnScreen) {
        if (this.isOnScreen != isOnScreen) {
            this.isOnScreen = isOnScreen;
            if (this.isOnScreen && this.isADirtyDrityGirl) {
                this.fillCombo();
            }
        }
    }

    private synchronized boolean isOnScreen() {
        return this.isOnScreen;
    }

    public final boolean isSleepAllowed() {
        return this.sleepAllowed;
    }

    public final synchronized void fillCombo() {
        this.fillCombo(null, true);
    }

    public final synchronized void fillCombo(Runnable r, boolean readCache) {
        if (!this.isSleepAllowed() || this.isOnScreen() || r != null) {
            this.doUpdateAll(r, readCache);
        } else {
            this.isADirtyDrityGirl = true;
        }
    }

    private void updateAllBegun() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IComboModel.this.updateAllBegun();
                }
            });
        } else {
            this.log("entering updateAllBegun");
            assert (!this.isUpdating()) : "Otherwise our modeToSelect = DISABLED and setEnabled() would overwrite modeToSelect";
            this.setUpdating(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateAll(Runnable r, final boolean readCache) {
        this.log("entering doUpdateAll");
        IComboModel iComboModel = this;
        synchronized (iComboModel) {
            this.isADirtyDrityGirl = false;
            if (this.willUpdate != null) {
                this.willUpdate.cancel(true);
            } else {
                this.updateAllBegun();
            }
            if (r != null) {
                this.runnables.add(r);
            }
            final SearchSpec search = this.getSearch();
            SwingWorker2<List<IComboSelectionItem>, Object> worker = new SwingWorker2<List<IComboSelectionItem>, Object>(){

                @Override
                protected List<IComboSelectionItem> doInBackground() throws InterruptedException {
                    Thread.sleep(50L);
                    return SearchSpecUtils.filter(IComboModel.this.req.getComboItems(readCache), search);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void done() {
                    IComboModel iComboModel = IComboModel.this;
                    synchronized (iComboModel) {
                        List items;
                        int idToSelect;
                        boolean firstFill;
                        block23: {
                            if (this.isCancelled() || IComboModel.this.willUpdate != this) {
                                return;
                            }
                            firstFill = !IComboModel.this.filledOnce;
                            idToSelect = IComboModel.this.idToSelect;
                            items = null;
                            try {
                                items = (List)this.get();
                                IComboModel.this.setAllItems(items);
                                IComboModel.this.filledOnce = true;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                    throw new AssertionError();
                                }
                                IComboModel.this.setWillUpdate(null);
                                break block23;
                            }
                            catch (CancellationException e) {
                                e.printStackTrace();
                                break block23;
                            }
                            catch (ExecutionException e) {
                                block24: {
                                    if (e.getCause() instanceof RTInterruptedException) break block24;
                                    e.printStackTrace();
                                    {
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                    }
                                }
                                if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                    throw new AssertionError();
                                }
                                IComboModel.this.setWillUpdate(null);
                                break block23;
                            }
                            {
                                finally {
                                    if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                        throw new AssertionError();
                                    }
                                    IComboModel.this.setWillUpdate(null);
                                }
                            }
                            if (!$assertionsDisabled && IComboModel.this.willUpdate != this) {
                                throw new AssertionError();
                            }
                            IComboModel.this.setWillUpdate(null);
                        }
                        if (items != null) {
                            boolean noSelection;
                            boolean bl = noSelection = idToSelect == -1;
                            if (items.size() == 1 && noSelection && Boolean.getBoolean("org.openconcerto.sql.sqlCombo.selectSoleItem")) {
                                IComboModel.this.setSelectedItem((IComboSelectionItem)items.get(0));
                            } else if (noSelection && firstFill && IComboModel.this.getFirstFillSelection() != null) {
                                IComboModel.this.setSelectedItem((IComboSelectionItem)IComboModel.this.getFirstFillSelection().transformChecked(items));
                            } else {
                                IComboModel.this.selectID(idToSelect);
                            }
                            for (Runnable r : IComboModel.this.runnables) {
                                r.run();
                            }
                            IComboModel.this.runnables.clear();
                        }
                    }
                }
            };
            this.setWillUpdate(worker);
            worker.execute();
        }
    }

    private DefaultIMutableListModel<IComboSelectionItem> getComboModel() {
        return this;
    }

    private void setAllItems(List<IComboSelectionItem> items) {
        this.getComboModel().setAllElements(items, false);
        this.itemsByID.clear();
        for (IComboSelectionItem item : items) {
            this.itemsByID.put(item.getId(), item);
        }
    }

    private void addItem(IComboSelectionItem item) {
        this.getComboModel().addElement(item);
        this.itemsByID.put(item.getId(), item);
    }

    private void removeItem(int id) {
        IComboSelectionItem removed = this.itemsByID.remove(id);
        if (removed != null) {
            this.getComboModel().removeElement(removed);
        }
    }

    private IComboSelectionItem getComboItem(int id) {
        assert (SwingUtilities.isEventDispatchThread());
        return this.itemsByID.get(id);
    }

    private void reloadComboItem(int id, IComboSelectionItem nItem) {
        assert (SwingUtilities.isEventDispatchThread());
        if (nItem == null) {
            this.removeItem(id);
        } else {
            IComboSelectionItem item = this.getComboItem(id);
            if (item != null) {
                boolean selectedID = this.getSelectedId() == id;
                this.getComboModel().replace(item, nItem);
                this.itemsByID.put(id, nItem);
                if (selectedID) {
                    this.setValue(id);
                }
            } else {
                this.fillCombo();
            }
        }
    }

    private final void itemsChanged() {
        List newVal = this.getList();
        this.propSupp.firePropertyChange("items", null, newVal);
    }

    @Override
    public final void resetValue() {
        this.setValue(null);
    }

    @Override
    public final void setValue(int id) {
        this.selectID(this.isUndefIDEmpty(id) ? -1 : id);
    }

    @Override
    public final void setValue(IComboSelectionItem o) {
        if (o == null) {
            this.setValue(-1);
        } else {
            this.setValue(o.getId());
        }
    }

    @Override
    public final IComboSelectionItem getValue() {
        if (!this.isUpdating()) {
            return this.getSelectedValue();
        }
        if (this.getWantedID() == -1) {
            return null;
        }
        return new IComboSelectionItem(this.getWantedID(), null);
    }

    public final IComboSelectionItem getSelectedValue() {
        return (IComboSelectionItem)this.getSelectedItem();
    }

    public final SQLTable getForeignTable() {
        return this.req.getPrimaryTable();
    }

    public final int getWantedID() {
        return this.idToSelect;
    }

    private final void setWantedID(int id) {
        if (this.idToSelect != id) {
            int old = this.idToSelect;
            this.idToSelect = id;
            this.propSupp.firePropertyChange("wantedID", old, id);
            this.propSupp.firePropertyChange("value", null, this.getValue());
            this.emptySupp.fireEmptyChange(this.isEmpty());
        }
    }

    public final int getSelectedId() {
        IComboSelectionItem o = this.getSelectedValue();
        if (o != null && o.getId() >= 0) {
            return o.getId();
        }
        return -1;
    }

    public final SQLRow getWantedRow() {
        if (this.isEmpty()) {
            return null;
        }
        IComboSelectionItem o = this.getValue();
        SQLRowAccessor r = o.getRow();
        if (r != null) {
            return r.asRow();
        }
        return new SQLRow(this.getForeignTable(), o.getId());
    }

    private final void comboValueChanged() {
        this.propSupp.firePropertyChange("selectedValue", null, this.getSelectedValue());
        if (!this.isUpdating()) {
            this.setWantedID(this.getSelectedId());
        }
    }

    private void selectID(int id) {
        this.log("entering selectID " + id);
        assert (SwingUtilities.isEventDispatchThread());
        if (this.neverBeenFilled() && !this.isUpdating()) {
            this.doUpdateAll(null, true);
        }
        if (this.isUpdating()) {
            this.setWantedID(id);
            this.log("isUpdating: this.idToSelect = " + id);
        } else if (id == -1) {
            this.setSelectedItem(null);
            this.log("NONEXISTANT_ID: setSelectedItem(null)");
        } else {
            IComboSelectionItem item = this.getComboItem(id);
            this.log("valid id : " + id + " item: " + item);
            if (item == null && this.addMissingItem()) {
                IComboSelectionItem newItem;
                ComboSQLRequest comboSQLRequest = new ComboSQLRequest(this.req);
                comboSQLRequest.setFilterEnabled(false);
                comboSQLRequest.setWhere(null);
                final ITransformer<SQLSelect, SQLSelect> transf = comboSQLRequest.getSelectTransf();
                if (transf != null) {
                    comboSQLRequest.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                        public SQLSelect transformChecked(SQLSelect input) {
                            SQLSelect res = (SQLSelect)transf.transformChecked(input);
                            res.setWhere(null);
                            return res;
                        }
                    });
                }
                if ((newItem = comboSQLRequest.getComboItem(id)) != null) {
                    newItem.setFlag(1);
                } else {
                    new IllegalStateException("ID " + id + " cannot be found in " + this.req).printStackTrace();
                    SQLRow row = new SQLRow(this.req.getPrimaryTable(), id);
                    String error = !row.exists() ? " inexistante" : (row.isArchived() ? " archiv\u00e9e" : " existe mais est non atteignable: " + row.findDistantArchived(2));
                    newItem = new IComboSelectionItem(id, "ERREUR !!! " + row + error);
                    newItem.setFlag(2);
                }
                this.addItem(newItem);
                this.setSelectedItem(newItem);
            } else {
                this.setSelectedItem(item);
            }
        }
    }

    public final boolean addMissingItem() {
        return this.addMissingItem;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.req;
    }

    @Override
    public final boolean isEmpty() {
        return this.getWantedID() == -1 || this.isUndefIDEmpty(this.getWantedID());
    }

    @Override
    public final void addEmptyListener(EmptyListener l) {
        this.emptySupp.addEmptyListener(l);
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.addListener("value", l);
    }

    public final void addListener(String propName, PropertyChangeListener l) {
        this.propSupp.addPropertyChangeListener(propName, l);
    }

    private boolean tableOnlyOnce() {
        SQLRowValues graphToFetch = this.req.getGraphToFetch();
        for (SQLRowValues item : graphToFetch.getGraph().getItems()) {
            if (item == graphToFetch || item.getTable() != graphToFetch.getTable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void tableModified(SQLTableEvent evt) {
        final int id = evt.getId();
        if (id >= 0 && this.getForeignTable().equals(evt.getTable()) && this.tableOnlyOnce()) {
            final IComboSelectionItem nItem = SearchSpecUtils.filterOne(this.req.getComboItem(id), this.getSearch());
            SwingThreadUtils.invoke(new Runnable(){

                @Override
                public void run() {
                    IComboModel.this.reloadComboItem(id, nItem);
                }
            });
        } else {
            this.fillCombo();
        }
    }

    private synchronized SearchSpec getSearch() {
        return this.search;
    }

    private synchronized void setWillUpdate(SwingWorker2<?, ?> w) {
        this.willUpdate = w;
        this.propSupp.firePropertyChange("willUpdate", null, this.willUpdate);
        if (this.willUpdate == null) {
            assert (SwingUtilities.isEventDispatchThread()) : "The end of an update should be in the EDT to be able change swing related attributes";
            this.setUpdating(false);
        }
    }

    private final void setUpdating(boolean b) {
        assert (SwingUtilities.isEventDispatchThread());
        this.updating = b;
        this.propSupp.firePropertyChange("updating", null, (Object)this.updating);
    }

    public final boolean isUpdating() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.updating;
    }
}

