/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.StringUtils;

public class SQLFieldTranslator {
    public static final RowItemDesc NULL_DESC = new RowItemDesc(null, null);
    private final Map<SQLTable, Map<List<String>, RowItemDesc>> translation = new HashMap<SQLTable, Map<List<String>, RowItemDesc>>();
    private final SQLTable table;
    private final SQLElementDirectory dir;
    private final Set<String> unknownCodes = new HashSet<String>();

    public static SQLTable getMetaTable(DBRoot root) throws SQLException {
        if (!root.contains("FWK_RIV_METADATA")) {
            SQLCreateTable createValueT = new SQLCreateTable(root, "FWK_RIV_METADATA");
            createValueT.setPlain(true);
            createValueT.addColumn("ID", createValueT.getSyntax().getPrimaryIDDefinition());
            String nullableVarChar = "varchar(80)";
            createValueT.addColumn("ELEMENT_CODE", "varchar(80)");
            createValueT.addColumn("COMPONENT_CODE", "varchar(80)");
            createValueT.addColumn("ITEM", "varchar(80) NOT NULL");
            createValueT.addUniqueConstraint("uniq", Arrays.asList("ELEMENT_CODE", "COMPONENT_CODE", "ITEM"));
            createValueT.addVarCharColumn("LABEL", 256);
            createValueT.addVarCharColumn("COLUMN_TITLE", 256);
            createValueT.addVarCharColumn("DOCUMENTATION", Math.min(8192, 8192));
            root.createTable(createValueT);
        }
        return root.getTable("FWK_RIV_METADATA");
    }

    public static RowItemDesc getDefaultDesc(SQLField f) {
        String name = f.getName();
        String label = null;
        if (f.isPrimaryKey()) {
            label = "ID";
        } else if (f.getTable().getForeignKeys().contains(f)) {
            String string = name = name.startsWith("ID_") ? name.substring("ID_".length()) : name;
        }
        if (label == null) {
            label = SQLFieldTranslator.cleanupName(name);
        }
        return new RowItemDesc(label, label);
    }

    private static String cleanupName(String name) {
        return StringUtils.firstUpThenLow(name).replace('_', ' ');
    }

    public SQLFieldTranslator(DBRoot root, InputStream inputStream, SQLElementDirectory dir) {
        try {
            this.table = SQLFieldTranslator.getMetaTable(root);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't get the meta table", e);
        }
        this.dir = dir;
        this.dir.addListener(new SQLElementDirectory.DirectoryListener(){

            @Override
            public void elementAdded(SQLElement elem) {
                if (SQLFieldTranslator.this.unknownCodes.remove(elem.getCode())) {
                    SQLFieldTranslator.this.fetch(Collections.singleton(elem.getCode()));
                }
            }
        });
        if (inputStream != null) {
            this.load(root, inputStream);
        }
        this.fetchAndPut(this.table, null);
    }

    public void putAll(SQLFieldTranslator o) {
        CollectionUtils.addIfNotPresent(this.translation, o.translation);
    }

    private static List<Element> getChildren(Element elem) {
        return elem.getChildren();
    }

    public void load(DBRoot b, InputStream inputStream) {
        this.load(b, "CORE", inputStream);
    }

    public Set<SQLTable> load(DBRoot b, String variant, InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        try {
            Document doc = new SAXBuilder().build(inputStream);
            for (Element elem : SQLFieldTranslator.getChildren(doc.getRootElement())) {
                String elemName = elem.getName().toLowerCase();
                if (elemName.equals("table")) {
                    res.add(this.load(b, variant, elem));
                    continue;
                }
                if (!elemName.equals("root")) continue;
                DBRoot root = b.getDBSystemRoot().getRoot(elem.getAttributeValue("name"));
                for (Element tableElem : SQLFieldTranslator.getChildren(elem)) {
                    res.add(this.load(root, variant, tableElem));
                }
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private SQLTable load(DBRoot b, String variant, Element tableElem) {
        String tableName = tableElem.getAttributeValue("name");
        SQLTable table = b.getTable(tableName);
        if (table == null && this.dir != null && this.dir.getElement(tableName) != null) {
            table = this.dir.getElement(tableName).getTable();
        }
        if (table == null) {
            Log.get().config("Ignore loading of inexistent table " + tableName);
        } else {
            for (Element elem : SQLFieldTranslator.getChildren(tableElem)) {
                String elemName = elem.getName().toLowerCase();
                if (elemName.equals("field")) {
                    this.load(table, "default component code", variant, elem);
                    continue;
                }
                if (!elemName.equals("component")) continue;
                String compCode = elem.getAttributeValue("code");
                for (Element fieldElem : SQLFieldTranslator.getChildren(elem)) {
                    this.load(table, compCode, variant, fieldElem);
                }
            }
        }
        return table;
    }

    private void load(SQLTable table, String compCode, String variant, Element fieldElem) {
        String name = fieldElem.getAttributeValue("name");
        String label = fieldElem.getAttributeValue("label");
        String title = fieldElem.getAttributeValue("titlelabel", label);
        String documentation = fieldElem.getText();
        this.setDescFor(table, compCode, variant, name, new RowItemDesc(label, title, documentation));
    }

    public final void fetch(Set<String> codes) {
        this.fetchAndPut(this.table, codes);
    }

    private List<SQLRow> fetchOnly(SQLTable table, Where w) {
        return SQLRowListRSH.execute(new SQLSelect(table.getBase()).addSelectStar(table).setWhere(w));
    }

    private void fetchAndPut(SQLTable table, Set<String> codes) {
        Where w;
        if (codes == null) {
            w = null;
            this.removeTranslation((SQLTable)null, (String)null, "DB", (String)null);
        } else {
            w = new Where(table.getField("ELEMENT_CODE"), codes);
            for (String elementCode : codes) {
                this.removeTranslation(this.dir.getElementForCode(elementCode).getTable(), null, "DB", null);
            }
        }
        for (SQLRow r : this.fetchOnly(table, w)) {
            String elementCode = r.getString("ELEMENT_CODE");
            if (this.unknownCodes.contains(elementCode)) continue;
            SQLElement elem = this.dir.getElementForCode(elementCode);
            if (elem != null) {
                String componentCode = r.getString("COMPONENT_CODE");
                String item = r.getString("ITEM");
                RowItemDesc desc = new RowItemDesc(r.getString("LABEL"), r.getString("COLUMN_TITLE"), r.getString("DOCUMENTATION"));
                this.putTranslation(elem.getTable(), componentCode, "DB", item, desc);
                continue;
            }
            this.unknownCodes.add(elementCode);
        }
    }

    private final Map<List<String>, RowItemDesc> getMap(SQLTable t) {
        Map<List<String>, RowItemDesc> elemMap = this.translation.get(t);
        if (elemMap == null) {
            elemMap = new HashMap<List<String>, RowItemDesc>();
            this.translation.put(t, elemMap);
        }
        return elemMap;
    }

    private final void putTranslation(SQLTable t, String compCode, String variant, String item, RowItemDesc desc) {
        if (t == null) {
            throw new IllegalArgumentException("Table cannot be null");
        }
        if (compCode == null || variant == null || item == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        this.getMap(t).put(Arrays.asList(compCode, variant, item), desc);
    }

    private final void removeTranslation(SQLTable t, String compCode, String variant, String name) {
        if (t == null) {
            for (Map<List<String>, RowItemDesc> m : this.translation.values()) {
                this.removeTranslation(m, compCode, variant, name);
            }
        } else {
            this.removeTranslation(this.translation.get(t), compCode, variant, name);
        }
    }

    private void removeTranslation(Map<List<String>, RowItemDesc> m, String compCode, String variant, String name) {
        if (m == null) {
            return;
        }
        if (compCode == null && variant == null && name == null) {
            m.clear();
        } else if (compCode != null && variant != null && name != null) {
            m.remove(Arrays.asList(compCode, variant, name));
        } else {
            Iterator<List<String>> iter = m.keySet().iterator();
            while (iter.hasNext()) {
                List<String> l = iter.next();
                if (compCode != null && !compCode.equals(l.get(0)) || variant != null && !variant.equals(l.get(1)) || name != null && !name.equals(l.get(2))) continue;
                iter.remove();
            }
        }
    }

    private final RowItemDesc getTranslation(SQLTable t, String compCode, String variant, String item) {
        return this.getMap(t).get(Arrays.asList(compCode, variant, item));
    }

    private final RowItemDesc getTranslation(SQLTable t, String compCodeArg, List<String> variants, String name) {
        LinkedList<String> ll = new LinkedList<String>(variants);
        ll.addFirst("DB");
        ll.addLast("CORE");
        String[] compCodes = compCodeArg == "default component code" ? new String[]{"default component code"} : new String[]{compCodeArg, "default component code"};
        String[] stringArray = compCodes;
        int n = compCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String compCode = stringArray[n2];
            for (String variant : ll) {
                RowItemDesc labeledField = this.getTranslation(t, compCode, variant, name);
                if (labeledField == null) continue;
                return labeledField;
            }
            ++n2;
        }
        return null;
    }

    public RowItemDesc getDescFor(SQLTable t, String name) {
        return this.getDescFor(t, "default component code", name);
    }

    public RowItemDesc getDescFor(SQLTable t, String compCode, String name) {
        SQLElement element = this.dir == null ? null : this.dir.getElement(t);
        List<String> variants = element == null ? Collections.emptyList() : element.getMDPath();
        return this.getDescFor(t, compCode, variants, name);
    }

    public RowItemDesc getDescFor(SQLTable t, String compCodeArg, List<String> variants, String name) {
        RowItemDesc labeledField = this.getTranslation(t, compCodeArg, variants, name);
        if (labeledField == null && this.dir.getElement(t) != null) {
            this.fetchAndPut(this.table, Collections.singleton(this.dir.getElement(t).getCode()));
            labeledField = this.getTranslation(t, compCodeArg, variants, name);
        }
        if (labeledField == null) {
            Log.get().info("unknown item " + name + " in " + t);
            return NULL_DESC;
        }
        return labeledField;
    }

    private RowItemDesc getDescFor(SQLField f) {
        return this.getDescFor(f.getTable(), f.getName());
    }

    public String getLabelFor(SQLField f) {
        return this.getDescFor(f).getLabel();
    }

    public String getTitleFor(SQLField f) {
        return this.getDescFor(f).getTitleLabel();
    }

    public final void setDescFor(SQLTable table, String componentCode, String variant, String name, RowItemDesc desc) {
        if ("DB".equals(variant)) {
            throw new IllegalArgumentException("Use storeDescFor()");
        }
        this.putTranslation(table, componentCode, variant, name, desc);
    }

    public final void storeDescFor(final SQLTable table, final String componentCode, final String name, final RowItemDesc desc) throws SQLException {
        String elementCode = this.dir.getElement(table).getCode();
        final HashMap<String, String> m = new HashMap<String, String>();
        m.put("ELEMENT_CODE", elementCode);
        m.put("COMPONENT_CODE", componentCode);
        m.put("ITEM", name);
        final SQLTable mdT = this.table;
        SQLUtils.executeAtomic(this.table.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                List existing = SQLFieldTranslator.this.fetchOnly(mdT, Where.and(mdT, m));
                if (!$assertionsDisabled && existing.size() > 1) {
                    throw new AssertionError((Object)("Unique constraint failed for " + m));
                }
                SQLRowValues vals = existing.size() == 0 ? new SQLRowValues(mdT, m) : ((SQLRow)existing.get(0)).asRowValues();
                vals.put("LABEL", desc.getLabel());
                vals.put("COLUMN_TITLE", desc.getTitleLabel());
                vals.put("DOCUMENTATION", desc.getDocumentation());
                vals.commit();
                SQLFieldTranslator.this.putTranslation(table, componentCode, "DB", name, desc);
                return null;
            }
        });
    }
}

