/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.LoadingListener;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.CopyOnWriteMap;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.CollectionChangeEventCreator;

public final class SQLServer
extends DBStructureItemJDBC {
    private static final IClosure<SQLDataSource> DSINIT_ERROR = new IClosure<SQLDataSource>(){

        @Override
        public void executeChecked(SQLDataSource input) {
            throw new IllegalStateException("Datasource should already be created");
        }
    };
    private final SQLSystem system;
    private final String login;
    private final String pass;
    private final IClosure<DBSystemRoot> systemRootInit;
    private CopyOnWriteMap<String, SQLBase> bases;
    private Object baseMutex = new String("base mutex");
    private String defaultBase;
    private SQLDataSource ds = null;
    private boolean dsSet = false;
    private final IClosure<SQLDataSource> dsInit;
    private final ITransformer<String, String> urlTransf;
    private String id;

    public SQLServer(SQLSystem system, String host, String port, String login, String pass, IClosure<DBSystemRoot> systemRootInit, IClosure<SQLDataSource> dsInit) {
        super(null, host);
        this.dsInit = dsInit;
        this.system = system;
        this.login = login;
        this.pass = pass;
        this.bases = null;
        this.systemRootInit = systemRootInit;
        this.urlTransf = this.getSQLSystem().getURLTransf(this);
        this.id = this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CopyOnWriteMap<String, SQLBase> getBases() {
        Object object = this.getTreeMutex();
        synchronized (object) {
            Object object2 = this.baseMutex;
            synchronized (object2) {
                if (this.bases == null) {
                    this.checkDropped();
                    this.bases = new CopyOnWriteMap();
                    this.refresh(null, true, true);
                }
                return this.bases;
            }
        }
    }

    public final void destroy() {
        this.dropped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDrop() {
        Object object = this;
        synchronized (object) {
            if (this.ds != null) {
                try {
                    this.ds.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        object = this.baseMutex;
        synchronized (object) {
            this.bases = null;
        }
        super.onDrop();
    }

    private final Object getTreeMutex() {
        Object res;
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        Object object = res = sysRoot == null ? this : sysRoot.getTreeMutex();
        assert (Thread.holdsLock(res) || !Thread.holdsLock(this));
        return res;
    }

    Map<String, TablesMap> refresh(Map<String, TablesMap> namesToRefresh, boolean readCache) {
        return this.refresh(namesToRefresh, readCache, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TablesMap> refresh(final Map<String, TablesMap> tablesToRefresh, final boolean readCache, boolean init) {
        if (this.getDS() != null) {
            if (Collections.emptyMap().equals(tablesToRefresh)) {
                return tablesToRefresh;
            }
            Set<String> namesToRefresh = tablesToRefresh == null ? null : tablesToRefresh.keySet();
            LoadingListener.StructureLoadingEvent evt = new LoadingListener.StructureLoadingEvent(this, namesToRefresh);
            try {
                this.getDBSystemRoot().fireLoading(evt);
                Object object = this.getTreeMutex();
                synchronized (object) {
                    try {
                        HashSet allCats;
                        Set<String> childrenToRefresh = CollectionUtils.inter(namesToRefresh, this.getChildrenNames());
                        Connection conn = this.getDS().getNewConnection();
                        try {
                            List allCatsList = (List)SQLDataSource.COLUMN_LIST_HANDLER.handle(conn.getMetaData().getCatalogs());
                            allCats = new HashSet(allCatsList);
                        }
                        finally {
                            this.getDS().returnConnection(conn);
                        }
                        final Set<String> cats = CollectionUtils.inter(namesToRefresh, allCats);
                        this.getDBSystemRoot().filterNodes(this, cats);
                        SQLBase.mustContain(this, cats, childrenToRefresh, "bases");
                        for (String base : CollectionUtils.substract(childrenToRefresh, cats)) {
                            CollectionChangeEventCreator c = this.createChildrenCreator();
                            SQLBase existingBase = this.getBases().remove(base);
                            this.fireChildrenChanged(c);
                            if (existingBase == null) continue;
                            existingBase.dropped();
                        }
                        DBFileCache cache = this.getFileCache();
                        if (cache != null) {
                            for (DBItemFileCache savedBase : cache.getServerCache().getSavedDesc(SQLBase.class)) {
                                String savedBaseName = savedBase.getName();
                                if (cats.contains(savedBaseName) || namesToRefresh != null && !namesToRefresh.contains(savedBaseName) || !this.getDBSystemRoot().createNode(this, savedBaseName)) continue;
                                savedBase.delete();
                            }
                        }
                        Map<String, TablesMap> map = this.getDBSystemRoot().getGraph().atomicRefresh(new Callable<Map<String, TablesMap>>(){

                            @Override
                            public Map<String, TablesMap> call() throws Exception {
                                HashMap<String, TablesMap> res = new HashMap<String, TablesMap>();
                                for (String cat : cats) {
                                    SQLBase existing = SQLServer.this.getBase(cat);
                                    TablesMap jdbcTables = existing != null ? existing.refresh(tablesToRefresh == null ? null : (TablesMap)tablesToRefresh.get(cat), readCache) : SQLServer.this.createBase(cat, "", "", DSINIT_ERROR, readCache);
                                    if (jdbcTables.isEmpty()) continue;
                                    res.put(cat, jdbcTables);
                                }
                                return res;
                            }
                        });
                        return map;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new IllegalStateException("could not get children names", e);
                        }
                    }
                }
            }
            finally {
                this.getDBSystemRoot().fireLoading(evt.createFinishingEvent());
            }
        }
        if (!init) {
            throw new IllegalArgumentException("Cannot create bases since this server cannot have a connection");
        }
        return null;
    }

    private final synchronized SQLDataSource getDS() {
        if (!this.dsSet) {
            this.checkDropped();
            DBSystemRoot sysRoot = this.getDBSystemRoot();
            this.ds = sysRoot == null ? null : sysRoot.getDataSource();
            this.dsSet = true;
        }
        return this.ds;
    }

    final String getURL(String base) {
        return (String)this.urlTransf.transformChecked(base);
    }

    public SQLBase getBase(String baseName) {
        return this.getBases().get(baseName);
    }

    public SQLBase getBase(String baseName, String login, String pass, IClosure<SQLDataSource> dsInit) {
        return this.getBase(baseName, login, pass, dsInit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLBase getBase(String baseName, String login, String pass, IClosure<SQLDataSource> dsInit, boolean readCache) {
        if (this.getDBSystemRoot() != null) {
            throw new IllegalStateException("getBase(name, login, pass) should only be used for systems where SQLBase is DBSystemRoot");
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLBase base = this.getBase(baseName);
            if (base == null) {
                this.createBase(baseName, login, pass, dsInit, readCache);
                base = this.getBase(baseName);
            }
            return base;
        }
    }

    private final TablesMap createBase(String baseName, String login, String pass, IClosure<SQLDataSource> dsInit, boolean readCache) {
        DBSystemRoot sysRoot = this.getDBSystemRoot();
        if (sysRoot != null && !sysRoot.createNode(this, baseName)) {
            throw new IllegalStateException(String.valueOf(baseName) + " is filtered, you must add it to rootsToMap");
        }
        SQLBase base = this.getSQLSystem().getSyntax().createBase(this, baseName, login == null ? this.login : login, pass == null ? this.pass : pass, dsInit != null ? dsInit : this.dsInit);
        return this.putBase(baseName, base, readCache);
    }

    public final DBSystemRoot getSystemRoot(String name) {
        return this.getSystemRoot(name, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBSystemRoot getSystemRoot(String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            if (!this.isSystemRootCreated(name)) {
                return this.createSystemRoot(name, login, pass, dsInit);
            }
            DBSystemRoot sysRoot = this.getDBSystemRoot();
            DBSystemRoot res = sysRoot != null ? sysRoot : this.getBase(name).getDBSystemRoot();
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DBSystemRoot createSystemRoot(String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        DBSystemRoot res;
        Object object = this.getTreeMutex();
        synchronized (object) {
            DBSystemRoot sysRoot = this.getDBSystemRoot();
            if (sysRoot != null) {
                res = sysRoot;
                res.setDS(login == null ? this.login : login, pass == null ? this.pass : pass, dsInit != null ? dsInit : this.dsInit);
            } else {
                res = this.getBase(name, login, pass, dsInit).getDBSystemRoot();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSystemRootCreated(String name) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            DBSystemRoot sysRoot = this.getDBSystemRoot();
            if (sysRoot != null) {
                return sysRoot.hasDataSource();
            }
            return this.isCreated(name) && this.getBase(name).getDBSystemRoot().hasDataSource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TablesMap putBase(String baseName, SQLBase base, boolean readCache) {
        assert (Thread.holdsLock(this.getTreeMutex()));
        CollectionChangeEventCreator c = this.createChildrenCreator();
        this.getBases().put(baseName, base);
        TablesMap res = base.init(readCache);
        this.fireChildrenChanged(c);
        if (base != null && this.getDBSystemRoot() != null) {
            this.getDBSystemRoot().descendantsChanged(this, Collections.singleton(baseName), readCache);
        }
        SQLServer sQLServer = this;
        synchronized (sQLServer) {
            boolean setDef;
            boolean bl = setDef = this.defaultBase == null && base != null;
            if (setDef) {
                this.setDefaultBase(baseName);
            }
        }
        return res;
    }

    @Override
    public Map<String, SQLBase> getChildrenMap() {
        return this.getBases().getImmutable();
    }

    public boolean isCreated(String baseName) {
        return this.getBase(baseName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultBase(String defaultBase) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            if (defaultBase != null && !this.contains(defaultBase)) {
                throw new IllegalArgumentException(String.valueOf(defaultBase) + " unknown");
            }
            SQLServer sQLServer = this;
            synchronized (sQLServer) {
                this.defaultBase = defaultBase;
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public final SQLSystem getSQLSystem() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(DBSystemRoot systemRoot) {
        if (this.systemRootInit != null) {
            IClosure<DBSystemRoot> iClosure = this.systemRootInit;
            synchronized (iClosure) {
                this.systemRootInit.executeChecked(systemRoot);
            }
        }
    }

    public final synchronized void setID(String id) {
        this.id = id;
    }

    public final synchronized String getID() {
        return this.id;
    }

    public final DBFileCache getFileCache() {
        return DBFileCache.create(this);
    }
}

