/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowMode;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListenerData;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.DecimalUtils;

public class SQLRow
extends SQLRowAccessor {
    private final int ID;
    private final Number idNumber;
    private Map<String, Object> values;
    private boolean fetched = false;

    private static final List<String> getFieldNames(SQLTable table, ResultSetMetaData rsmd, boolean tableOnly) throws SQLException {
        int colCount = rsmd.getColumnCount();
        ArrayList<String> names = new ArrayList<String>(colCount);
        int i = 1;
        while (i <= colCount) {
            if (tableOnly || rsmd.getTableName(i).equals(table.getName())) {
                names.add(rsmd.getColumnName(i));
            } else {
                names.add(null);
            }
            ++i;
        }
        return names;
    }

    static final SQLRow createFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        int indexCount = names.size();
        HashMap<String, Object> m = new HashMap<String, Object>(indexCount);
        int i = 0;
        while (i < indexCount) {
            String colName = names.get(i);
            if (colName != null) {
                m.put(colName, rs.getObject(i + 1));
            }
            ++i;
        }
        return new SQLRow(table, m);
    }

    public static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, boolean tableOnly) throws SQLException {
        return SQLRow.createListFromRS(table, rs, SQLRow.getFieldNames(table, rs.getMetaData(), tableOnly));
    }

    static final List<SQLRow> createListFromRS(SQLTable table, ResultSet rs, List<String> names) throws SQLException {
        ArrayList<SQLRow> res = new ArrayList<SQLRow>();
        while (rs.next()) {
            res.add(SQLRow.createFromRS(table, rs, names));
        }
        return res;
    }

    private SQLRow(SQLTable table, Number id) {
        super(table);
        this.ID = id.intValue();
        this.idNumber = id;
        this.checkTable();
    }

    public SQLRow(SQLTable table, int ID) {
        this(table, table.getKey().getType().getJavaType() == Integer.class ? (Number)ID : (Number)Long.valueOf(ID));
    }

    private void checkTable() {
        if (!this.getTable().isRowable()) {
            throw new IllegalArgumentException(this.getTable() + " is not rowable");
        }
    }

    public SQLRow(SQLTable table, Map<String, ?> values) {
        this(table, SQLRow.getID(values, table));
        this.setValues(new HashMap<String, Object>(values));
    }

    private static Number getID(Map<String, ?> values, SQLTable table) {
        String keyName = table.getKey().getName();
        if (!values.keySet().contains(keyName)) {
            throw new IllegalArgumentException(values + " does not contain the key of " + table);
        }
        return (Number)values.get(keyName);
    }

    private Map<String, Object> getValues() {
        if (!this.fetched) {
            this.fetchValues();
        }
        return this.values;
    }

    public void fetchValues() {
        this.fetchValues(true);
    }

    SQLRow fetchValues(boolean useCache) {
        return this.fetchValues(useCache, useCache);
    }

    SQLRow fetchValues(final boolean readCache, final boolean writeCache) {
        IResultSetHandler handler = new IResultSetHandler(SQLDataSource.MAP_HANDLER){

            @Override
            public boolean readCache() {
                return readCache;
            }

            @Override
            public boolean writeCache() {
                return writeCache;
            }

            public Set<SQLRow> getCacheModifiers() {
                return Collections.singleton(SQLRow.this);
            }
        };
        this.setValues((Map)this.getTable().getBase().getDataSource().execute(this.getQuery(), (ResultSetHandler)handler, false));
        return this;
    }

    private final void setValues(Map<String, Object> values) {
        this.values = values;
        if (!this.fetched) {
            this.fetched = true;
        }
    }

    @Override
    public Set<String> getFields() {
        return Collections.unmodifiableSet(this.getValues().keySet());
    }

    private String getQuery() {
        return "SELECT * FROM " + this.getTable().getSQLName().quote() + " WHERE " + this.getWhere().getClause();
    }

    public Where getWhere() {
        return new Where((FieldRef)this.getTable().getKey(), "=", this.getID());
    }

    public boolean exists() {
        return this.getValues() != null;
    }

    public boolean isArchived() {
        if (!this.getTable().isArchivable()) {
            return false;
        }
        if (this.getTable().getArchiveField().getType().getJavaType().equals(Boolean.class)) {
            return this.getBoolean(this.getTable().getArchiveField().getName()) == Boolean.TRUE;
        }
        return this.getInt(this.getTable().getArchiveField().getName()) == 1;
    }

    public boolean isValid() {
        return this.exists() && this.getID() >= 0 && !this.isArchived();
    }

    @Override
    public final Object getObject(String field) {
        if (!this.exists()) {
            throw new IllegalStateException("The row " + this + "does not exist.");
        }
        if (!this.getTable().contains(field)) {
            throw new IllegalArgumentException("The table of the row " + this + " doesn't contain the field '" + field + "'.");
        }
        if (!this.getValues().containsKey(field)) {
            this.fetchValues();
            String msg = "The row " + this.simpleToString() + " doesn't contain the field '" + field + "' ; refetching.";
            Log.get().warning(msg);
        }
        return this.getValues().get(field);
    }

    public final SQLRow getRow(boolean after) {
        SQLTable t = this.getTable();
        BigDecimal destOrder = this.getOrder();
        int diff = !after ? -1 : 1;
        SQLSelect sel = new SQLSelect();
        sel.setExcludeUndefined(true);
        sel.setArchivedPolicy(SQLSelect.BOTH);
        sel.addSelect(t.getKey());
        sel.addSelect(t.getOrderField());
        if (t.isArchivable()) {
            sel.addSelect(t.getArchiveField());
        }
        sel.setWhere(new Where((FieldRef)t.getOrderField(), diff < 0 ? "<" : ">", (Object)destOrder));
        sel.addFieldOrder(t.getOrderField(), diff < 0 ? Order.desc() : Order.asc());
        sel.setLimit(1);
        SQLDataSource ds = t.getBase().getDataSource();
        Map otherMap = ds.execute1(sel.asString());
        if (otherMap != null) {
            return new SQLRow(t, otherMap);
        }
        return null;
    }

    public final BigDecimal getOrder(boolean after) {
        BigDecimal destOrder = this.getOrder();
        SQLRow otherRow = this.getRow(after);
        BigDecimal otherOrder = otherRow != null ? otherRow.getOrder() : (after ? destOrder.add(ReOrder.DISTANCE) : ReOrder.MIN_ORDER);
        int decDigits = this.getTable().getOrderDecimalDigits();
        BigDecimal least = BigDecimal.ONE.scaleByPowerOfTen(-decDigits);
        BigDecimal distance = destOrder.subtract(otherOrder).abs();
        if (distance.compareTo(least) <= 0) {
            return null;
        }
        BigDecimal mean = destOrder.add(otherOrder).divide(BigDecimal.valueOf(2L));
        return DecimalUtils.round(mean, decDigits);
    }

    @Override
    public SQLRow getForeign(String fieldName) {
        return this.getForeignRow(fieldName);
    }

    @Override
    public boolean isForeignEmpty(String fieldName) {
        SQLRow foreignRow = this.getForeignRow(fieldName, SQLRowMode.NO_CHECK);
        return foreignRow == null || foreignRow.isUndefined();
    }

    public SQLRow getForeignRow(String field) {
        return this.getForeignRow(field, SQLRowMode.EXIST);
    }

    public SQLRow getForeignRow(String field, SQLRowMode mode) {
        if (!this.getTable().contains(field)) {
            throw new IllegalArgumentException(String.valueOf(field) + " is not a field of " + this.getTable());
        }
        SQLField f = this.getTable().getField(field);
        if (!this.getTable().getForeignKeys().contains(f)) {
            throw new IllegalArgumentException(String.valueOf(field) + " is not a foreign key of " + this.getTable());
        }
        return this.getUncheckedForeignRow(this.getTable().getBase().getGraph().getForeignLink(f), mode);
    }

    private SQLRow getUncheckedForeignRow(Link foreignLink, SQLRowMode mode) {
        SQLField field = foreignLink.getLabel();
        SQLTable foreignTable = (SQLTable)foreignLink.getTarget();
        if (this.getObject(field.getName()) == null) {
            return null;
        }
        int foreignID = this.getInt(field.getName());
        SQLRow foreignRow = new SQLRow(foreignTable, foreignID);
        return mode.filter(foreignRow);
    }

    public Set<SQLRow> getForeignRows(String destTable) {
        return this.getForeignRows(destTable, SQLRowMode.DATA);
    }

    public Set<SQLRow> getForeignRows(String destTable, SQLRowMode mode) {
        return new HashSet<SQLRow>(this.getForeignRowsMap(destTable, mode).values());
    }

    public Set<SQLRow> getForeignRows() {
        return this.getForeignRows(SQLRowMode.DATA);
    }

    public Set<SQLRow> getForeignRows(SQLRowMode mode) {
        return new HashSet<SQLRow>(this.getForeignRowsMap(mode).values());
    }

    public Map<SQLField, SQLRow> getForeignRowsMap(String destTable, SQLRowMode mode) {
        Set<Link> links = this.getTable().getDBSystemRoot().getGraph().getForeignLinks(this.getTable(), this.getTable().getTable(destTable));
        return this.foreignLinksToMap(links, mode);
    }

    public Map<SQLField, SQLRow> getForeignRowsMap(SQLRowMode mode) {
        Set<Link> links = this.getTable().getBase().getGraph().getForeignLinks(this.getTable());
        return this.foreignLinksToMap(links, mode);
    }

    private Map<SQLField, SQLRow> foreignLinksToMap(Collection<Link> links, SQLRowMode mode) {
        HashMap<SQLField, SQLRow> res = new HashMap<SQLField, SQLRow>();
        for (Link l : links) {
            SQLRow fr = this.getUncheckedForeignRow(l, mode);
            if (fr == null) continue;
            res.put(l.getLabel(), fr);
        }
        return res;
    }

    public final List<SQLRow> getReferentRows() {
        return this.getReferentRows((Set<SQLTable>)null);
    }

    public final List<SQLRow> getReferentRows(SQLTable refTable) {
        return this.getReferentRows(Collections.singleton(refTable));
    }

    public final List<SQLRow> getReferentRows(Set<SQLTable> tables) {
        return this.getReferentRows(tables, SQLSelect.UNARCHIVED);
    }

    public final List<SQLRow> getReferentRows(Set<SQLTable> tables, SQLSelect.ArchiveMode archived) {
        return new ArrayList<SQLRow>(this.getReferentRowsByLink(tables, archived).values());
    }

    public final CollectionMap<Link, SQLRow> getReferentRowsByLink(Set<SQLTable> tables, SQLSelect.ArchiveMode archived) {
        CollectionMap<Link, SQLRow> res = new CollectionMap<Link, SQLRow>(new ArrayList());
        Set<Link> links = this.getTable().getBase().getGraph().getReferentLinks(this.getTable());
        for (Link l : links) {
            SQLTable src = (SQLTable)l.getSource();
            if (tables != null && (tables == null || !tables.contains(src))) continue;
            res.putAll((Object)l, this.getReferentRows(l.getLabel(), archived));
        }
        return res;
    }

    public List<SQLRow> getReferentRows(SQLField refField) {
        return this.getReferentRows(refField, SQLSelect.UNARCHIVED);
    }

    public List<SQLRow> getReferentRows(SQLField refField, SQLSelect.ArchiveMode archived) {
        return this.getReferentRows(refField, archived, null);
    }

    public List<SQLRow> getReferentRows(SQLField refField, SQLSelect.ArchiveMode archived, Collection<String> fields) {
        SQLTable foreignTable = refField.getTable().getBase().getGraph().getForeignTable(refField);
        if (!foreignTable.equals(this.getTable())) {
            throw new IllegalArgumentException(refField + " doesn't point to " + this.getTable());
        }
        SQLTable src = refField.getTable();
        SQLSelect sel = new SQLSelect(this.getTable().getBase());
        if (fields == null) {
            sel.addSelectStar(src);
        } else {
            sel.addSelect(src.getKey());
            for (String f : fields) {
                sel.addSelect(src.getField(f));
            }
        }
        sel.setWhere(new Where((FieldRef)refField, "=", this.getID()));
        sel.setArchivedPolicy(archived);
        sel.addOrderSilent(src.getName());
        return SQLRowListRSH.execute(sel);
    }

    private Set<SQLRow> getConnectedRows() {
        HashSet<SQLRow> res = new HashSet<SQLRow>();
        res.addAll(this.getReferentRows((Set<SQLTable>)null, SQLSelect.BOTH));
        res.addAll(this.getForeignRows(SQLRowMode.EXIST));
        return res;
    }

    public Set<SQLRow> findDistantArchived(int maxLength) {
        return this.findDistantArchived(maxLength, new HashSet<SQLRow>(), 0);
    }

    private Set<SQLRow> findDistantArchived(int maxLength, Set<SQLRow> been, int length) {
        HashSet<SQLRow> res = new HashSet<SQLRow>();
        if (maxLength == length) {
            return res;
        }
        been.add(this);
        ++length;
        HashSet<SQLRow> rec = new HashSet<SQLRow>();
        for (SQLRow row : this.getConnectedRows()) {
            if (been.contains(row)) continue;
            if (row.isArchived()) {
                res.add(row);
                continue;
            }
            rec.add(row);
        }
        for (SQLRow row : rec) {
            res.addAll(row.findDistantArchived(maxLength, been, length));
        }
        return res;
    }

    public String toString() {
        String res = this.simpleToString();
        if (!this.exists()) {
            res = "?" + res + "?";
        } else if (this.isArchived()) {
            res = "(" + res + ")";
        }
        return res;
    }

    public String simpleToString() {
        return String.valueOf(this.getTable().getName()) + "[" + this.ID + "]";
    }

    @Override
    public Map<String, Object> getAbsolutelyAll() {
        return Collections.unmodifiableMap(this.getValues());
    }

    public Map<String, Object> getAllValues() {
        HashMap<String, Object> res = new HashMap<String, Object>(this.getValues());
        final Set<SQLField> keys = this.getTable().getKeys();
        CollectionUtils.filter(res.keySet(), new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                SQLField field = SQLRow.this.getTable().getField((String)object);
                return !keys.contains(field) && field != SQLRow.this.getTable().getOrderField() && field != SQLRow.this.getTable().getArchiveField();
            }
        });
        return res;
    }

    public SQLRowValues createUpdateRow() {
        SQLRowValues res = new SQLRowValues(this.getTable());
        res.loadAbsolutelyAll(this);
        return res;
    }

    public SQLRowValues createEmptyUpdateRow() {
        SQLRowValues res = new SQLRowValues(this.getTable());
        res.put(this.getTable().getKey().getName(), this.getIDNumber());
        return res;
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public Number getIDNumber() {
        return this.idNumber;
    }

    @Override
    public SQLRow asRow() {
        return this;
    }

    @Override
    public final SQLRowValues asRowValues() {
        return this.createUpdateRow();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SQLRow)) {
            return false;
        }
        SQLRow o = (SQLRow)other;
        return this.equalsAsRow(o);
    }

    public int hashCode() {
        return this.hashCodeAsRow();
    }

    public static List<String> toList(String path) {
        return Arrays.asList(SQLRow.toArray(path));
    }

    private static String[] toArray(String path) {
        if (path.length() == 0) {
            return new String[0];
        }
        return path.split(",");
    }

    @Override
    public SQLTableModifiedListener createTableListener(SQLDataListener l) {
        return new SQLTableListenerData<SQLRow>(this, l);
    }
}

