/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.JDOMException;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementNames;
import org.openconcerto.sql.element.SQLElementNamesFromXML;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.LocalizedInstances;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.TranslationManager;

public final class SQLElementDirectory {
    public static final String BASENAME = SQLElementNames.class.getSimpleName();
    private static final LocalizedInstances<SQLElementNames> LOCALIZED_INSTANCES = new LocalizedInstances<SQLElementNames>(SQLElementNames.class, TranslationManager.getControl()){

        @Override
        protected SQLElementNames createInstance(String bundleName, Locale candidate, Class<?> cl) throws IOException {
            InputStream ins = cl.getResourceAsStream(String.valueOf('/') + this.getControl().toResourceName(bundleName, "xml"));
            if (ins == null) {
                return null;
            }
            SQLElementNamesFromXML res = new SQLElementNamesFromXML(candidate);
            try {
                try {
                    res.load(ins);
                }
                catch (JDOMException e) {
                    throw new IOException("Invalid XML", e);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            finally {
                ins.close();
            }
            return res;
        }
    };
    private final Map<SQLTable, SQLElement> elements = new HashMap<SQLTable, SQLElement>();
    private final CollectionMap<String, SQLTable> tableNames = new CollectionMap(HashSet.class);
    private final CollectionMap<String, SQLTable> byCode = new CollectionMap(HashSet.class);
    private final CollectionMap<Class<? extends SQLElement>, SQLTable> byClass = new CollectionMap(HashSet.class);
    private final List<DirectoryListener> listeners = new ArrayList<DirectoryListener>();
    private String phrasesPkgName = null;
    private final Map<String, SQLElementNames> elementNames = new HashMap<String, SQLElementNames>();

    private static <K> SQLTable getSoleTable(CollectionMap<K, SQLTable> m, K key) throws IllegalArgumentException {
        Collection<SQLTable> res = m.getNonNull(key);
        if (res.size() > 1) {
            throw new IllegalArgumentException(key + " is not unique: " + CollectionUtils.join(res, ",", new ITransformer<SQLTable, SQLName>(){

                public SQLName transformChecked(SQLTable input) {
                    return input.getSQLName();
                }
            }));
        }
        return CollectionUtils.getSole(res);
    }

    public final synchronized void putAll(SQLElementDirectory o) {
        for (SQLElement elem : o.getElements()) {
            if (this.contains(elem.getTable())) continue;
            this.addSQLElement(elem);
        }
    }

    public final void addSQLElement(Class<? extends SQLElement> element) {
        try {
            this.addSQLElement(element.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DBStructureItemNotFound) {
                Log.get().config("ignore inexistent tables: " + e.getCause().getLocalizedMessage());
                return;
            }
            throw new IllegalArgumentException("ctor failed", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("no-arg ctor failed", e);
        }
    }

    public final synchronized void addSQLElement(SQLElement elem) {
        this.elements.put(elem.getTable(), elem);
        this.tableNames.put((Object)elem.getTable().getName(), (Object)elem.getTable());
        this.byCode.put((Object)elem.getCode(), (Object)elem.getTable());
        this.byClass.put(elem.getClass(), (Object)elem.getTable());
        for (DirectoryListener dl : this.listeners) {
            dl.elementAdded(elem);
        }
        elem.setDirectory(this);
    }

    public final synchronized boolean contains(SQLTable t) {
        return this.elements.containsKey(t);
    }

    public final synchronized SQLElement getElement(SQLTable t) {
        return this.elements.get(t);
    }

    public final synchronized SQLElement getElement(String tableName) {
        return this.getElement(SQLElementDirectory.getSoleTable(this.tableNames, tableName));
    }

    public final synchronized <S extends SQLElement> S getElement(Class<S> clazz) {
        return (S)((SQLElement)clazz.cast(this.getElement(SQLElementDirectory.getSoleTable(this.byClass, clazz))));
    }

    public final synchronized SQLElement getElementForCode(String code) {
        return this.getElement(SQLElementDirectory.getSoleTable(this.byCode, code));
    }

    public final synchronized Collection<SQLElement> getElements() {
        return this.getElementsMap().values();
    }

    public final Map<SQLTable, SQLElement> getElementsMap() {
        return Collections.unmodifiableMap(this.elements);
    }

    public final synchronized String getL18nPackageName() {
        return this.phrasesPkgName;
    }

    protected final synchronized SQLElementNames getElementNames(String pkgName, Locale locale, Class<?> cl) {
        if (pkgName == null) {
            return null;
        }
        int sep = 32;
        String key = String.valueOf(pkgName) + ' ' + locale.toString();
        assert (pkgName.indexOf(32) < 0) : "ambiguous key : " + key;
        SQLElementNames res = this.elementNames.get(key);
        if (res == null) {
            List<SQLElementNames> l = LOCALIZED_INSTANCES.createInstances(String.valueOf(pkgName) + "." + BASENAME, locale, cl).get1();
            if (!l.isEmpty()) {
                int i = 1;
                while (i < l.size()) {
                    l.get(i - 1).setParent(l.get(i));
                    ++i;
                }
                res = l.get(0);
            }
            this.elementNames.put(key, res);
        }
        return res;
    }

    public final Phrase getName(SQLElement elem) {
        String elemBaseName = elem.getL18nPackageName();
        String pkgName = elemBaseName == null ? this.getL18nPackageName() : elemBaseName;
        SQLElementNames elementNames = this.getElementNames(pkgName, TM.getInstance().getTranslationsLocale(), elem.getClass());
        return elementNames == null ? null : elementNames.getName(elem);
    }

    public final synchronized void addListener(DirectoryListener dl) {
        this.listeners.add(dl);
    }

    public final synchronized void removeListener(DirectoryListener dl) {
        this.listeners.remove(dl);
    }

    public static interface DirectoryListener {
        public void elementAdded(SQLElement var1);
    }
}

