/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.beans.PropertyChangeSupport;
import org.openconcerto.sql.element.BaseSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public abstract class ElementSQLObject
extends BaseSQLObject {
    protected boolean required;
    private final SQLComponent parent;
    private final SQLComponent comp;
    private Boolean created;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private final ValidChangeSupport validSupp = new ValidChangeSupport(this);
    private EmptyChangeSupport helper = new EmptyChangeSupport(this);

    public ElementSQLObject(SQLComponent parent, SQLComponent comp) {
        this.parent = parent;
        this.comp = comp;
        this.required = false;
        this.comp.setOpaque(false);
        this.comp.setSQLParent(this);
        this.comp.setNonExistantEditable(true);
        this.comp.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                if (ElementSQLObject.this.isCreated()) {
                    ElementSQLObject.this.supp.firePropertyChange("value", null, null);
                }
                ElementSQLObject.this.fireValidChange();
            }
        });
        this.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
                ElementSQLObject.this.compChanged();
            }
        });
        this.uiInit();
        this.created = null;
        this.setCreated(false);
    }

    public final void setRequired(boolean required) {
        this.required = required;
        if (this.required) {
            this.setCreated(true);
        }
    }

    protected abstract void uiInit();

    protected abstract void setCreatePanel();

    protected abstract void setEditPanel();

    protected void compChanged() {
    }

    public final void setCreated(boolean b) {
        if (!Boolean.valueOf(b).equals(this.created)) {
            this.created = b;
            if (this.created.booleanValue()) {
                this.setEditPanel();
            } else {
                this.setCreatePanel();
            }
            this.helper.fireEmptyChange(this.isEmpty());
            this.fireValidChange();
            this.supp.firePropertyChange("value", null, null);
        }
    }

    public final boolean isCreated() {
        return this.created;
    }

    public void setValue(SQLRowAccessor r) {
        boolean displayableRow;
        boolean bl = displayableRow = r != null && r.getID() != r.getTable().getUndefinedID();
        if (displayableRow) {
            this.setCreated(true);
            this.setCurrentID(r);
        } else {
            this.setCreated(this.required);
            this.setCurrentID(null);
        }
        this.compChanged();
    }

    private void detach() {
        this.comp.detach();
        this.compChanged();
    }

    protected final void setCurrentID(SQLRowAccessor r) {
        this.comp.select(r);
    }

    private final void setCurrentID(int currentID) {
        if (currentID == -1) {
            this.comp.select(null);
        } else {
            this.comp.select(currentID);
        }
    }

    protected final int getCurrentID() {
        return this.comp.getSelectedID();
    }

    @Override
    public void resetValue() {
        this.setValue(null);
    }

    @Override
    public boolean isEmpty() {
        return !this.isCreated();
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.helper.addEmptyListener(l);
    }

    public final SQLComponent getSQLChild() {
        return this.comp;
    }

    @Override
    public String toString() {
        return "ElementSQLObject on " + this.getField() + " created: " + this.isCreated() + " id: " + this.getCurrentID();
    }

    public void update() {
        if (this.isCreated()) {
            if (this.getCurrentID() == -1) {
                this.setCurrentID(this.comp.insert());
            } else {
                this.comp.update();
            }
        } else if (this.getCurrentID() != -1) {
            this.comp.archive();
            this.setCurrentID(-1);
        }
    }

    public void insert() {
        if (this.isCreated()) {
            this.setCurrentID(this.comp.insert());
        }
    }

    @Override
    public ValidState getValidState() {
        ValidState res = this.isCreated() ? this.getSQLChild().getValidState() : ValidState.getTrueInstance();
        return res;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }

    private void fireValidChange() {
        this.validSupp.fireValidChange(this.getValidState());
    }

    @Override
    public void setEditable(boolean enabled) {
        this.comp.setEditable(enabled);
    }

    @Override
    public void insert(SQLRowValues vals) {
        this.insert();
        this.fillRowValues(vals);
        if (this.comp.getElement().dontDeepCopy()) {
            this.resetValue();
        } else {
            this.detach();
        }
    }

    @Override
    public void update(SQLRowValues vals) {
        this.update();
        this.fillRowValues(vals);
    }

    private void fillRowValues(SQLRowValues vals) {
        vals.put(this.getField().getName(), this.getCurrentID() == -1 ? SQLRowValues.SQL_EMPTY_LINK : Integer.valueOf(this.getCurrentID()));
    }

    @Override
    public void show(SQLRowAccessor r) {
        if (r.getFields().contains(this.getField().getName())) {
            this.setValue(r.getForeign(this.getField().getName()));
        }
    }

    @Override
    public Component getComp() {
        return this;
    }
}

