/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;

public abstract class DeletionMode {
    public static DeletionMode ArchiveMode = new DeletionMode(){

        @Override
        public String getName() {
            return "archive";
        }

        @Override
        public boolean destroyInformation() {
            return true;
        }

        @Override
        protected void updateDB(SQLElement elem, int id) throws SQLException {
            this.getUpdateClause(elem, true).update(id);
        }

        @Override
        public void fireChange(SQLRowAccessor row) {
            row.getTable().fireTableModified(row.getID(), Collections.singleton(row.getTable().getArchiveField().getName()));
        }
    };
    public static DeletionMode DeleteMode = new DeletionMode(){

        @Override
        public String getName() {
            return "delete";
        }

        @Override
        public boolean destroyInformation() {
            return true;
        }

        @Override
        protected void updateDB(SQLElement elem, int id) throws SQLException {
            String req = "DELETE FROM  " + elem.getTable().getSQLName().quote() + this.getWhereClause(elem, id);
            elem.getTable().getBase().getDataSource().execute(req);
        }

        @Override
        public void fireChange(SQLRowAccessor row) {
            row.getTable().fireRowDeleted(row.getID());
        }
    };
    public static DeletionMode UnArchiveMode = new DeletionMode(){

        @Override
        public String getName() {
            return "unarchive";
        }

        @Override
        public boolean destroyInformation() {
            return false;
        }

        @Override
        protected void updateDB(SQLElement elem, int id) throws SQLException {
            this.getUpdateClause(elem, false).update(id);
        }

        @Override
        public void fireChange(SQLRowAccessor row) {
            row.getTable().fireTableModified(row.getID(), Collections.singleton(row.getTable().getArchiveField().getName()));
        }
    };

    public abstract String getName();

    public abstract boolean destroyInformation();

    public String toString() {
        return "DeletionMode[" + this.getName() + "]";
    }

    private void execute(SQLElement elem, int id) throws SQLException {
        this.execute(elem, new SQLRow(elem.getTable(), id));
    }

    public synchronized void execute(SQLElement elem, SQLRowAccessor ra) throws SQLException {
        int id = ra.getID();
        SQLRow r = ra.asRow();
        Log.get().fine(this + " on " + elem + "/" + id);
        if (r.isUndefined()) {
            throw new IllegalArgumentException(this + " can't " + this.getName() + " the undefined");
        }
        if (this.destroyInformation()) {
            this.updateDB(elem, id);
            this.updatePrivates(elem, r);
        } else {
            this.updatePrivates(elem, r);
            this.updateDB(elem, id);
        }
    }

    public abstract void fireChange(SQLRowAccessor var1);

    protected final SQLRowValues getUpdateClause(SQLElement elem, boolean archive) {
        Comparable<Boolean> newVal = Boolean.class.equals(elem.getTable().getArchiveField().getType().getJavaType()) ? (Comparable<Boolean>)Boolean.valueOf(archive) : (Comparable<Boolean>)Integer.valueOf(archive ? 1 : 0);
        return new SQLRowValues(elem.getTable()).put(elem.getTable().getArchiveField().getName(), newVal);
    }

    protected final String getWhereClause(SQLElement elem, int id) {
        return " WHERE " + new Where((FieldRef)elem.getTable().getKey(), "=", id).getClause();
    }

    protected abstract void updateDB(SQLElement var1, int var2) throws SQLException;

    private void updatePrivates(SQLElement elem, SQLRow row) throws SQLException {
        Set<String> pff = elem.getPrivateForeignFields();
        if (pff.size() > 0) {
            if (!row.getFields().containsAll(pff)) {
                row.fetchValues();
            }
            for (String foreignField : pff) {
                if (row.isForeignEmpty(foreignField)) continue;
                this.execute(elem.getPrivateElement(foreignField), row.getInt(foreignField));
            }
        }
    }
}

