/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.injector;

import java.math.BigDecimal;
import java.util.Collection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class BonFactureSQLInjector
extends SQLInjector {
    public BonFactureSQLInjector(DBRoot root) {
        super(root.getTable("BON_DE_LIVRAISON"), root.getTable("SAISIE_VENTE_FACTURE"), true);
        SQLTable tableBon = this.getSource();
        SQLTable tableFacture = this.getDestination();
        this.map(tableBon.getField("ID_CLIENT"), tableFacture.getField("ID_CLIENT"));
        this.map(tableBon.getField("NOM"), tableFacture.getField("NOM"));
        this.map(tableBon.getField("INFOS"), tableFacture.getField("INFOS"));
    }

    @Override
    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        SQLTable tableElementSource = this.getSource().getTable("BON_DE_LIVRAISON_ELEMENT");
        SQLTable tableElementDestination = this.getSource().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection myListItem = srcRow.asRow().getReferentRows(tableElementSource);
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(tableElementSource, tableElementDestination);
            for (SQLRowAccessor rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt.asRow());
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                createRowValuesFrom.put("ID_SAISIE_VENTE_FACTURE", rowVals);
            }
        }
    }
}

