/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationReglementAchat
extends GenerationEcritures {
    private static final Integer journalCaisse = new Integer(5);
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationReglementAchat(int idRegMontant) throws Exception {
        SQLRow regMontantRow = base.getTable("REGLER_MONTANT").getRow(idRegMontant);
        int idEchFourn = regMontantRow.getInt("ID_ECHEANCE_FOURNISSEUR");
        SQLRow echeanceRow = base.getTable("ECHEANCE_FOURNISSEUR").getRow(idEchFourn);
        SQLRow rowFournisseur = base.getTable("FOURNISSEUR").getRow(echeanceRow.getInt("ID_FOURNISSEUR"));
        System.err.println("G\u00e9n\u00e9ration des ecritures du reglement du mouvement " + this.idMvt);
        SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(regMontantRow.getInt("ID_MODE_REGLEMENT"));
        SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
        System.err.println("Mode de reglement " + regMontantRow.getInt("ID_MODE_REGLEMENT"));
        PrixTTC prixTTC = new PrixTTC((Long)regMontantRow.getObject("MONTANT"));
        this.date = (Date)regMontantRow.getObject("DATE");
        this.nom = "R\u00e8glement achat " + rowFournisseur.getString("NOM") + " (" + typeRegRow.getString("NOM") + ")";
        if (modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
            System.err.println("R\u00e8glement Comptant");
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(this.date, idEchFourn, idRegMontant);
            } else {
                if (typeRegRow.getID() == 4) {
                    this.mEcritures.put("ID_JOURNAL", journalCaisse);
                } else {
                    this.mEcritures.put("ID_JOURNAL", 4);
                }
                SQLRow rowMouv = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
                this.idMvt = this.getNewMouvement("REGLER_MONTANT", idRegMontant, rowMouv.getID(), rowMouv.getInt("ID_PIECE"));
                this.mEcritures.put("DATE", this.date);
                this.mEcritures.put("NOM", this.nom);
                this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
                int idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE");
                if (idCompteFourn <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
                    idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
                }
                this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteFourn));
                this.mEcritures.put("DEBIT", new Long(prixTTC.getLongValue()));
                this.mEcritures.put("CREDIT", new Long(0L));
                this.ajoutEcriture();
                int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_FOURN");
                if (idCompteRegl <= 1) {
                    try {
                        idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("AchatCB");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteRegl));
                this.mEcritures.put("DEBIT", new Long(0L));
                this.mEcritures.put("CREDIT", new Long(prixTTC.getLongValue()));
                this.ajoutEcriture();
            }
        } else {
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            System.out.println("Date d'\u00e9ch\u00e9ance " + dateFormat.format(dateEch));
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(dateEch, idEchFourn, idRegMontant);
            } else {
                SQLRowValues valEcheance;
                HashMap<String, Comparable<Integer>> mEcheance = new HashMap<String, Comparable<Integer>>();
                SQLRow rowMouv = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
                this.idMvt = this.getNewMouvement("ECHEANCE_FOURNISSEUR", 1, rowMouv.getID(), rowMouv.getInt("ID_PIECE"));
                mEcheance.put("ID_MOUVEMENT", new Integer(this.idMvt));
                mEcheance.put("DATE", dateEch);
                mEcheance.put("MONTANT", new Long(prixTTC.getLongValue()));
                if (idEchFourn > 1) {
                    mEcheance.put("ID_FOURNISSEUR", new Integer(echeanceRow.getInt("ID_FOURNISSEUR")));
                }
                if ((valEcheance = new SQLRowValues(base.getTable("ECHEANCE_FOURNISSEUR"), mEcheance)).getInvalid() == null) {
                    SQLRow row = valEcheance.insert();
                    SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                    rowVals.put("IDSOURCE", row.getID());
                    rowVals.update(this.idMvt);
                }
            }
        }
    }

    private void paiementCheque(Date dateEch, int idEchFourn, int idRegMontant) throws SQLException {
        SQLRow regMontantRow = base.getTable("REGLER_MONTANT").getRow(idRegMontant);
        SQLRow echeanceRow = base.getTable("ECHEANCE_FOURNISSEUR").getRow(idEchFourn);
        PrixTTC prixTTC = new PrixTTC((Long)regMontantRow.getObject("MONTANT"));
        SQLRowValues valCheque = new SQLRowValues(base.getTable("CHEQUE_FOURNISSEUR"));
        if (idEchFourn > 1) {
            valCheque.put("ID_FOURNISSEUR", new Integer(echeanceRow.getInt("ID_FOURNISSEUR")));
        }
        valCheque.put("DATE_ACHAT", this.date);
        valCheque.put("DATE_MIN_DECAISSE", dateEch);
        SQLRow rowMvtPere = tableMouvement.getRow(echeanceRow.getInt("ID_MOUVEMENT"));
        this.idMvt = this.getNewMouvement("CHEQUE_FOURNISSEUR", 1, rowMvtPere.getID(), rowMvtPere.getInt("ID_PIECE"));
        valCheque.put("ID_MOUVEMENT", new Integer(this.idMvt));
        valCheque.put("MONTANT", new Long(prixTTC.getLongValue()));
        if (valCheque.getInvalid() == null) {
            SQLRow row = valCheque.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }
}

