/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationReglementVenteNG;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtSaisieVenteFacture
extends GenerationEcritures
implements Runnable {
    public static final Integer journal = 3;
    private int idSaisieVenteFacture;
    private static final SQLTable saisieVFTable = base.getTable("SAISIE_VENTE_FACTURE");
    private static final SQLTable mvtTable = base.getTable("MOUVEMENT");
    private static final SQLTable ecrTable = base.getTable("ECRITURE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture, int idMvt) {
        System.err.println("********* init GeneRation");
        this.idMvt = idMvt;
        this.idSaisieVenteFacture = idSaisieVenteFacture;
        new Thread(this).start();
    }

    public GenerationMvtSaisieVenteFacture(int idSaisieVenteFacture) {
        this(idSaisieVenteFacture, 1);
    }

    private void genereMouvement() throws Exception {
        SQLRowValues rowValsPiece;
        SQLRow saisieRow = saisieVFTable.getRow(this.idSaisieVenteFacture);
        SQLRow clientRow = saisieRow.getForeignRow("ID_CLIENT");
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC"));
        long montantAcompteTTC = 0L;
        int idCompteClient = clientRow.getInt("ID_COMPTE_PCE");
        Boolean acompte = saisieRow.getBoolean("ACOMPTE");
        this.nom = acompte != null && acompte != false ? "Fact. acompte client" + saisieRow.getObject("NUMERO").toString() : "Fact. vente " + saisieRow.getObject("NUMERO").toString();
        this.date = (Date)saisieRow.getObject("DATE");
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get("accounting.records.invoice.sales");
        provider.putLabel(saisieRow, this.mEcritures);
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("ID_JOURNAL", journal);
        this.mEcritures.put("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            provider.putPieceLabel(saisieRow, rowValsPiece);
            this.getNewMouvement("SAISIE_VENTE_FACTURE", this.idSaisieVenteFacture, 1, rowValsPiece);
        } else {
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
            rowValsPiece = mvtTable.getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            provider.putPieceLabel(saisieRow, rowValsPiece);
            rowValsPiece.update();
        }
        SQLTable tableEchantillon = null;
        if (saisieVFTable.getDBRoot().contains("ECHANTILLON_ELEMENT")) {
            tableEchantillon = saisieVFTable.getTable("ECHANTILLON_ELEMENT");
        }
        BigDecimal portHT = BigDecimal.valueOf(saisieRow.getLong("PORT_HT")).movePointLeft(2);
        TotalCalculator calc = this.getValuesFromElement(saisieRow, saisieVFTable.getTable("SAISIE_VENTE_FACTURE_ELEMENT"), portHT, saisieRow.getForeign("ID_TAXE_PORT"), tableEchantillon);
        long ttcLongValue = calc.getTotalTTC().movePointRight(2).longValue();
        if (acompte == null || !acompte.booleanValue()) {
            for (SQLRowAccessor row : calc.getMapHt().keySet()) {
                long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                if (b == 0L) continue;
                this.mEcritures.put("ID_COMPTE_PCE", row.getID());
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", b);
                int n = this.ajoutEcriture();
            }
            Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
            for (SQLRowAccessor rowAc : tvaMap.keySet()) {
                long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
                if (longValue == 0L) continue;
                this.mEcritures.put("ID_COMPTE_PCE", rowAc.getID());
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", longValue);
                this.ajoutEcriture();
            }
            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
            }
            this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
            if (ecrTable.contains("CODE_CLIENT")) {
                this.mEcritures.put("CODE_CLIENT", clientRow.getString("CODE"));
            }
            this.mEcritures.put("DEBIT", ttcLongValue);
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
        }
        SQLRowValues valSasieVF = new SQLRowValues(saisieVFTable);
        valSasieVF.put("DATE_REGLEMENT", null);
        valSasieVF.update(this.idSaisieVenteFacture);
        SQLRow modeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
        SQLRow typeRegRow = modeRegl.getForeignRow("ID_TYPE_REGLEMENT");
        String label = String.valueOf(this.nom) + " (" + typeRegRow.getString("NOM") + ")";
        int idAvoir = saisieRow.getInt("ID_AVOIR_CLIENT");
        if (idAvoir > 1) {
            long l = ((Number)saisieRow.getObject("T_AVOIR_TTC")).longValue();
            prixTTC = new PrixTTC((Long)saisieRow.getObject("T_TTC") - l);
        }
        if ((prixTTC = new PrixTTC(prixTTC.getLongValue() - montantAcompteTTC)).getLongValue() > 0L) {
            new GenerationReglementVenteNG(label, clientRow, prixTTC, this.date, modeRegl, saisieRow, mvtTable.getRow(this.idMvt));
        }
        SQLRowValues valSasieVF2 = new SQLRowValues(saisieVFTable);
        valSasieVF2.put("ID_MOUVEMENT", (Object)this.idMvt);
        if (valSasieVF2.getInvalid() == null) {
            valSasieVF2.update(this.idSaisieVenteFacture);
        }
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
        }
    }
}

