/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAchat;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtSaisieAchat
extends GenerationEcritures
implements Runnable {
    private int idSaisieAchat;
    private static final Integer journal = new Integer(2);
    private static final SQLTable tableSaisieAchat = base.getTable("SAISIE_ACHAT");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableFournisseur = base.getTable("FOURNISSEUR");
    private static final SQLTable tableMvt = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtSaisieAchat(int idSaisieAchat, int idMvt) {
        this.idSaisieAchat = idSaisieAchat;
        this.idMvt = idMvt;
        new Thread(this).start();
    }

    public GenerationMvtSaisieAchat(int idSaisieAchat) {
        this.idSaisieAchat = idSaisieAchat;
        this.idMvt = 1;
        new Thread(this).start();
    }

    public void genereMouvement() throws Exception {
        int idCompteFourn;
        SQLRowValues rowValsPiece;
        SQLRow saisieRow = tableSaisieAchat.getRow(this.idSaisieAchat);
        SQLRow rowFournisseur = tableFournisseur.getRow(saisieRow.getInt("ID_FOURNISSEUR"));
        this.date = (Date)saisieRow.getObject("DATE");
        this.nom = "Achat : " + rowFournisseur.getString("NOM") + " Facture : " + saisieRow.getObject("NUMERO_FACTURE").toString() + " " + saisieRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", this.date);
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get("accounting.records.supply.order");
        provider.putLabel(saisieRow, this.mEcritures);
        this.mEcritures.put("ID_JOURNAL", journal);
        this.mEcritures.put("ID_MOUVEMENT", new Integer(1));
        PrixTTC prixTTC = new PrixTTC((Long)saisieRow.getObject("MONTANT_TTC"));
        PrixHT prixTVA = new PrixHT((Long)saisieRow.getObject("MONTANT_TVA"));
        PrixHT prixHT = new PrixHT((Long)saisieRow.getObject("MONTANT_HT"));
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            provider.putPieceLabel(saisieRow, rowValsPiece);
            this.getNewMouvement("SAISIE_ACHAT", this.idSaisieAchat, 1, rowValsPiece);
        } else {
            rowValsPiece = pieceTable.getTable("MOUVEMENT").getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            provider.putPieceLabel(saisieRow, rowValsPiece);
            rowValsPiece.update();
            this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
        }
        int idCompteAchat = saisieRow.getInt("ID_COMPTE_PCE");
        if (idCompteAchat <= 1 && (idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT")) <= 1) {
            idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
        }
        this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteAchat));
        this.mEcritures.put("DEBIT", new Long(prixHT.getLongValue()));
        this.mEcritures.put("CREDIT", new Long(0L));
        this.ajoutEcriture();
        if (prixTVA.getLongValue() > 0L) {
            int idCompteTVA;
            if (saisieRow.getBoolean("IMMO").booleanValue()) {
                idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_IMMO");
                if (idCompteTVA <= 1) {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVAImmo");
                }
            } else {
                idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT");
                if (idCompteTVA <= 1) {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVADeductible");
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteTVA));
            this.mEcritures.put("DEBIT", new Long(prixTVA.getLongValue()));
            this.mEcritures.put("CREDIT", new Long(0L));
            this.ajoutEcriture();
            if (rowFournisseur.getBoolean("UE").booleanValue()) {
                int idCompteTVAIntra = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_INTRA");
                if (idCompteTVAIntra <= 1) {
                    idCompteTVAIntra = ComptePCESQLElement.getIdComptePceDefault("TVAIntraComm");
                }
                this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteTVAIntra));
                this.mEcritures.put("DEBIT", new Long(0L));
                this.mEcritures.put("CREDIT", new Long(prixTVA.getLongValue()));
                this.ajoutEcriture();
            }
        }
        if ((idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
            idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
        }
        this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteFourn));
        this.mEcritures.put("DEBIT", new Long(0L));
        if (rowFournisseur.getBoolean("UE").booleanValue()) {
            this.mEcritures.put("CREDIT", new Long(prixHT.getLongValue()));
        } else {
            this.mEcritures.put("CREDIT", new Long(prixTTC.getLongValue()));
        }
        this.ajoutEcriture();
        new GenerationMvtReglementAchat(this.idSaisieAchat, this.idMvt);
        SQLRowValues valEcriture = new SQLRowValues(tableSaisieAchat);
        valEcriture.put("ID_MOUVEMENT", new Integer(this.idMvt));
        if (valEcriture.getInvalid() == null) {
            valEcriture.update(this.idSaisieAchat);
        }
    }

    @Override
    public void run() {
        try {
            this.genereMouvement();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
        }
    }
}

