/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAvoir;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProvider;
import org.openconcerto.erp.generationEcritures.provider.AccountingRecordsProviderManager;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtAvoirClient
extends GenerationEcritures {
    private static final Integer journal = 3;
    private int idAvoirClient;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtAvoirClient(int idAvoirClient) {
        this.idMvt = 1;
        this.idAvoirClient = idAvoirClient;
    }

    public GenerationMvtAvoirClient(int idAvoirClient, int idMvt) {
        this.idMvt = idMvt;
        this.idAvoirClient = idAvoirClient;
    }

    public int genereMouvement() throws Exception {
        SQLRowValues rowValsPiece;
        int idJrnlFactor;
        SQLTable avoirClientTable = base.getTable("AVOIR_CLIENT");
        SQLRow avoirRow = avoirClientTable.getRow(this.idAvoirClient);
        boolean affacturage = avoirRow.getBoolean("AFFACTURE");
        SQLRow rowClient = avoirRow.getForeignRow("ID_CLIENT");
        this.date = (Date)avoirRow.getObject("DATE");
        this.nom = avoirRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
        AccountingRecordsProvider provider = AccountingRecordsProviderManager.get("accounting.records.sales.credit");
        provider.putLabel(avoirRow, this.mEcritures);
        this.mEcritures.put("ID_JOURNAL", journal);
        if (affacturage && (idJrnlFactor = rowPrefsCompte.getInt("ID_JOURNAL_FACTOR")) > 1) {
            this.mEcritures.put("ID_JOURNAL", idJrnlFactor);
        }
        this.mEcritures.put("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            rowValsPiece = new SQLRowValues(pieceTable);
            provider.putPieceLabel(avoirRow, rowValsPiece);
            this.getNewMouvement("AVOIR_CLIENT", this.idAvoirClient, 1, rowValsPiece);
        } else {
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
            rowValsPiece = pieceTable.getTable("MOUVEMENT").getRow(this.idMvt).getForeign("ID_PIECE").asRowValues();
            provider.putPieceLabel(avoirRow, rowValsPiece);
            rowValsPiece.update();
        }
        BigDecimal portHT = BigDecimal.valueOf(avoirRow.getLong("PORT_HT")).movePointLeft(2);
        TotalCalculator calc = this.getValuesFromElement(avoirRow, avoirRow.getTable().getTable("AVOIR_CLIENT_ELEMENT"), portHT, null, null);
        for (SQLRowAccessor row : calc.getMapHt().keySet()) {
            long b = calc.getMapHt().get(row).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (b == 0L) continue;
            this.mEcritures.put("ID_COMPTE_PCE", row.getID());
            this.mEcritures.put("DEBIT", b);
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
        }
        Map<SQLRowAccessor, BigDecimal> tvaMap = calc.getMapHtTVA();
        for (SQLRowAccessor rowAc : tvaMap.keySet()) {
            long longValue = tvaMap.get(rowAc).setScale(2, RoundingMode.HALF_UP).movePointRight(2).longValue();
            if (longValue == 0L) continue;
            this.mEcritures.put("ID_COMPTE_PCE", rowAc.getID());
            this.mEcritures.put("DEBIT", longValue);
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
        }
        int idCompteClient = avoirRow.getForeignRow("ID_CLIENT").getInt("ID_COMPTE_PCE");
        if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
            idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
        }
        this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
        this.mEcritures.put("DEBIT", 0L);
        long ttc = calc.getTotalTTC().movePointRight(2).longValue();
        this.mEcritures.put("CREDIT", ttc);
        this.ajoutEcriture();
        SQLRowValues valAvoir = new SQLRowValues(avoirClientTable);
        valAvoir.put("ID_MOUVEMENT", (Object)this.idMvt);
        if (valAvoir.getInvalid() == null) {
            valAvoir.update(this.idAvoirClient);
        }
        if (affacturage) {
            this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
            this.mEcritures.put("DEBIT", ttc);
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
            int idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR");
            if (idComptefactor <= 1 && (idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR")) <= 1) {
                try {
                    idComptefactor = ComptePCESQLElement.getIdComptePceDefault("Factor");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idComptefactor);
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", ttc);
            this.ajoutEcriture();
        }
        if (avoirRow.getInt("ID_MODE_REGLEMENT") > 1) {
            new GenerationMvtReglementAvoir(this.idAvoirClient, this.idMvt);
        } else {
            valAvoir.put("SOLDE", Boolean.FALSE);
            valAvoir.update(this.idAvoirClient);
        }
        return this.idMvt;
    }
}

