/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public final class GenerationMvtAcompte
extends GenerationEcritures
implements Runnable {
    private int idSalarie;
    private long montant;
    private int idAcompte;
    private static final SQLTable tableSalarie = base.getTable("SALARIE");
    private static final SQLTable tableAcompte = base.getTable("ACOMPTE");
    private static final Integer journalOD = 6;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtAcompte(int idAcompte) throws SQLException {
        this.idAcompte = idAcompte;
        SQLRow rowAcompte = tableAcompte.getRow(idAcompte);
        this.idSalarie = rowAcompte.getInt("ID_SALARIE");
        this.montant = GestionDevise.parseLongCurrency(String.valueOf(rowAcompte.getFloat("MONTANT")));
        SQLRow rowSal = tableSalarie.getRow(this.idSalarie);
        this.idMvt = this.getNewMouvement("ACOMPTE", this.idAcompte, 1, "Acompte " + rowSal.getString("NOM"));
        new Thread(this).start();
    }

    private void genereComptaAcompte() throws Exception {
        System.out.println("G\u00e9n\u00e9ration des ecritures du mouvement " + this.idMvt);
        SQLRow rowSal = tableSalarie.getRow(this.idSalarie);
        this.date = new Date();
        this.nom = "Acompte " + rowSal.getString("NOM");
        this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", journalOD);
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        int idCompteAcompte = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACOMPTE");
        if (idCompteAcompte <= 1) {
            idCompteAcompte = ComptePCESQLElement.getIdComptePceDefault("PayeAcompte");
        }
        this.mEcritures.put("ID_COMPTE_PCE", idCompteAcompte);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("DEBIT", this.montant);
        this.mEcritures.put("CREDIT", 0L);
        this.ajoutEcriture();
        int idCompteTresor = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACOMPTE_REGL");
        if (idCompteTresor <= 1) {
            try {
                idCompteTresor = ComptePCESQLElement.getIdComptePceDefault("PayeReglementAcompte");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mEcritures.put("ID_COMPTE_PCE", idCompteTresor);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("DEBIT", 0L);
        this.mEcritures.put("CREDIT", this.montant);
        this.ajoutEcriture();
        SQLRowValues rowVals = new SQLRowValues(tableAcompte);
        rowVals.put("ID_MOUVEMENT", (Object)this.idMvt);
        rowVals.update(this.idAcompte);
    }

    @Override
    public void run() {
        try {
            this.genereComptaAcompte();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des mouvements", e);
        }
    }
}

