/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationEcritures {
    protected static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    protected static final SQLTable compteTable = base.getTable("COMPTE_PCE");
    protected static final SQLTable journalTable = base.getTable("JOURNAL");
    protected static final SQLTable ecritureTable = base.getTable("ECRITURE");
    protected static final SQLTable pieceTable = base.getTable("PIECE");
    protected int idMvt;
    protected int idPiece;
    protected Date date;
    protected String nom;
    public Map<String, Object> mEcritures = new HashMap<String, Object>();

    public synchronized int ajoutEcriture() throws IllegalArgumentException {
        Number n2;
        long debit = (Long)this.mEcritures.get("DEBIT");
        long credit = (Long)this.mEcritures.get("CREDIT");
        Number n = (Number)this.mEcritures.get("ID_JOURNAL");
        if (n != null) {
            SQLRow rowJrnl = journalTable.getRow(n.intValue());
            this.mEcritures.put("JOURNAL_NOM", rowJrnl.getString("NOM"));
            this.mEcritures.put("JOURNAL_CODE", rowJrnl.getString("CODE"));
        }
        if ((n2 = (Number)this.mEcritures.get("ID_COMPTE_PCE")) != null) {
            SQLRow rowCpt = compteTable.getRow(n2.intValue());
            this.mEcritures.put("COMPTE_NUMERO", rowCpt.getString("NUMERO"));
            this.mEcritures.put("COMPTE_NOM", rowCpt.getString("NOM"));
        }
        if (debit != 0L && credit != 0L) {
            throw new IllegalArgumentException("Le d\u00e9bit et le cr\u00e9dit ne peuvent pas \u00eatre tous les 2 diff\u00e9rents de 0. Debit : " + debit + " Credit : " + credit);
        }
        if (debit < 0L) {
            credit = -debit;
            debit = 0L;
        }
        if (credit < 0L) {
            debit = -credit;
            credit = 0L;
        }
        this.mEcritures.put("DEBIT", debit);
        this.mEcritures.put("CREDIT", credit);
        Date d = (Date)this.mEcritures.get("DATE");
        SQLTable tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = tableExercice.getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        Date dDebEx = (Date)rowExercice.getObject("DATE_DEB");
        Date dCloture = (Date)rowExercice.getObject("DATE_CLOTURE");
        if (dCloture != null) {
            if (dCloture.after(d)) {
                System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
                throw new IllegalArgumentException("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            }
        } else if (dDebEx.after(d)) {
            System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            throw new IllegalArgumentException("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
        }
        SQLRowValues valEcriture = new SQLRowValues(ecritureTable, this.mEcritures);
        valEcriture.put("IDUSER_CREATE", UserManager.getInstance().getCurrentUser().getId());
        try {
            if (valEcriture.getInvalid() == null) {
                SQLRow ecritureRow = valEcriture.insert();
                return ecritureRow.getID();
            }
            System.err.println("GenerationEcritures.java :: Error in values for insert in table " + ecritureTable.getName() + " : " + valEcriture.toString());
            throw new IllegalArgumentException("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures donn\u00e9es incorrectes. " + valEcriture);
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + ecritureTable.getName() + " : " + e);
            final SQLException eFinal = e;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures.", eFinal);
                }
            });
            e.printStackTrace();
            return -1;
        }
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, SQLRowValues rowValsPiece) throws SQLException {
        SQLRow rowPiece = rowValsPiece.insert();
        return this.getNewMouvement(source, idSource, idPere, rowPiece.getID());
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, String nomPiece) throws SQLException {
        SQLRowValues rowValsPiece = new SQLRowValues(pieceTable);
        rowValsPiece.put("NOM", nomPiece);
        return this.getNewMouvement(source, idSource, idPere, rowValsPiece);
    }

    protected TotalCalculator getValuesFromElement(SQLRow row, SQLTable foreign, BigDecimal portHT, SQLRow rowTVAPort, SQLTable tableEchantillon) {
        Collection rows;
        TotalCalculator calc = new TotalCalculator("T_PA_HT", "T_PV_HT", null);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
        long remise = 0L;
        BigDecimal totalAvtRemise = BigDecimal.ZERO;
        if (row.getTable().contains("REMISE_HT") && (remise = row.getLong("REMISE_HT")) != 0L) {
            rows = row.getReferentRows(foreign);
            for (SQLRow sqlRow : rows) {
                calc.addLine(sqlRow, sqlRow.getForeign("ID_ARTICLE"), 1, false);
            }
            if (tableEchantillon != null) {
                Collection rowsEch = row.getReferentRows(tableEchantillon);
                for (SQLRow sqlRow : rowsEch) {
                    calc.addEchantillon((BigDecimal)sqlRow.getObject("T_PV_HT"), sqlRow.getForeign("ID_TAXE"));
                }
            }
            calc.checkResult();
            totalAvtRemise = calc.getTotalHT();
        }
        calc.initValues();
        calc.setRemise(remise, totalAvtRemise);
        rows = row.getReferentRows(foreign);
        int i = 0;
        while (i < rows.size()) {
            SQLRow sqlRow;
            sqlRow = (SQLRow)rows.get(i);
            calc.addLine(sqlRow, sqlRow.getForeign("ID_ARTICLE"), i, i == rows.size() - 1);
            ++i;
        }
        if (tableEchantillon != null) {
            Collection rowsEch = row.getReferentRows(tableEchantillon);
            for (SQLRow sqlRow : rowsEch) {
                calc.addEchantillon((BigDecimal)sqlRow.getObject("T_PV_HT"), sqlRow.getForeign("ID_TAXE"));
            }
        }
        if (rowTVAPort != null && !rowTVAPort.isUndefined()) {
            SQLRowValues rowValsPort = new SQLRowValues(foreign);
            rowValsPort.put("T_PV_HT", portHT);
            rowValsPort.put("QTE", 1);
            rowValsPort.put("ID_TAXE", rowTVAPort.getIDNumber());
            calc.addLine(rowValsPort, null, 1, false);
        }
        calc.checkResult();
        return calc;
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, int idPiece) throws SQLException {
        SQLTable mouvementTable = base.getTable("MOUVEMENT");
        SQLSelect selNumMvt = new SQLSelect();
        selNumMvt.addSelect(mouvementTable.getField("NUMERO"), "MAX");
        String reqNumMvt = selNumMvt.asString();
        Object obNumMvt = base.getDataSource().executeScalar(reqNumMvt);
        int numMvt = 1;
        if (obNumMvt != null) {
            numMvt = Integer.parseInt(obNumMvt.toString());
        }
        ++numMvt;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("SOURCE", source);
        m.put("IDSOURCE", idSource);
        m.put("ID_MOUVEMENT_PERE", idPere);
        this.idPiece = idPiece;
        m.put("ID_PIECE", idPiece);
        m.put("NUMERO", numMvt);
        SQLRowValues val = new SQLRowValues(mouvementTable, m);
        if (val.getInvalid() != null) {
            throw new IllegalStateException("Error in values for insert in table " + val.getTable().getName() + " : " + val.toString());
        }
        SQLRow row = val.insert();
        this.idMvt = row.getID();
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        System.err.println("Numero de mouvement g\u00e9n\u00e9r\u00e9 : " + numMvt);
        return this.idMvt;
    }
}

