/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.Caisse;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPrinter;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.touch.ScrollableList;

public class ListeDesTicketsPanel
extends JPanel
implements ListSelectionListener {
    private JList l;
    private CaisseFrame frame;
    private Image bg;
    private TextAreaTicketPrinter ticketP;
    private ScrollableList ticketList;
    private DefaultListModel ticketLlistModel;

    ListeDesTicketsPanel(CaisseFrame caisseFrame) {
        this.frame = caisseFrame;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(48, 44));
        p.setMinimumSize(new Dimension(48, 44));
        p.setOpaque(false);
        this.add((Component)p, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.gridheight = 2;
        this.ticketLlistModel = new DefaultListModel();
        this.ticketLlistModel.addAll(new Vector<Ticket>(Caisse.allTickets()));
        final Font f = new Font("Arial", 0, 24);
        this.ticketList = new ScrollableList(this.ticketLlistModel){

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                g.setFont(f);
                if (isSelected) {
                    g.setColor(new Color(232, 242, 254));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (isSelected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Ticket article = (Ticket)object;
                String label = "Ticket " + article.getCode();
                String euro = String.valueOf(TicketCellRenderer.centsToString(article.getTotal())) + "\u20ac";
                int wEuro = (int)g.getFontMetrics().getStringBounds(euro, g).getWidth();
                g.drawString(label, 10, posY + 39);
                g.drawString(euro, this.getWidth() - 5 - wEuro, posY + 39);
            }
        };
        this.add((Component)this.ticketList, c);
        c.fill = 3;
        ++c.gridx;
        c.gridheight = 1;
        c.insets = new Insets(10, 10, 10, 10);
        this.ticketP = new TextAreaTicketPrinter();
        JScrollPane scrollPane = new JScrollPane(this.ticketP);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        scrollPane.setMinimumSize(new Dimension(400, 200));
        this.add((Component)scrollPane, c);
        this.ticketList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedValue = ListeDesTicketsPanel.this.ticketList.getSelectedValue();
                ListeDesTicketsPanel.this.setSelectedTicket(selectedValue);
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        final Font font = new Font("Arial", 0, 46);
        this.l = new JList<String>(new String[]{"Imprimer", "Effacer", "", "Retour Menu"});
        this.l.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = new JLabel(value.toString()){

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(0, 0, this.getWidth(), 0);
                    }
                };
                l.setFont(font);
                return l;
            }
        });
        this.l.setSelectionMode(0);
        this.l.getSelectionModel().addListSelectionListener(this);
        this.l.setFixedCellHeight(80);
        this.add((Component)this.l, c);
        this.bg = new ImageIcon(TicketPanel.class.getResource("toolbar.png")).getImage();
        this.setFont(new Font("Arial", 1, 24));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object selectedValue = this.ticketList.getSelectedValue();
        int selectedIndex = this.l.getSelectedIndex();
        if (selectedIndex == 0) {
            if (selectedValue != null) {
                TicketPrinter prt = Caisse.getTicketPrinter();
                ((Ticket)selectedValue).print(prt);
            }
        } else if (selectedIndex == 1) {
            if (selectedValue != null) {
                this.ticketLlistModel.removeElement(selectedValue);
                this.ticketList.clearSelection();
                ((Ticket)selectedValue).deleteTicket();
            }
        } else if (selectedIndex == 3) {
            this.frame.showMenu();
        }
        this.l.clearSelection();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int imWidth = this.bg.getWidth(null);
        int x = 0;
        while (x <= w) {
            g.drawImage(this.bg, x, 0, null);
            x += imWidth;
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(250, 250, 250));
        String str = "Liste des tickets";
        Rectangle2D r = g.getFontMetrics().getStringBounds(str, g);
        int x2 = (int)((double)this.getWidth() - r.getWidth()) / 2;
        g.drawString(str, x2, 30);
    }

    public void setSelectedTicket(Object selectedValue) {
        this.ticketP.clear();
        if (selectedValue != null) {
            ((Ticket)selectedValue).print(this.ticketP);
            try {
                this.ticketP.printBuffer();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.ticketList.setSelectedValue(selectedValue, true);
    }
}

