/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.element;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.credit.component.AvoirClientSQLComponent;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.shipment.component.BonDeLivraisonSQLComponent;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.rights.NXRights;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.utils.CollectionMap;

public class SaisieVenteFactureSQLElement
extends ComptaSQLConfElement {
    public SaisieVenteFactureSQLElement() {
        super("SAISIE_VENTE_FACTURE", "une facture", "factures");
        boolean affact = UserManager.getInstance().getCurrentUser().getRights().haveRight(NXRights.ACCES_RETOUR_AFFACTURAGE.getCode());
        ArrayList<RowAction.PredicateRowAction> l = new ArrayList<RowAction.PredicateRowAction>(5);
        RowAction.PredicateRowAction actionBL = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieVenteFactureSQLElement elt = (SaisieVenteFactureSQLElement)Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                elt.transfertBL(IListe.get(e).getSelectedId());
            }
        }, false, "sales.invoice.create.delivery");
        actionBL.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        l.add(actionBL);
        RowAction.PredicateRowAction actionAvoir = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieVenteFactureSQLElement elt = (SaisieVenteFactureSQLElement)Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                elt.transfertAvoir(IListe.get(e).getSelectedId());
            }
        }, false, "sales.invoice.create.credit");
        actionAvoir.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        l.add(actionAvoir);
        RowAction.PredicateRowAction actionClone = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                EditFrame editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                ((SaisieVenteFactureSQLComponent)editFrame.getSQLComponent()).loadFactureExistante(IListe.get(e).getSelectedId());
                editFrame.setVisible(true);
            }
        }, false, "sales.invoice.clone");
        actionClone.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        l.add(actionClone);
        this.getRowActions().addAll(l);
        RowAction.PredicateRowAction actionClient = new RowAction.PredicateRowAction((Action)new AbstractAction("D\u00e9tails client"){
            EditFrame edit;
            private SQLElement eltClient;
            {
                this.eltClient = Configuration.getInstance().getDirectory().getElement(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.edit == null) {
                    this.edit = new EditFrame(this.eltClient, EditPanel.EditMode.READONLY);
                }
                this.edit.selectionId(IListe.get(e).getSelectedRow().getInt("ID_CLIENT"));
                this.edit.setVisible(true);
            }
        }, false, "sales.invoice.info.show");
        actionClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionClient);
        RowAction.PredicateRowAction actionCommande = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieVenteFactureSQLElement elt = (SaisieVenteFactureSQLElement)Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
                elt.transfertCommande(IListe.get(e).getSelectedId());
            }
        }, false, "sales.invoice.create.supplier.order");
        actionCommande.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionCommande);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener(VenteFactureXmlSheet.class);
        this.getRowActions().addAll(mouseSheetXmlListeListener.getRowActions());
    }

    @Override
    public CollectionMap<String, String> getShowAs() {
        CollectionMap<String, String> map = new CollectionMap<String, String>();
        map.put(null, (Object)"NUMERO");
        return map;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("NOM");
        l.add("ID_CLIENT");
        l.add("ID_MODE_REGLEMENT");
        l.add("ID_COMMERCIAL");
        l.add("T_HA");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("INFOS");
        l.add("DATE_ENVOI");
        l.add("DATE_REGLEMENT");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("ACOMPTE", null);
                graphToFetch.put("COMPLEMENT", null);
                graphToFetch.put("PREVISIONNELLE", null);
                graphToFetch.grow("ID_MODE_REGLEMENT").put("AJOURS", null).put("LENJOUR", null);
                SQLRowValues value = new SQLRowValues(graphToFetch.getTable().getTable("MOUVEMENT"));
                value.put("ID_PIECE", null);
                graphToFetch.put("ID_MOUVEMENT", value);
                graphToFetch.put("T_AVOIR_TTC", null);
            }
        };
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_MODE_REGLEMENT");
        return l;
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("SAISIE_VENTE_FACTURE_ELEMENT");
        return set;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("CONTROLE_TECHNIQUE");
        return s;
    }

    @Override
    public Set<String> getInsertOnlyFields() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("ACOMPTE");
        return s;
    }

    @Override
    public SQLComponent createComponent() {
        return new SaisieVenteFactureSQLComponent();
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        if (row.getInt("ID_AVOIR_CLIENT") > 1) {
            SQLElement eltAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT");
            SQLRow rowAvoir = eltAvoir.getTable().getRow(row.getInt("ID_AVOIR_CLIENT"));
            Long montantSolde = (Long)rowAvoir.getObject("MONTANT_SOLDE");
            Long avoirTTC = (Long)row.getObject("T_AVOIR_TTC");
            long montant = montantSolde - avoirTTC;
            if (montant < 0L) {
                montant = 0L;
            }
            SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
            rowVals.put("SOLDE", Boolean.FALSE);
            rowVals.put("MONTANT_SOLDE", montant);
            Long restant = (Long)rowAvoir.getObject("MONTANT_TTC") - montantSolde;
            rowVals.put("MONTANT_RESTANT", restant);
            try {
                rowVals.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        super.archive(row, cutLinks);
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) {
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l != null) {
                int i = 0;
                while (i < l.size()) {
                    Object[] tmp = (Object[])l.get(i);
                    eltMvtStock.archive(((Number)tmp[0]).intValue());
                    ++i;
                }
            }
        }
    }

    public void transfertBL(int idFacture) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        EditFrame editAvoirFrame = new EditFrame(elt);
        editAvoirFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        BonDeLivraisonSQLComponent comp = (BonDeLivraisonSQLComponent)editAvoirFrame.getSQLComponent();
        SQLInjector inject = SQLInjector.getInjector(this.getTable(), elt.getTable());
        SQLRowValues createRowValuesFrom = inject.createRowValuesFrom(idFacture);
        SQLRow rowFacture = this.getTable().getRow(idFacture);
        String string = rowFacture.getString("NOM");
        createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ", ") + rowFacture.getString("NUMERO"));
        comp.select(createRowValuesFrom);
        editAvoirFrame.pack();
        editAvoirFrame.setState(0);
        editAvoirFrame.setVisible(true);
    }

    public void transfertAvoir(int idFacture) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT");
        EditFrame editAvoirFrame = new EditFrame(elt);
        editAvoirFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        AvoirClientSQLComponent comp = (AvoirClientSQLComponent)editAvoirFrame.getSQLComponent();
        SQLInjector inject = SQLInjector.getInjector(this.getTable(), elt.getTable());
        comp.select(inject.createRowValuesFrom(idFacture));
        comp.loadFactureItem(idFacture);
        editAvoirFrame.pack();
        editAvoirFrame.setState(0);
        editAvoirFrame.setVisible(true);
    }

    public void transfertCommande(int idFacture) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
        Collection rows = this.getTable().getRow(idFacture).getReferentRows(elt.getTable());
        CollectionMap<SQLRow, List<SQLRowValues>> map = new CollectionMap<SQLRow, List<SQLRowValues>>();
        SQLRow rowDeviseF = null;
        for (SQLRow sqlRow : rows) {
            SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
            for (SQLField field : eltArticle.getTable().getFields()) {
                if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
            }
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
            SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
            SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
            SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
            rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
            rowValsElt.put("QTE", sqlRow.getObject("QTE"));
            rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
            rowDeviseF = sqlRow.getForeignRow("ID_DEVISE");
            SQLRow rowDeviseHA = rowArticleFind.getForeignRow("ID_DEVISE_HA");
            BigDecimal qte = new BigDecimal(rowValsElt.getInt("QTE"));
            if (rowDeviseF != null && !rowDeviseF.isUndefined()) {
                if (rowDeviseF.getID() == rowDeviseHA.getID()) {
                    rowValsElt.put("PA_DEVISE", rowArticleFind.getObject("PA_DEVISE"));
                    rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowArticleFind.getObject("PA_DEVISE")).multiply(qte, MathContext.DECIMAL128));
                    rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                } else {
                    BigDecimal taux = (BigDecimal)rowDeviseF.getObject("TAUX");
                    rowValsElt.put("PA_DEVISE", taux.multiply((BigDecimal)rowValsElt.getObject("PA_HT")));
                    rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowValsElt.getObject("PA_DEVISE")).multiply(qte, MathContext.DECIMAL128));
                    rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                }
            }
            BigDecimal prixHA = (BigDecimal)rowValsElt.getObject("PA_HT");
            rowValsElt.put("T_PA_HT", prixHA.multiply(qte, MathContext.DECIMAL128));
            rowValsElt.put("T_PA_HT", prixHA.multiply(qte, MathContext.DECIMAL128));
            rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(new BigDecimal((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), MathContext.DECIMAL128));
            map.put((Object)rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
        }
        MouvementStockSQLElement.createCommandeF(map, rowDeviseF);
    }
}

