/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtAcompte;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;

public class AcompteSQLElement
extends ComptaSQLConfElement {
    public AcompteSQLElement() {
        super("ACOMPTE", "un acompte", "acompte");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("ID_SALARIE");
        list.add("MONTANT");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("ID_SALARIE");
        list.add("MONTANT");
        return list;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            ElementComboBox comboSelSal;
            JTextField textMontant;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.comboSelSal = new ElementComboBox();
                this.add((Component)new JLabel("Salari\u00e9", 4), c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.comboSelSal, c);
                c.weightx = 0.0;
                this.textMontant = new JTextField(10);
                JLabel labelMontant = new JLabel("Montant");
                ++c.gridy;
                c.gridx = 0;
                c.weighty = 1.0;
                c.anchor = 12;
                this.add((Component)labelMontant, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.anchor = 18;
                c.fill = 0;
                c.weightx = 0.0;
                this.add((Component)this.textMontant, c);
                this.addRequiredSQLObject(this.comboSelSal, "ID_SALARIE");
                this.addRequiredSQLObject(this.textMontant, "MONTANT");
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                try {
                    SQLRow rowTmp = this.getTable().getRow(id);
                    new GenerationMvtAcompte(id);
                    SQLTable tableSal = this.getTable().getBase().getTable("SALARIE");
                    SQLTable tableFichePaye = this.getTable().getBase().getTable("FICHE_PAYE");
                    SQLRow rowSal = tableSal.getRow(rowTmp.getInt("ID_SALARIE"));
                    SQLRow rowFiche = tableFichePaye.getRow(rowSal.getInt("ID_FICHE_PAYE"));
                    SQLRowValues rowVals = new SQLRowValues(tableFichePaye);
                    float nouveauMontantAcompte = rowFiche.getFloat("ACOMPTE") + rowTmp.getFloat("MONTANT");
                    rowVals.put("ACOMPTE", new Float(nouveauMontantAcompte));
                    rowVals.update(rowFiche.getID());
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de l'insertion", e);
                }
                return id;
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".advance";
    }
}

