/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowValues;

public class JournalSQLElement
extends ComptaSQLConfElement {
    public JournalSQLElement() {
        super("JOURNAL", "un journal", "journaux");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("NOM");
        list.add("CODE");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("NOM");
        list.add("CODE");
        return list;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.add(new JLabel(this.getLabelFor("CODE")));
                JTextField code = new JTextField(6);
                this.add(code);
                this.add(new JLabel(this.getLabelFor("NOM")));
                JTextField nom = new JTextField(25);
                this.add(nom);
                JCheckBox checkBox = new JCheckBox(this.getLabelFor("TYPE_BANQUE"));
                this.add(checkBox);
                this.addView(nom, "NOM", (Object)"required");
                this.addView(code, "CODE", (Object)"required");
                this.addView(checkBox, "TYPE_BANQUE");
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("TYPE_BANQUE", Boolean.TRUE);
                return rowVals;
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".book";
    }
}

