/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.MargeTableCellRenderer;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteMultipleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.utils.ExceptionHandler;

public abstract class AbstractVenteArticleItemTable
extends AbstractArticleItemTable {
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private SQLTable tableArticleTarif = Configuration.getInstance().getBase().getTable("ARTICLE_TARIF");
    private SQLTable tableArticle = Configuration.getInstance().getBase().getTable("ARTICLE");

    public AbstractVenteArticleItemTable() {
    }

    public AbstractVenteArticleItemTable(List<JButton> buttons) {
        super(buttons);
    }

    @Override
    protected void init() {
        SQLTableElement marge;
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true);
        list.add(tableElementArticle);
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            SQLTableElement tableElementCodeDouane = new SQLTableElement(e.getTable().getField("CODE_DOUANIER"));
            list.add(tableElementCodeDouane);
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            SQLTableElement tableElementPays = new SQLTableElement(e.getTable().getField("ID_PAYS"));
            list.add(tableElementPays);
        }
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 2)) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && modeNumber.intValue() != 4) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 6)) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique1);
        if (e.getTable().getFieldsName().contains("PREBILAN")) {
            this.prebilan = new SQLTableElement(e.getTable().getField("PREBILAN"), BigDecimal.class);
            list.add(this.prebilan);
        }
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement eltDevise = null;
        SQLTableElement eltUnitDevise = null;
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            eltDevise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
            list.add(eltDevise);
            eltUnitDevise = new SQLTableElement(e.getTable().getField("PV_U_DEVISE"), BigDecimal.class);
            list.add(eltUnitDevise);
        }
        SQLField field = e.getTable().getField("PRIX_METRIQUE_VT_1");
        DeviseNumericCellEditor editorPVHT = new DeviseNumericCellEditor(field);
        editorPVHT.setConvertToTTCEnable(true);
        SQLTableElement tableElement_PrixMetrique1_VenteHT = new SQLTableElement(field, BigDecimal.class, editorPVHT);
        tableElement_PrixMetrique1_VenteHT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixMetrique1_VenteHT);
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        this.qte = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                if (AbstractVenteArticleItemTable.this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT")) {
                    return new QteMultipleRowValuesRenderer();
                }
                return super.getTableCellRenderer();
            }
        };
        this.qte.setPreferredSize(20);
        list.add(this.qte);
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        SQLField prixAchatHTField = e.getTable().getField("PA_HT");
        DeviseNumericCellEditor editorPAchatHT = new DeviseNumericCellEditor(prixAchatHTField);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), BigDecimal.class, editorPAchatHT){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        this.ha = new SQLTableElement(prixAchatHTField, BigDecimal.class, editorPAchatHT);
        this.ha.setRenderer(new DeviseTableCellRenderer());
        list.add(this.ha);
        SQLField prixVenteHTField = e.getTable().getField("PV_HT");
        DeviseNumericCellEditor editorPVenteHT = new DeviseNumericCellEditor(prixAchatHTField);
        final SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(prixVenteHTField, BigDecimal.class, editorPVenteHT);
        tableElement_PrixVente_HT.setRenderer(new DeviseTableCellRenderer());
        list.add(tableElement_PrixVente_HT);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        this.tableElementTVA.setPreferredSize(20);
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        tableElementPoids.setPreferredSize(20);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PV_HT"), BigDecimal.class);
        this.totalHT.setEditable(false);
        if (e.getTable().getFieldsName().contains("POURCENT_ACOMPTE")) {
            SQLTableElement tableElementAcompte = new SQLTableElement(e.getTable().getField("POURCENT_ACOMPTE"));
            list.add(tableElementAcompte);
            tableElementAcompte.addModificationListener(this.totalHT);
        }
        SQLTableElement tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"));
        list.add(tableElementRemise);
        SQLTableElement tableElementRG = null;
        if (e.getTable().getFieldsName().contains("POURCENT_RG")) {
            tableElementRG = new SQLTableElement(e.getTable().getField("POURCENT_RG"));
            list.add(tableElementRG);
        }
        this.totalHA = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        this.totalHA.setEditable(false);
        list.add(this.totalHA);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PV_T_DEVISE"), BigDecimal.class);
            list.add(this.tableElementTotalDevise);
        }
        if (e.getTable().getFieldsName().contains("MARGE_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_HT"), BigDecimal.class);
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.totalHA.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    BigDecimal lA;
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = (BigDecimal)row.getObject("T_PA_HT");
                    Object o = row.getObject("POURCENT_ACOMPTE");
                    BigDecimal bigDecimal = lA = o == null ? BigDecimal.valueOf(100L) : (BigDecimal)o;
                    if (lA.compareTo(BigDecimal.ZERO) >= 0 && lA.compareTo(BigDecimal.valueOf(100L)) < 0) {
                        ha = ha.multiply(lA, MathContext.DECIMAL128).movePointLeft(2);
                        vt = vt.multiply(lA, MathContext.DECIMAL128).movePointLeft(2);
                    }
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (e.getTable().getFieldsName().contains("MARGE_PREBILAN_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_PREBILAN_HT"), Long.class, new DeviseCellEditor());
            marge.setRenderer(new MargeTableCellRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.prebilan.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    BigDecimal lA;
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = row.getObject("PREBILAN") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PREBILAN");
                    Object o = row.getObject("POURCENT_ACOMPTE");
                    BigDecimal bigDecimal = lA = o == null ? BigDecimal.valueOf(100L) : (BigDecimal)o;
                    if (lA.compareTo(BigDecimal.ZERO) >= 0 && lA.compareTo(BigDecimal.valueOf(100L)) <= 100) {
                        ha = ha.multiply(lA, MathContext.DECIMAL128).movePointLeft(2);
                        vt = vt.multiply(lA, MathContext.DECIMAL128).movePointLeft(2);
                    }
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        this.totalHT.setEditable(false);
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PV_TTC"), BigDecimal.class);
        this.tableElementTotalTTC.setEditable(false);
        list.add(this.tableElementTotalTTC);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"));
        this.table = new RowValuesTable(this.model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        ArrayList<String> completionField = new ArrayList<String>();
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("CODE_DOUANIER");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("ID_PAYS");
        }
        completionField.add("ID_UNITE_VENTE");
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("POIDS");
        completionField.add("PRIX_METRIQUE_HA_1");
        completionField.add("PRIX_METRIQUE_HA_2");
        completionField.add("PRIX_METRIQUE_HA_3");
        completionField.add("VALEUR_METRIQUE_1");
        completionField.add("VALEUR_METRIQUE_2");
        completionField.add("VALEUR_METRIQUE_3");
        completionField.add("ID_MODE_VENTE_ARTICLE");
        completionField.add("PRIX_METRIQUE_VT_1");
        completionField.add("PRIX_METRIQUE_VT_2");
        completionField.add("PRIX_METRIQUE_VT_3");
        completionField.add("SERVICE");
        if (this.getSQLElement().getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionField.add("DESCRIPTIF");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("ID_DEVISE");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("PV_U_DEVISE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionField.add("QTE_ACHAT");
        }
        AutoCompletionManager m = new AutoCompletionManager(tableElementCode, sqlTableArticle.getField("CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        m.fill("NOM", "NOM");
        m.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m.fill(string, string);
        }
        m.setWhere(new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
        AutoCompletionManager m2 = new AutoCompletionManager(tableElementNom, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        m2.fill("CODE", "CODE");
        m2.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setWhere(new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
        AutoCompletionManager m3 = new AutoCompletionManager(tableElementArticle, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        m3.fill("CODE", "CODE");
        m3.fill("NOM", "NOM");
        for (String string : completionField) {
            m3.fill(string, string);
        }
        m3.setWhere(new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                SQLRowAccessor foreign = row.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                    return foreign.getID();
                }
                return AbstractVenteArticleItemTable.this.tableArticle.getUndefinedID();
            }
        });
        this.qte.addModificationListener(this.totalHT);
        this.qte.addModificationListener(this.totalHA);
        qteU.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHA);
        if (tableElementRG != null) {
            tableElementRG.addModificationListener(this.totalHT);
        }
        tableElementRemise.addModificationListener(this.totalHT);
        tableElement_PrixVente_HT.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHA);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                Object o3;
                BigDecimal lremise;
                Object o2 = row.getObject("POURCENT_REMISE");
                BigDecimal bigDecimal = lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                if (row.getTable().getFieldsName().contains("POURCENT_RG") && (o3 = row.getObject("POURCENT_RG")) != null) {
                    lremise.add((BigDecimal)o3);
                }
                int qte = row.getObject("QTE") == null ? 0 : Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PV_HT");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), MathContext.DECIMAL128), MathContext.DECIMAL128);
                if (row.getTable().getFieldsName().contains("POURCENT_ACOMPTE")) {
                    BigDecimal lA;
                    Object o = row.getObject("POURCENT_ACOMPTE");
                    BigDecimal bigDecimal2 = lA = o == null ? BigDecimal.ZERO : (BigDecimal)o;
                    if (lA.compareTo(BigDecimal.ZERO) >= 0 && lA.compareTo(BigDecimal.valueOf(100L)) <= 0) {
                        r = r.multiply(lA, MathContext.DECIMAL128).movePointLeft(2);
                    }
                }
                if (lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 100) {
                    r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), MathContext.DECIMAL128).movePointLeft(2);
                }
                return r.setScale(AbstractVenteArticleItemTable.this.totalHT.getDecimalDigits(), 4);
            }
        });
        this.totalHA.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                BigDecimal r = b.multiply(new BigDecimal(qte), MathContext.DECIMAL128).multiply(f, MathContext.DECIMAL128).setScale(6, 4);
                return r.setScale(AbstractVenteArticleItemTable.this.totalHA.getDecimalDigits(), 4);
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            this.qte.addModificationListener(this.tableElementTotalDevise);
            qteU.addModificationListener(this.tableElementTotalDevise);
            eltUnitDevise.addModificationListener(this.tableElementTotalDevise);
            tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    Object o2 = row.getObject("POURCENT_REMISE");
                    BigDecimal lremise = o2 == null ? BigDecimal.ZERO : (BigDecimal)o2;
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = (BigDecimal)row.getObject("PV_U_DEVISE");
                    BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                    BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte)), MathContext.DECIMAL128);
                    if (lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 100) {
                        r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), MathContext.DECIMAL128).movePointLeft(2);
                    }
                    return r.setScale(AbstractVenteArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                }
            });
        }
        this.totalHT.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                BigDecimal f = (BigDecimal)row.getObject("T_PV_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                if (resultTaux == null) {
                    System.err.println("Taxe par d\u00e9faut non valide");
                    Thread.dumpStack();
                    Integer i = TaxeCache.getCache().getFirstTaxe();
                    if (i == null) {
                        ExceptionHandler.handle("Aucune taxe d\u00e9finie!");
                    } else {
                        row.put("ID_TAXE", i);
                        resultTaux = TaxeCache.getCache().getTauxFromId(i);
                    }
                }
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                BigDecimal r = f.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), MathContext.DECIMAL128);
                return r.setScale(AbstractVenteArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.qte.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                Number f = (Number)row.getObject("POIDS");
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(f.floatValue() * (float)qte)).floatValue());
            }
        });
        uniteVente.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            eltUnitDevise.addModificationListener(tableElement_PrixMetrique1_VenteHT);
            tableElement_PrixMetrique1_VenteHT.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    if (!row.getForeign("ID_DEVISE").isUndefined()) {
                        BigDecimal t = (BigDecimal)row.getForeign("ID_DEVISE").getObject("TAUX");
                        BigDecimal bigDecimal = (BigDecimal)row.getObject("PV_U_DEVISE");
                        return t.equals(BigDecimal.ZERO) ? row.getObject("PRIX_METRIQUE_VT_1") : bigDecimal.multiply(t);
                    }
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
            });
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique2.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique3.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                BigDecimal prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(row);
                return prixVTFromDetails.setScale(tableElement_PrixVente_HT.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(AbstractVenteArticleItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        this.table.readState();
        this.setColumnVisible(this.model.getColumnForField("T_PA_HT"), true);
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_1"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_2"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_3"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("PV_HT"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("PA_HT"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("ID_MODE_VENTE_ARTICLE"), modeAvance);
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(this.model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(this.model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(this.model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(this.model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(this.model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        boolean showPoids = DefaultNXProps.getInstance().getBooleanValue("ArticleShowPoids", false);
        this.setColumnVisible(this.model.getColumnForField("POIDS"), showPoids);
        this.setColumnVisible(this.model.getColumnForField("T_POIDS"), showPoids);
        this.setColumnVisible(this.model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", true));
        this.setColumnVisible(this.model.getColumnForField("POURCENT_ACOMPTE"), false);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(this.model.getColumnForField(string), visibilityMap.get(string));
        }
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(this.model.getColumnForField(string), mapCustom.get(string));
            }
        }
        this.table.writeState();
    }

    protected Map<String, Boolean> getCustomVisibilityMap() {
        return null;
    }

    protected Object tarifCompletion(SQLRowAccessor row, String field) {
        if (this.getTarif() != null && !this.getTarif().isUndefined()) {
            Collection<? extends SQLRowAccessor> rows = row.getReferentRows(this.tableArticleTarif);
            SQLRowAccessor rowTarif = null;
            for (SQLRowAccessor sQLRowAccessor : rows) {
                if (sQLRowAccessor.getInt("ID_TARIF") != this.getTarif().getID()) continue;
                rowTarif = sQLRowAccessor;
            }
            if (rowTarif == null) {
                if (!this.getTarif().getForeign("ID_DEVISE").isUndefined()) {
                    if (field.equalsIgnoreCase("ID_DEVISE")) {
                        return this.getTarif().getObject("ID_DEVISE");
                    }
                    if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                        BigDecimal bigDecimal = (BigDecimal)this.getTarif().getForeign("ID_DEVISE").getObject("TAUX");
                        return bigDecimal.multiply((BigDecimal)row.getObject("PRIX_METRIQUE_VT_1")).setScale((int)row.getTable().getField(field).getType().getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                }
                return null;
            }
            if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                if (rowTarif.getInt("ID_DEVISE") == 1) {
                    return rowTarif.getObject(field);
                }
                BigDecimal bigDecimal = (BigDecimal)rowTarif.getForeign("ID_DEVISE").getObject("TAUX");
                return bigDecimal.multiply((BigDecimal)rowTarif.getObject(field)).setScale((int)row.getTable().getField(field).getType().getDecimalDigits(), RoundingMode.HALF_UP);
            }
            if (field.equalsIgnoreCase("ID_DEVISE")) {
                return rowTarif.getObject("ID_DEVISE");
            }
            if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                return rowTarif.getObject("PRIX_METRIQUE_VT_1");
            }
            if (field.equalsIgnoreCase("ID_TAXE") && rowTarif.getInt("ID_TAXE") != 1) {
                return rowTarif.getObject("ID_TAXE");
            }
        }
        return null;
    }

    @Override
    public void setTarif(SQLRowAccessor rowValuesTarif, boolean ask) {
        if (rowValuesTarif == null || this.getTarif() == null || rowValuesTarif.getID() != this.getTarif().getID()) {
            super.setTarif(rowValuesTarif, ask);
            if (ask && this.getRowValuesTable().getRowCount() > 0 && JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client sur les lignes d\u00e9j\u00e0 pr\u00e9sentes?") == 0) {
                int nbRows = this.table.getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                    SQLRowValues rowValsArticle = new SQLRowValues(this.tableArticle);
                    for (SQLField field : this.tableArticle.getFields()) {
                        if (!rowVals.getTable().getFieldsName().contains(field.getName())) continue;
                        rowValsArticle.put(field.getName(), rowVals.getObject(field.getName()));
                    }
                    int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowValsArticle, true);
                    SQLRow rowArticle = this.tableArticle.getRow(idArticle);
                    Collection rows = rowArticle.getReferentRows(this.tableArticleTarif);
                    boolean tarifFind = false;
                    if (this.getTarif() != null) {
                        for (SQLRowAccessor rowValsTarif : rows) {
                            if (rowValsTarif.getInt("ID_TARIF") != this.getTarif().getID()) continue;
                            if (rowValsTarif.getForeign("ID_DEVISE").isUndefined()) {
                                if (!rowValsTarif.getForeign("ID_TAXE").isUndefined()) {
                                    this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("ID_TAXE"), i, "ID_TAXE");
                                }
                                this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("PRIX_METRIQUE_VT_1"), i, "PRIX_METRIQUE_VT_1");
                            } else {
                                if (!rowValsTarif.getForeign("ID_TAXE").isUndefined()) {
                                    this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("ID_TAXE"), i, "ID_TAXE");
                                }
                                this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("ID_DEVISE"), i, "ID_DEVISE");
                                this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowArticle, "PV_U_DEVISE"), i, "PV_U_DEVISE");
                                this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowArticle, "PRIX_METRIQUE_VT_1"), i, "PRIX_METRIQUE_VT_1");
                            }
                            tarifFind = true;
                            break;
                        }
                    }
                    if (!tarifFind) {
                        this.getRowValuesTable().getRowValuesTableModel().putValue(rowArticle.getObject("PRIX_METRIQUE_VT_1"), i, "PRIX_METRIQUE_VT_1");
                    }
                    ++i;
                }
            }
        }
    }
}

