/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.component;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.utils.ExceptionHandler;

public abstract class TransfertBaseSQLComponent
extends BaseSQLComponent {
    private List<SQLRowValues> sourceRows;

    public TransfertBaseSQLComponent(SQLElement element) {
        super(element);
    }

    public void loadItem(AbstractArticleItemTable table, SQLElement elt, int id, SQLElement itemsElt) {
        this.loadItem(table, elt, id, itemsElt, true);
    }

    public void loadItem(AbstractArticleItemTable table, SQLElement elt, int id, SQLElement itemsElt, boolean clear) {
        Collection myListItem = elt.getTable().getRow(id).getReferentRows(itemsElt.getTable());
        if (myListItem.size() != 0) {
            SQLInjector injector = SQLInjector.getInjector(itemsElt.getTable(), table.getSQLElement().getTable());
            if (clear) {
                table.getModel().clearRows();
            }
            for (SQLRow rowElt : myListItem) {
                SQLRowValues createRowValuesFrom = injector.createRowValuesFrom(rowElt);
                if (createRowValuesFrom.getTable().getFieldsName().contains("POURCENT_ACOMPTE") && createRowValuesFrom.getObject("POURCENT_ACOMPTE") == null) {
                    createRowValuesFrom.put("POURCENT_ACOMPTE", new BigDecimal(100.0));
                }
                table.getModel().addRow(createRowValuesFrom);
                int rowIndex = table.getModel().getRowCount() - 1;
                table.getModel().fireTableModelModified(rowIndex);
            }
        } else if (clear) {
            table.getModel().clearRows();
            table.getModel().addNewRowAt(0);
        }
        table.getModel().fireTableDataChanged();
        table.repaint();
    }

    @Override
    public int insert(SQLRow order) {
        int insertedId = super.insert(order);
        if (insertedId != -1 && this.sourceRows != null && !this.sourceRows.isEmpty()) {
            SQLInjector injector = SQLInjector.getInjector(this.sourceRows.get(0).getTable(), this.getTable());
            try {
                injector.commitTransfert(this.sourceRows, insertedId);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Unable to insert transfert", e);
            }
        }
        return insertedId;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null) {
            super.select(null);
            return;
        }
        SQLRowValues singleRowValues = new SQLRowValues(r.asRowValues(), SQLRowValues.ForeignCopyMode.COPY_ID_OR_RM);
        super.select(singleRowValues);
        RowValuesTable table = this.getRowValuesTable();
        if (table != null) {
            table.clear();
            table.insertFrom(r);
        }
    }

    protected RowValuesTable getRowValuesTable() {
        return null;
    }
}

