/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import gnu.io.Zystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class RXTXPort
extends SerialPort {
    private static Zystem z;
    boolean MonitorThreadAlive = false;
    int IOLocked = 0;
    Object IOLockedMutex = new Object();
    private int fd = 0;
    long eis = 0L;
    int pid = 0;
    static boolean dsrFlag;
    private final SerialOutputStream out = new SerialOutputStream();
    private final SerialInputStream in = new SerialInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private SerialPortEventListener SPEventListener;
    private MonitorThread monThread;
    boolean monThreadisInterrupted = true;
    boolean MonitorThreadLock = true;
    boolean closeLock = false;

    private static native void Initialize();

    public RXTXPort(String string) throws PortInUseException {
        this.fd = this.open(string);
        this.name = string;
        this.MonitorThreadLock = true;
        this.monThread = new MonitorThread();
        this.monThread.start();
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadAlive = true;
        this.timeout = -1;
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public synchronized void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        if (this.nativeSetSerialPortParams(n, n2, n3, n4)) {
            throw new UnsupportedCommOperationException("Invalid Parameter");
        }
        this.speed = n;
        this.dataBits = n3 == 3 ? 5 : n2;
        this.stopBits = n3;
        this.parity = n4;
        z.reportln("RXTXPort:setSerialPortParams(" + n + " " + n2 + " " + n3 + " " + n4 + ") returning");
    }

    private native boolean nativeSetSerialPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public native void setDTR(boolean var1);

    private native void setDSR(boolean var1);

    protected native void writeByte(int var1, boolean var2) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected native boolean nativeDrain(boolean var1) throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    private native void interruptEventLoop();

    public boolean sendEvent(int n, boolean bl) {
        if (this.fd == 0 || this.SPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
        }
        switch (n) {
            case 1: {
                if (this.monThread.Data) break;
                return false;
            }
            case 2: {
                if (this.monThread.Output) break;
                return false;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return false;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return false;
            }
            case 5: {
                if (this.monThread.RI) break;
                return false;
            }
            case 6: {
                if (this.monThread.CD) break;
                return false;
            }
            case 7: {
                if (this.monThread.OE) break;
                return false;
            }
            case 8: {
                if (this.monThread.PE) break;
                return false;
            }
            case 9: {
                if (this.monThread.FE) break;
                return false;
            }
            case 10: {
                if (this.monThread.BI) break;
                return false;
            }
            default: {
                System.err.println("unknown event: " + n);
                return false;
            }
        }
        SerialPortEvent serialPortEvent = new SerialPortEvent(this, n, !bl, bl);
        if (this.monThreadisInterrupted) {
            return true;
        }
        if (this.SPEventListener != null) {
            this.SPEventListener.serialEvent(serialPortEvent);
        }
        return this.fd == 0 || this.SPEventListener == null || this.monThread == null;
    }

    public void removeEventListener() {
        this.waitForTheNativeCodeSilly();
        if (this.monThreadisInterrupted) {
            z.reportln("\tRXTXPort:removeEventListener() already interrupted");
            this.monThread = null;
            this.SPEventListener = null;
            return;
        }
        if (this.monThread != null && this.monThread.isAlive()) {
            this.monThreadisInterrupted = true;
            this.interruptEventLoop();
            try {
                this.monThread.join(3000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.monThread = null;
        this.SPEventListener = null;
        this.MonitorThreadLock = false;
        this.MonitorThreadAlive = false;
        this.monThreadisInterrupted = true;
        z.reportln("RXTXPort:removeEventListener() returning");
    }

    protected void waitForTheNativeCodeSilly() {
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    private native void nativeClose(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RXTXPort rXTXPort = this;
        synchronized (rXTXPort) {
            while (this.IOLocked > 0) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.closeLock) {
                return;
            }
            this.closeLock = true;
        }
        if (this.fd <= 0) {
            z.reportln("RXTXPort:close detected bad File Descriptor");
            return;
        }
        this.setDTR(false);
        this.setDSR(false);
        if (!this.monThreadisInterrupted) {
            this.removeEventListener();
        }
        this.nativeClose(this.name);
        super.close();
        this.fd = 0;
        this.closeLock = false;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
        z.finalize();
    }

    static {
        try {
            z = new Zystem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.loadLibrary("rxtxSerial");
        RXTXPort.Initialize();
        dsrFlag = false;
    }

    class MonitorThread
    extends Thread {
        private volatile boolean CTS = false;
        private volatile boolean DSR = false;
        private volatile boolean RI = false;
        private volatile boolean CD = false;
        private volatile boolean OE = false;
        private volatile boolean PE = false;
        private volatile boolean FE = false;
        private volatile boolean BI = false;
        private volatile boolean Data = false;
        private volatile boolean Output = false;

        MonitorThread() {
        }

        public void run() {
            RXTXPort.this.monThreadisInterrupted = false;
            RXTXPort.this.eventLoop();
        }

        protected void finalize() throws Throwable {
        }
    }

    class SerialInputStream
    extends InputStream {
        SerialInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read() throws IOException {
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                z.reportln("+++++++++ read() monThreadisInterrupted");
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int n;
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n2 = n = RXTXPort.this.readByte();
                return n2;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] byArray) throws IOException {
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int n;
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n2 = n = this.read(byArray, 0, byArray.length);
                return n2;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (RXTXPort.this.fd == 0) {
                z.reportln("+++++++ IOException()\n");
                throw new IOException();
            }
            if (byArray == null) {
                z.reportln("+++++++ NullPointerException()\n");
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                z.reportln("+++++++ IndexOutOfBoundsException()\n");
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n4 = n2;
            n4 = RXTXPort.this.threshold == 0 ? ((n3 = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(n4, n3)) : Math.min(n4, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int n5;
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n6 = n5 = RXTXPort.this.readArray(byArray, n, n4);
                return n6;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int available() throws IOException {
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int n;
                int n2 = n = RXTXPort.this.nativeavailable();
                return n2;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }
    }

    class SerialOutputStream
    extends OutputStream {
        SerialOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.fd == 0) {
                    throw new IOException();
                }
                RXTXPort.this.writeByte(n, RXTXPort.this.monThreadisInterrupted);
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(byArray, 0, byArray.length, RXTXPort.this.monThreadisInterrupted);
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException("Invalid offset/length passed to read");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(byArray2, 0, n2, RXTXPort.this.monThreadisInterrupted);
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.nativeDrain(RXTXPort.this.monThreadisInterrupted)) {
                    RXTXPort.this.sendEvent(2, true);
                }
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }
    }
}

