/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelAgentForwarding;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static int index = 0;
    private static Vector pool = new Vector();
    int id;
    int recipient = -1;
    byte[] type = Util.str2byte("foo");
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    long rwsize = 0L;
    int rmpsize = 0;
    IO io = null;
    Thread thread = null;
    boolean eof_local = false;
    boolean eof_remote = false;
    boolean close = false;
    boolean connected = false;
    int exitstatus = -1;
    int reply = 0;
    int connectTimeout = 0;
    private Session session;
    int notifyme = 0;

    static Channel getChannel(String string) {
        if (string.equals("session")) {
            return new ChannelSession();
        }
        if (string.equals("shell")) {
            return new ChannelShell();
        }
        if (string.equals("exec")) {
            return new ChannelExec();
        }
        if (string.equals("x11")) {
            return new ChannelX11();
        }
        if (string.equals("auth-agent@openssh.com")) {
            return new ChannelAgentForwarding();
        }
        if (string.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (string.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (string.equals("sftp")) {
            return new ChannelSftp();
        }
        if (string.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Channel getChannel(int n, Session session) {
        Vector vector = pool;
        synchronized (vector) {
            int n2 = 0;
            while (n2 < pool.size()) {
                Channel channel = (Channel)pool.elementAt(n2);
                if (channel.id == n && channel.session == session) {
                    return channel;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void del(Channel channel) {
        Vector vector = pool;
        synchronized (vector) {
            pool.removeElement(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel() {
        Vector vector = pool;
        synchronized (vector) {
            this.id = index++;
            pool.addElement(this);
        }
    }

    void setRecipient(int n) {
        this.recipient = n;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() throws JSchException {
    }

    public void connect() throws JSchException {
        this.connect(0);
    }

    public void connect(int n) throws JSchException {
        Session session = this.getSession();
        if (!session.isConnected()) {
            throw new JSchException("session is down");
        }
        this.connectTimeout = n;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)90);
            buffer.putString(this.type);
            buffer.putInt(this.id);
            buffer.putInt(this.lwsize);
            buffer.putInt(this.lmpsize);
            session.write(packet);
            int n2 = 1000;
            long l = System.currentTimeMillis();
            long l2 = n;
            while (this.getRecipient() == -1 && session.isConnected() && n2 > 0) {
                if (l2 > 0L && System.currentTimeMillis() - l > l2) {
                    n2 = 0;
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --n2;
            }
            if (!session.isConnected()) {
                throw new JSchException("session is down");
            }
            if (n2 == 0) {
                throw new JSchException("channel is not opened.");
            }
            if (this.isClosed()) {
                throw new JSchException("channel is not opened.");
            }
            this.connected = true;
            this.start();
        }
        catch (Exception exception) {
            this.connected = false;
            this.disconnect();
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            throw new JSchException(exception.toString(), exception);
        }
    }

    public void start() throws JSchException {
    }

    void getData(Buffer buffer) {
        this.setRecipient(buffer.getInt());
        this.setRemoteWindowSize(buffer.getUInt());
        this.setRemotePacketSize(buffer.getInt());
    }

    public void setInputStream(InputStream inputStream) {
        this.io.setInputStream(inputStream, false);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.io.setOutputStream(outputStream, false);
    }

    public InputStream getInputStream() throws IOException {
        MyPipedInputStream myPipedInputStream = new MyPipedInputStream(32768);
        this.io.setOutputStream(new PassiveOutputStream(myPipedInputStream), false);
        return myPipedInputStream;
    }

    void setLocalWindowSizeMax(int n) {
        this.lwsize_max = n;
    }

    void setLocalWindowSize(int n) {
        this.lwsize = n;
    }

    void setLocalPacketSize(int n) {
        this.lmpsize = n;
    }

    synchronized void setRemoteWindowSize(long l) {
        this.rwsize = l;
    }

    synchronized void addRemoteWindowSize(int n) {
        this.rwsize += (long)n;
        if (this.notifyme > 0) {
            this.notifyAll();
        }
    }

    void setRemotePacketSize(int n) {
        this.rmpsize = n;
    }

    public void run() {
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.io.put(byArray, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void write_ext(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.io.put_ext(byArray, n, n2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void eof_remote() {
        this.eof_remote = true;
        try {
            this.io.out_close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eof() {
        if (this.eof_local) {
            return;
        }
        this.eof_local = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)96);
            buffer.putInt(this.getRecipient());
            Channel channel = this;
            synchronized (channel) {
                if (!this.close) {
                    this.getSession().write(packet);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        this.eof_remote = true;
        this.eof_local = true;
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)97);
            buffer.putInt(this.getRecipient());
            Channel channel = this;
            synchronized (channel) {
                this.getSession().write(packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disconnect(Session session) {
        int n;
        Channel[] channelArray = null;
        int n2 = 0;
        Vector vector = pool;
        synchronized (vector) {
            channelArray = new Channel[pool.size()];
            n = 0;
            while (n < pool.size()) {
                try {
                    Channel channel = (Channel)pool.elementAt(n);
                    if (channel.session == session) {
                        channelArray[n2++] = channel;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            channelArray[n].disconnect();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        block10: {
            block9: {
                try {
                    Channel channel = this;
                    synchronized (channel) {
                        if (!this.connected) {
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 8] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                            Object var4_2 = null;
                            break block9;
                        }
                        this.connected = false;
                    }
                    this.close();
                    this.eof_local = true;
                    this.eof_remote = true;
                    this.thread = null;
                    try {
                        if (this.io != null) {
                            this.io.close();
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Channel.del(this);
                    throw throwable;
                }
            }
            Channel.del(this);
            return;
        }
        Object var4_3 = null;
        Channel.del(this);
    }

    public boolean isConnected() {
        Session session = this.session;
        if (session != null) {
            return session.isConnected() && this.connected;
        }
        return false;
    }

    void setExitStatus(int n) {
        this.exitstatus = n;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() throws JSchException {
        Session session = this.session;
        if (session == null) {
            throw new JSchException("session is not available");
        }
        return session;
    }

    protected void sendOpenConfirmation() throws Exception {
        Buffer buffer = new Buffer(100);
        Packet packet = new Packet(buffer);
        packet.reset();
        buffer.putByte((byte)91);
        buffer.putInt(this.getRecipient());
        buffer.putInt(this.id);
        buffer.putInt(this.lwsize);
        buffer.putInt(this.lmpsize);
        this.getSession().write(packet);
    }

    protected void sendOpenFailure(int n) {
        try {
            Buffer buffer = new Buffer(100);
            Packet packet = new Packet(buffer);
            packet.reset();
            buffer.putByte((byte)92);
            buffer.putInt(this.getRecipient());
            buffer.putInt(n);
            buffer.putString(Util.str2byte("open failed"));
            buffer.putString(Util.empty);
            this.getSession().write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream pipedInputStream) throws IOException {
            super(pipedInputStream);
        }
    }

    class PassiveInputStream
    extends MyPipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
            super(pipedOutputStream, n);
            this.out = pipedOutputStream;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream(int n) throws IOException {
            this.buffer = new byte[n];
        }

        MyPipedInputStream(PipedOutputStream pipedOutputStream, int n) throws IOException {
            super(pipedOutputStream);
            this.buffer = new byte[n];
        }
    }
}

