/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.Norm2AllModes;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Collator
implements Freezable<Collator>,
Comparator<Object> {
    private static ServiceShim shim;
    private static final String[] KEYWORDS;
    private int m_strength_ = 2;
    private int m_decomposition_ = 17;
    private static final boolean DEBUG;
    private ULocale validLocale;
    private ULocale actualLocale;

    public void setStrength(int newStrength) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        if (newStrength != 0 && newStrength != 1 && newStrength != 2 && newStrength != 3 && newStrength != 15) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.m_strength_ = newStrength;
    }

    public void setDecomposition(int decomposition) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify frozen object");
        }
        this.internalSetDecomposition(decomposition);
    }

    protected void internalSetDecomposition(int decomposition) {
        if (decomposition != 16 && decomposition != 17) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.m_decomposition_ = decomposition;
        if (decomposition != 16) {
            Norm2AllModes.getFCDNormalizer2();
        }
    }

    public void setReorderCodes(int ... order) {
        throw new UnsupportedOperationException();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static ServiceShim getShim() {
        if (shim == null) {
            try {
                Class<?> cls = Class.forName("com.ibm.icu.text.CollatorServiceShim");
                shim = (ServiceShim)cls.newInstance();
            }
            catch (MissingResourceException e) {
                throw e;
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return shim;
    }

    public static final Collator getInstance(ULocale locale) {
        return Collator.getShim().getInstance(locale);
    }

    public static final Collator getInstance(Locale locale) {
        return Collator.getInstance(ULocale.forLocale(locale));
    }

    public int getStrength() {
        return this.m_strength_;
    }

    public int getDecomposition() {
        return this.m_decomposition_;
    }

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object source, Object target) {
        return this.compare((String)source, (String)target);
    }

    public boolean isFrozen() {
        return false;
    }

    protected Collator() {
    }

    final void setLocale(ULocale valid, ULocale actual) {
        if (valid == null != (actual == null)) {
            throw new IllegalArgumentException();
        }
        this.validLocale = valid;
        this.actualLocale = actual;
    }

    static {
        KEYWORDS = new String[]{"collation"};
        DEBUG = ICUDebug.enabled("collator");
    }

    static abstract class ServiceShim {
        ServiceShim() {
        }

        abstract Collator getInstance(ULocale var1);
    }
}

