/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.IllegalIcuArgumentException;
import com.ibm.icu.impl.Norm2AllModes;
import com.ibm.icu.impl.Trie2;
import com.ibm.icu.impl.UCaseProps;
import com.ibm.icu.impl.UCharacterName;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.impl.UPropertyAliases;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.RangeValueIterator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.util.Iterator;

public final class UCharacter {
    public static int digit(int ch, int radix) {
        if (2 <= radix && radix <= 36) {
            int value = UCharacter.digit(ch);
            if (value < 0) {
                value = UCharacterProperty.getEuropeanDigit(ch);
            }
            return value < radix ? value : -1;
        }
        return -1;
    }

    public static int digit(int ch) {
        return UCharacterProperty.INSTANCE.digit(ch);
    }

    public static double getUnicodeNumericValue(int ch) {
        return UCharacterProperty.INSTANCE.getUnicodeNumericValue(ch);
    }

    public static int getType(int ch) {
        return UCharacterProperty.INSTANCE.getType(ch);
    }

    public static boolean isDigit(int ch) {
        return UCharacter.getType(ch) == 9;
    }

    public static boolean isLowerCase(int ch) {
        return UCharacter.getType(ch) == 2;
    }

    public static String toString(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            return null;
        }
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        StringBuilder result = new StringBuilder();
        result.append(UTF16.getLeadSurrogate(ch));
        result.append(UTF16.getTrailSurrogate(ch));
        return result.toString();
    }

    public static boolean isSupplementary(int ch) {
        return ch >= 65536 && ch <= 0x10FFFF;
    }

    public static int getCombiningClass(int ch) {
        return Norm2AllModes.getNFCInstance().decomp.getCombiningClass(ch);
    }

    public static VersionInfo getUnicodeVersion() {
        return UCharacterProperty.INSTANCE.m_unicodeVersion_;
    }

    public static int getCharFromExtendedName(String name) {
        return UCharacterName.INSTANCE.getCharFromName(2, name);
    }

    public static int getPropertyEnum(CharSequence propertyAlias) {
        int propEnum = UPropertyAliases.INSTANCE.getPropertyEnum(propertyAlias);
        if (propEnum == -1) {
            throw new IllegalIcuArgumentException("Invalid name: " + propertyAlias);
        }
        return propEnum;
    }

    public static int getPropertyValueEnum(int property, CharSequence valueAlias) {
        int propEnum = UPropertyAliases.INSTANCE.getPropertyValueEnum(property, valueAlias);
        if (propEnum == -1) {
            throw new IllegalIcuArgumentException("Invalid name: " + valueAlias);
        }
        return propEnum;
    }

    public static String toUpperCase(ULocale locale, String str) {
        int c;
        StringContextIterator iter = new StringContextIterator(str);
        StringBuilder result = new StringBuilder(str.length());
        int[] locCache = new int[1];
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        locCache[0] = 0;
        while ((c = iter.nextCaseMapCP()) >= 0) {
            if ((c = UCaseProps.INSTANCE.toFullUpper(c, iter, result, locale, locCache)) < 0) {
                c ^= 0xFFFFFFFF;
            } else if (c <= 31) continue;
            result.appendCodePoint(c);
        }
        return result.toString();
    }

    public static String toLowerCase(ULocale locale, String str) {
        int c;
        StringContextIterator iter = new StringContextIterator(str);
        StringBuilder result = new StringBuilder(str.length());
        int[] locCache = new int[1];
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        locCache[0] = 0;
        while ((c = iter.nextCaseMapCP()) >= 0) {
            if ((c = UCaseProps.INSTANCE.toFullLower(c, iter, result, locale, locCache)) < 0) {
                c ^= 0xFFFFFFFF;
            } else if (c <= 31) continue;
            result.appendCodePoint(c);
        }
        return result.toString();
    }

    public static String toTitleCase(ULocale locale, String str, BreakIterator titleIter) {
        return UCharacter.toTitleCase(locale, str, titleIter, 0);
    }

    public static String toTitleCase(ULocale locale, String str, BreakIterator titleIter, int options) {
        StringContextIterator iter = new StringContextIterator(str);
        StringBuilder result = new StringBuilder(str.length());
        int[] locCache = new int[1];
        int srcLength = str.length();
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        locCache[0] = 0;
        if (titleIter == null) {
            titleIter = BreakIterator.getWordInstance(locale);
        }
        titleIter.setText(str);
        boolean isDutch = locale.getLanguage().equals("nl");
        boolean FirstIJ = true;
        int prev = 0;
        boolean isFirstIndex = true;
        while (prev < srcLength) {
            int index;
            if (isFirstIndex) {
                isFirstIndex = false;
                index = titleIter.first();
            } else {
                index = titleIter.next();
            }
            if (index == -1 || index > srcLength) {
                index = srcLength;
            }
            if (prev < index) {
                int titleStart;
                iter.setLimit(index);
                int c = iter.nextCaseMapCP();
                if ((options & 0x200) == 0 && 0 == UCaseProps.INSTANCE.getType(c)) {
                    while ((c = iter.nextCaseMapCP()) >= 0 && 0 == UCaseProps.INSTANCE.getType(c)) {
                    }
                    titleStart = iter.getCPStart();
                    if (prev < titleStart) {
                        result.append(str, prev, titleStart);
                    }
                } else {
                    titleStart = prev;
                }
                if (titleStart < index) {
                    FirstIJ = true;
                    c = UCaseProps.INSTANCE.toFullTitle(c, iter, result, locale, locCache);
                    while (true) {
                        if (c < 0) {
                            result.appendCodePoint(c ^= 0xFFFFFFFF);
                        } else if (c > 31) {
                            result.appendCodePoint(c);
                        }
                        if ((options & 0x100) != 0) {
                            int titleLimit = iter.getCPLimit();
                            if (titleLimit < index) {
                                String appendStr = str.substring(titleLimit, index);
                                if (isDutch && c == 73 && appendStr.startsWith("j")) {
                                    appendStr = "J" + appendStr.substring(1);
                                }
                                result.append(appendStr);
                            }
                            iter.moveToLimit();
                            break;
                        }
                        int nc = iter.nextCaseMapCP();
                        if (nc < 0) break;
                        if (isDutch && (nc == 74 || nc == 106) && c == 73 && FirstIJ) {
                            c = 74;
                            FirstIJ = false;
                            continue;
                        }
                        c = UCaseProps.INSTANCE.toFullLower(nc, iter, result, locale, locCache);
                    }
                }
            }
            prev = index;
        }
        return result.toString();
    }

    public static int foldCase(int ch, boolean defaultmapping) {
        return UCharacter.foldCase(ch, defaultmapping ? 0 : 1);
    }

    public static String foldCase(String str, boolean defaultmapping) {
        return UCharacter.foldCase(str, defaultmapping ? 0 : 1);
    }

    public static int foldCase(int ch, int options) {
        return UCaseProps.INSTANCE.fold(ch, options);
    }

    public static final String foldCase(String str, int options) {
        StringBuilder result = new StringBuilder(str.length());
        int length = str.length();
        int i = 0;
        while (i < length) {
            int c = UTF16.charAt(str, i);
            i += UTF16.getCharCount(c);
            if ((c = UCaseProps.INSTANCE.toFullFolding(c, result, options)) < 0) {
                c ^= 0xFFFFFFFF;
            } else if (c <= 31) continue;
            result.appendCodePoint(c);
        }
        return result.toString();
    }

    public static RangeValueIterator getTypeIterator() {
        return new UCharacterTypeIterator();
    }

    public static VersionInfo getAge(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return UCharacterProperty.INSTANCE.getAge(ch);
    }

    public static boolean hasBinaryProperty(int ch, int property) {
        return UCharacterProperty.INSTANCE.hasBinaryProperty(ch, property);
    }

    public static boolean isUAlphabetic(int ch) {
        return UCharacter.hasBinaryProperty(ch, 0);
    }

    public static boolean isUWhiteSpace(int ch) {
        return UCharacter.hasBinaryProperty(ch, 31);
    }

    public static int getIntPropertyValue(int ch, int type) {
        return UCharacterProperty.INSTANCE.getIntPropertyValue(ch, type);
    }

    private static final class UCharacterTypeIterator
    implements RangeValueIterator {
        private Iterator<Trie2.Range> trieIterator;
        private Trie2.Range range;
        private static final MaskType MASK_TYPE = new MaskType();

        UCharacterTypeIterator() {
            this.reset();
        }

        public boolean next(RangeValueIterator.Element element) {
            if (this.trieIterator.hasNext()) {
                this.range = this.trieIterator.next();
                if (!this.range.leadSurrogate) {
                    element.start = this.range.startCodePoint;
                    element.limit = this.range.endCodePoint + 1;
                    element.value = this.range.value;
                    return true;
                }
            }
            return false;
        }

        public void reset() {
            this.trieIterator = UCharacterProperty.INSTANCE.m_trie_.iterator(MASK_TYPE);
        }

        private static final class MaskType
        implements Trie2.ValueMapper {
            private MaskType() {
            }

            public int map(int value) {
                return value & 0x1F;
            }
        }
    }

    private static class StringContextIterator
    implements UCaseProps.ContextIterator {
        protected String s;
        protected int index;
        protected int limit;
        protected int cpStart;
        protected int cpLimit;
        protected int dir;

        StringContextIterator(String s) {
            this.s = s;
            this.limit = s.length();
            this.index = 0;
            this.cpLimit = 0;
            this.cpStart = 0;
            this.dir = 0;
        }

        public void setLimit(int lim) {
            this.limit = 0 <= lim && lim <= this.s.length() ? lim : this.s.length();
        }

        public void moveToLimit() {
            this.cpStart = this.cpLimit = this.limit;
        }

        public int nextCaseMapCP() {
            this.cpStart = this.cpLimit;
            if (this.cpLimit < this.limit) {
                char c2;
                int c;
                if ((55296 <= (c = this.s.charAt(this.cpLimit++)) || c <= 57343) && c <= 56319 && this.cpLimit < this.limit && '\udc00' <= (c2 = this.s.charAt(this.cpLimit)) && c2 <= '\udfff') {
                    ++this.cpLimit;
                    c = UCharacterProperty.getRawSupplementary((char)c, c2);
                }
                return c;
            }
            return -1;
        }

        public int getCPStart() {
            return this.cpStart;
        }

        public int getCPLimit() {
            return this.cpLimit;
        }

        public void reset(int direction) {
            if (direction > 0) {
                this.dir = 1;
                this.index = this.cpLimit;
            } else if (direction < 0) {
                this.dir = -1;
                this.index = this.cpStart;
            } else {
                this.dir = 0;
                this.index = 0;
            }
        }

        public int next() {
            if (this.dir > 0 && this.index < this.s.length()) {
                int c = UTF16.charAt(this.s, this.index);
                this.index += UTF16.getCharCount(c);
                return c;
            }
            if (this.dir < 0 && this.index > 0) {
                int c = UTF16.charAt(this.s, this.index - 1);
                this.index -= UTF16.getCharCount(c);
                return c;
            }
            return -1;
        }
    }
}

