/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.MessagePattern;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.PropertiesUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.i18n.DynamicMap;
import org.openconcerto.utils.i18n.I18nUtils;
import org.openconcerto.utils.i18n.LocalizedInstances;
import org.openconcerto.utils.i18n.MessageArgs;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.i18n.Translator;
import org.openconcerto.utils.i18n.TranslatorChain;

public class TM {
    private static final TM INSTANCE = new TM();
    private static final Pattern splitPtrn = Pattern.compile("__", 16);
    private static boolean USE_DYNAMIC_MAP = true;
    private Locale locale;
    private TranslatorChain translations;
    private Locale translationsLocale;

    public static boolean useDynamicMap() {
        return USE_DYNAMIC_MAP;
    }

    public static TM getInstance() {
        return INSTANCE;
    }

    public static String tr(String key, Object ... args) {
        return TM.getInstance().translate(key, args);
    }

    protected TM() {
        this.init();
    }

    protected void init() {
        this.setLocale(Locale.getDefault());
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
        LocalizedInstances<Translator> localizedInstances = new LocalizedInstances<Translator>(Translator.class, TranslationManager.getControl()){

            @Override
            protected Translator createInstance(String bundleName, final Locale l, Class<?> cl) throws IOException {
                final Properties props = PropertiesUtils.createFromResource(cl, String.valueOf('/') + this.getControl().toResourceName(bundleName, "properties"));
                if (props == null) {
                    return null;
                }
                return new Translator(){

                    @Override
                    public String translate(String key, MessageArgs args) {
                        String msg = props.getProperty(key);
                        if (msg == null) {
                            return null;
                        }
                        return new MessageFormat(msg, l).format(TM.this.replaceMap(args, msg).getAll());
                    }
                };
            }
        };
        Tuple2 createInstances = localizedInstances.createInstances(this.getBaseName(), locale);
        this.translationsLocale = createInstances.get0();
        this.translations = new TranslatorChain(createInstances.get1());
    }

    protected final String getBaseName() {
        return I18nUtils.getBaseName(this.getClass());
    }

    public final String translate(String key, Object ... args) {
        return this.translate(true, key, args);
    }

    public final String translate(boolean lenient, String key, Object ... args) throws MissingResourceException {
        return this.translate(lenient, key, new MessageArgs(args));
    }

    private final String translate(boolean lenient, String key, MessageArgs args) throws MissingResourceException {
        String res = this.translations.translate(key, args);
        if (res == null) {
            if (lenient) {
                return String.valueOf('!') + key + '!';
            }
            throw new MissingResourceException("Missing translation", this.getBaseName(), key);
        }
        return res;
    }

    protected MessageArgs replaceMap(MessageArgs args, String msg) {
        MessageArgs res;
        if (args.getAll() instanceof Map) {
            Map<String, ?> map = args.getMap();
            Map<String, Object> newMap = MessageArgs.isOrdered(map) ? new LinkedHashMap(map) : new HashMap(map);
            if (TM.useDynamicMap()) {
                newMap = new DynamicMap<Object>(newMap){

                    @Override
                    protected Object createValueNonNull(String key) {
                        return TM.this.createValue(this, key);
                    }
                };
            } else {
                MessagePattern messagePattern = new MessagePattern(msg);
                if (messagePattern.hasNamedArguments()) {
                    int countParts = messagePattern.countParts();
                    int i = 0;
                    while (i < countParts) {
                        Object createValue;
                        String argName;
                        MessagePattern.Part part = messagePattern.getPart(i);
                        if (part.getType() == MessagePattern.Part.Type.ARG_NAME && !newMap.containsKey(argName = messagePattern.getSubstring(part)) && (createValue = this.createValue(newMap, argName)) != null) {
                            newMap.put(argName, createValue);
                        }
                        ++i;
                    }
                }
            }
            res = new MessageArgs(newMap);
        } else {
            res = args;
        }
        return res;
    }

    protected Object createValue(Map<String, Object> map, String key) {
        Phrase phrase;
        Matcher m = splitPtrn.matcher(key);
        String pattern = splitPtrn.pattern();
        int patternL = pattern.length();
        StringBuffer sb = new StringBuffer(key.length());
        ArrayList<String> l = new ArrayList<String>();
        int pos = 0;
        while (m.find(pos)) {
            if (key.length() >= m.end() + patternL && pattern.equals(key.substring(m.end(), m.end() + patternL))) {
                sb.append(key.substring(pos, m.end()));
                pos = m.end() + patternL;
                continue;
            }
            sb.append(key.substring(pos, m.start()));
            l.add(sb.toString());
            sb.setLength(0);
            pos = m.end();
        }
        sb.append(key.substring(pos));
        l.add(sb.toString());
        String first = (String)CollectionUtils.getFirst(l);
        assert (first != null);
        Object firstObj = this.handleGet(map, first);
        Phrase phrase2 = phrase = firstObj instanceof Phrase ? (Phrase)firstObj : null;
        if (phrase != null && phrase.getGrammar() != null) {
            Object countObj = this.handleGet(map, String.valueOf(first) + "Count");
            if (!(countObj instanceof Number)) {
                countObj = this.handleGet(map, "count");
            }
            Number count = countObj instanceof Number ? (Number)((Number)countObj) : (Number)null;
            return phrase.getGrammar().eval(phrase, count, l.subList(1, l.size()));
        }
        if (phrase != null) {
            Log.get().warning("While splitting " + key + ", " + first + " is a Phrase without grammar : " + phrase);
            return phrase.getBase();
        }
        Log.get().warning("While splitting " + key + " : " + first + " isn't a Phrase");
        return null;
    }

    private final Object handleGet(Map<String, Object> map, String key) {
        if (map instanceof DynamicMap) {
            return ((DynamicMap)map).handleGet(key);
        }
        return map.get(key);
    }
}

