/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

public abstract class Value<V> {
    private static final Value NONE = new Value(false){

        public Object getValue() {
            throw new IllegalStateException();
        }
    };
    private final boolean hasValue;

    public static <V> Value<V> getNone() {
        return NONE;
    }

    public static <V> Value<V> getSome(V value) {
        return new Some<V>(value);
    }

    public static <V> Value<V> fromNonNull(V value) {
        return value == null ? Value.getNone() : Value.getSome(value);
    }

    private Value(boolean hasValue) {
        this.hasValue = hasValue;
    }

    public final boolean hasValue() {
        return this.hasValue;
    }

    public abstract V getValue();

    /* synthetic */ Value(boolean bl, Value value) {
        this(bl);
    }

    private static final class Some<V>
    extends Value<V> {
        private final V val;

        public Some(V val) {
            super(true, null);
            this.val = val;
        }

        @Override
        public V getValue() {
            return this.val;
        }
    }
}

