/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.config;

import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Properties;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.ProductInfo;

public abstract class ComptaBasePropsConfiguration
extends PropsConfiguration {
    private int idSociete = -1;
    private SQLRow rowSociete = null;
    private Thread sslThread = null;

    public static File getConfFile(String appName) {
        return ComptaBasePropsConfiguration.getConfFile(appName, new File("."));
    }

    public static File getConfFile(String appName, File wd) {
        String confFilePath = System.getProperty("gestion.confFile");
        File wdFile = new File(wd + "/Configuration", "main.properties");
        File confFile = confFilePath != null ? new File(confFilePath) : (wdFile.isFile() ? wdFile : new File(DesktopEnvironment.getDE().getPreferencesFolder(appName), "main.properties"));
        return confFile;
    }

    public ComptaBasePropsConfiguration(Properties props, ProductInfo productInfo) {
        super(props);
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        this.setLoggersLevel();
        this.setProductInfo(productInfo);
        String name = "ilm";
        this.setProperty("systemRoot.rootsToMap", String.valueOf(name) + "_Common");
        this.setProperty("systemRoot.rootPath", String.valueOf(name) + "_Common");
    }

    @Override
    protected void afterSSLConnect(final Session conn) {
        if (conn.isConnected()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        do {
                            Thread.sleep(1000L);
                        } while (conn.isConnected());
                        ExceptionHandler.die("Liaison s\u00e9curis\u00e9e d\u00e9connect\u00e9e!\nV\u00e9rifiez votre connexion internet et relancez le logiciel.");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t.setDaemon(true);
            t.setName("SSL connection watcher");
            t.start();
            assert (this.sslThread == null);
            this.sslThread = t;
        } else {
            ExceptionHandler.die("Impossible d'\u00e9tablir la liaison s\u00e9curis\u00e9e!\nV\u00e9rifiez votre connexion internet et relancez le logiciel.");
        }
    }

    @Override
    public void destroy() {
        if (this.sslThread != null) {
            this.sslThread.interrupt();
            this.sslThread = null;
        }
        super.destroy();
    }

    @Override
    protected PropsConfiguration.FileMode getFileMode() {
        return PropsConfiguration.FileMode.NORMAL_FILE;
    }
}

