/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.List;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;

public class SQLCreateTable
extends SQLCreateTableBase<SQLCreateTable> {
    private final DBRoot b;
    private boolean plain;

    public SQLCreateTable(DBRoot b, String name) {
        super(b.getServer().getSQLSystem().getSyntax(), b.getName(), name);
        this.b = b;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.plain = false;
    }

    public final DBRoot getRoot() {
        return this.b;
    }

    public final void setPlain(boolean b) {
        this.plain = b;
    }

    public SQLCreateTable addForeignColumn(String foreignTable) {
        return this.addForeignColumn(foreignTable, "");
    }

    public SQLCreateTable addForeignColumn(String foreignTableN, String suffix) {
        String fk = "ID_" + foreignTableN + (suffix.length() == 0 ? "" : "_" + suffix);
        SQLTable foreignTable = this.b.getTable(foreignTableN);
        if (foreignTable == null) {
            throw new IllegalArgumentException("Unknown table in " + this.b + " : " + foreignTableN);
        }
        return (SQLCreateTable)this.addForeignColumn(fk, foreignTable, true);
    }

    @Override
    protected void checkPK() {
        if (!this.plain) {
            throw new IllegalStateException("can only set primary key in plain mode, otherwise it is automatically added");
        }
    }

    @Override
    protected void modifyClauses(List<String> genClauses) {
        if (!this.plain) {
            genClauses.add(0, String.valueOf(SQLBase.quoteIdentifier("ID")) + this.getSyntax().getPrimaryIDDefinition());
            genClauses.add(String.valueOf(SQLBase.quoteIdentifier("ARCHIVE")) + this.getSyntax().getArchiveDefinition());
            if (this.getSyntax().getSystem() == SQLSystem.MSSQL) {
                genClauses.add(String.valueOf(SQLBase.quoteIdentifier("ORDRE")) + this.getSyntax().getOrderType() + " DEFAULT " + this.getSyntax().getOrderDefault());
            } else {
                genClauses.add(String.valueOf(SQLBase.quoteIdentifier("ORDRE")) + this.getSyntax().getOrderDefinition());
            }
        }
    }

    @Override
    protected void modifyOutClauses(List<ChangeTable.DeferredClause> clauses) {
        super.modifyOutClauses(clauses);
        if (!this.plain && this.getSyntax().getSystem() == SQLSystem.MSSQL) {
            clauses.add(new ChangeTable.OutsideClause(){

                @Override
                public ChangeTable.ClauseType getType() {
                    return ChangeTable.ClauseType.ADD_INDEX;
                }

                @Override
                public String asString(SQLName tableName) {
                    return "create unique index idx on " + tableName.quote() + "(" + SQLBase.quoteIdentifier("ORDRE") + ") where " + SQLBase.quoteIdentifier("ORDRE") + " is not null";
                }
            });
        }
    }
}

