/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public final class AlterTable
extends ChangeTable<AlterTable> {
    private final SQLTable t;

    public AlterTable(SQLTable t) {
        super(t.getServer().getSQLSystem().getSyntax(), t.getDBRoot().getName(), t.getName());
        this.t = t;
    }

    AlterTable(SQLSyntax s, String rootName, String tableName) {
        super(s, rootName, tableName);
        this.t = null;
    }

    @Override
    protected String getConstraintPrefix() {
        return "ADD ";
    }

    @Override
    public final AlterTable addColumn(String name, String definition) {
        return (AlterTable)this.addClause("ADD " + SQLBase.quoteIdentifier(name) + " " + definition, ChangeTable.ClauseType.ADD_COL);
    }

    public final AlterTable dropColumn(String name) {
        return (AlterTable)this.addClause("DROP COLUMN " + SQLBase.quoteIdentifier(name), ChangeTable.ClauseType.DROP_COL);
    }

    public final AlterTable alterColumn(String fname, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        for (String s : this.getSyntax().getAlterField(this.t.getField(fname), toAlter, type, defaultVal, nullable)) {
            this.addClause(s, ChangeTable.ClauseType.ALTER_COL);
        }
        return (AlterTable)this.thisAsT();
    }

    public final AlterTable alterColumnDefault(String f, String defaultVal) {
        return this.alterColumn(f, EnumSet.of(SQLField.Properties.DEFAULT), null, defaultVal, null);
    }

    @Override
    protected String asString(ChangeTable.NameTransformer transf, ChangeTable.ConcatStep step) {
        return this.asString(transf, step.getTypes());
    }

    @Override
    public String asString(ChangeTable.NameTransformer transf) {
        return this.asString(transf, ChangeTable.ORDERED_TYPES);
    }

    private final String asString(ChangeTable.NameTransformer transf, Set<ChangeTable.ClauseType> types) {
        SQLName tableName = transf.transformTableName(new SQLName(this.getRootName(), this.getName()));
        ArrayList<String> genClauses = new ArrayList<String>(this.getClauses(tableName, types));
        this.modifyClauses(genClauses);
        if (types.contains((Object)ChangeTable.ClauseType.ADD_CONSTRAINT)) {
            genClauses.addAll(this.getForeignConstraints(transf));
        }
        StringBuffer res = new StringBuffer(512);
        final String alterTable = "ALTER TABLE " + tableName.quote();
        if (this.getSyntax().supportMultiAlterClause() && genClauses.size() > 0) {
            res.append(String.valueOf(alterTable) + " \n");
            res.append(CollectionUtils.join(genClauses, ",\n"));
            res.append(";");
        } else {
            res.append(CollectionUtils.join(genClauses, "\n", new ITransformer<String, String>(){

                public String transformChecked(String input) {
                    return String.valueOf(alterTable) + " " + input + ";";
                }
            }));
        }
        this.outClausesAsString(res, tableName, types);
        return res.toString();
    }

    protected void modifyClauses(List<String> genClauses) {
    }
}

