/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.Tuple3;

public class UpdateBuilder {
    private final SQLTable t;
    private final Map<String, String> fields;
    private final List<String> tables;
    private Where where;
    private final Map<String, Tuple3.List3<String>> virtualJoins;
    private final Map<String, Boolean> virtualJoinsOptimized;

    public UpdateBuilder(SQLTable t) {
        this.t = t;
        this.fields = new LinkedHashMap<String, String>();
        this.tables = new ArrayList<String>();
        this.virtualJoins = new HashMap<String, Tuple3.List3<String>>(4);
        this.virtualJoinsOptimized = new HashMap<String, Boolean>(4);
    }

    public final SQLTable getTable() {
        return this.t;
    }

    private final void checkField(String field) {
        if (!this.getTable().contains(field)) {
            throw new IllegalArgumentException("unknown " + field + " in " + this.getTable().getSQLName());
        }
    }

    public final UpdateBuilder set(String field, String value) {
        this.checkField(field);
        this.fields.put(field, value);
        return this;
    }

    private final boolean isJoinVirtual(String alias) {
        if (!this.virtualJoins.containsKey(alias)) {
            throw new IllegalArgumentException("Not a join " + alias);
        }
        return this.getTable().getServer().getSQLSystem() == SQLSystem.H2 || this.virtualJoinsOptimized.get(alias) == Boolean.FALSE;
    }

    private final String getWhere(String joinAlias, Tuple3.List3<String> virtualJoin) {
        assert (this.virtualJoins.get(joinAlias) == virtualJoin);
        SQLName joinedTableFieldName = new SQLName(joinAlias, (String)virtualJoin.get2());
        return this.getTable().getField((String)virtualJoin.get1()).getSQLNameUntilDBRoot(false) + " = " + joinedTableFieldName.quote();
    }

    public final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public final void setWhere(Where where) {
        this.where = where;
    }

    public final void addTable(TableRef t) {
        this.tables.add(t.getSQL());
    }

    public final void addRawTable(String definition, String rawAlias) {
        this.tables.add(String.valueOf(definition) + (rawAlias == null ? "" : " " + rawAlias));
    }

    public final String asString() {
        Where computedWhere = this.where;
        ArrayList<String> computedTables = new ArrayList<String>(this.tables);
        for (Map.Entry<String, Tuple3.List3<String>> e : this.virtualJoins.entrySet()) {
            Where w;
            String joinAlias = e.getKey();
            Tuple3.List3<String> virtualJoin = e.getValue();
            if (this.isJoinVirtual(joinAlias)) {
                w = Where.createRaw(String.valueOf(SQLBase.quoteIdentifier((String)virtualJoin.get1())) + " in ( select " + SQLBase.quoteIdentifier((String)virtualJoin.get2()) + " from " + (String)virtualJoin.get0() + " )", new FieldRef[0]);
            } else {
                w = Where.createRaw(this.getWhere(joinAlias, virtualJoin), new FieldRef[0]);
                computedTables.add((String)virtualJoin.get0());
            }
            computedWhere = w.and(computedWhere);
        }
        String w = computedWhere == null ? "" : "\nWHERE " + computedWhere.getClause();
        return "UPDATE " + this.getTable().getServer().getSQLSystem().getSyntax().getUpdate(this.getTable(), Collections.unmodifiableList(computedTables), Collections.unmodifiableMap(this.fields)) + w;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.asString();
    }
}

