/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.request.SQLCacheWatcher;
import org.openconcerto.utils.cache.CacheWatcherFactory;
import org.openconcerto.utils.cache.ICache;

public final class SQLCache<K, V>
extends ICache<K, V, SQLData> {
    private final boolean clearAfterTx;

    public SQLCache() {
        this(60);
    }

    public SQLCache(int delay) {
        this(delay, -1);
    }

    public SQLCache(int delay, int size) {
        this(delay, size, null);
    }

    public SQLCache(int delay, int size, String name) {
        this(delay, size, name, true);
    }

    public SQLCache(int delay, int size, String name, boolean clearAfterTx) {
        super(delay, size, name);
        this.clearAfterTx = clearAfterTx;
        this.setWatcherFactory(new CacheWatcherFactory<K, SQLData>(){

            public SQLCacheWatcher<K> createWatcher(ICache<K, ?, SQLData> cache, SQLData o) {
                SQLCache c = (SQLCache)cache;
                return new SQLCacheWatcher(c, o);
            }
        });
    }

    public final boolean isClearedAfterTransaction() {
        return this.clearAfterTx;
    }
}

