/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.jdom.Element;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.TransactionListener;
import org.openconcerto.sql.model.TransactionPoint;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.CopyOnWriteMap;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.xml.JDOMUtils;

public final class SQLTable
extends SQLIdentifier
implements SQLData,
TableRef {
    private static final Map<SQLSchema, Map<String, Number>> UNDEFINED_IDs = new HashMap<SQLSchema, Map<String, Number>>();
    private static boolean AFTER_TX_DEFAULT = true;
    private String version;
    private final CopyOnWriteMap<String, SQLField> fields;
    private final Set<SQLField> primaryKeys;
    private SQLField primaryKey;
    private boolean primaryKeyOK;
    private Set<SQLField> keys;
    private final Map<String, Trigger> triggers;
    private Set<Constraint> constraints;
    private List<ListenerAndConfig> tableModifiedListeners;
    private final ListMap<TransactionPoint, FireState> transactions;
    private final TransactionListener txListener;
    private final Object listenersMutex = new String("tableModifiedListeners mutex");
    private Integer undefinedID;
    private String comment;
    private String type;
    private static final ThreadLocal<LinkedList<DispatchingState>> events = new ThreadLocal<LinkedList<DispatchingState>>(){

        @Override
        protected LinkedList<DispatchingState> initialValue() {
            return new LinkedList<DispatchingState>();
        }
    };

    private static final Map<String, Number> getUndefIDs(final SQLSchema schema) {
        if (!UNDEFINED_IDs.containsKey(schema)) {
            Map r;
            if (schema.contains("FWK_UNDEFINED_IDS")) {
                SQLBase b = schema.getBase();
                final SQLTable undefT = schema.getTable("FWK_UNDEFINED_IDS");
                SQLSelect sel = new SQLSelect(b).addSelectStar(undefT);
                r = (Map)b.getDataSource().execute(sel.asString(), new ResultSetHandler(){

                    @Override
                    public Object handle(ResultSet rs) throws SQLException {
                        HashMap<String, Number> res = new HashMap<String, Number>();
                        while (rs.next()) {
                            res.put(rs.getString("TABLENAME"), (Number)rs.getObject("UNDEFINED_ID"));
                        }
                        return res;
                    }
                });
                undefT.addTableModifiedListener(new ListenerAndConfig(new SQLTableModifiedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        Map map = UNDEFINED_IDs;
                        synchronized (map) {
                            UNDEFINED_IDs.remove(schema);
                            undefT.removeTableModifiedListener(this);
                        }
                    }
                }, false));
            } else {
                r = Collections.emptyMap();
            }
            UNDEFINED_IDs.put(schema, r);
        }
        return UNDEFINED_IDs.get(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Tuple2<Boolean, Number> getUndefID(SQLSchema b, String tableName) {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            Map<String, Number> map2 = SQLTable.getUndefIDs(b);
            return Tuple2.create(map2.containsKey(tableName), map2.get(tableName));
        }
    }

    private static final SQLCreateMoveableTable getCreateUndefTable(SQLSyntax syntax) {
        SQLCreateMoveableTable createTable = new SQLCreateMoveableTable(syntax, "FWK_UNDEFINED_IDS");
        createTable.addVarCharColumn("TABLENAME", 250);
        createTable.addColumn("UNDEFINED_ID", syntax.getIDType());
        createTable.setPrimaryKey("TABLENAME");
        return createTable;
    }

    private static final SQLTable getUndefTable(SQLSchema schema, boolean create) throws SQLException {
        SQLTable undefT = schema.getTable("FWK_UNDEFINED_IDS");
        if (undefT != null || !create) {
            return undefT;
        }
        schema.getDBSystemRoot().getDataSource().execute(SQLTable.getCreateUndefTable(SQLSyntax.get(schema)).asString(schema.getDBRoot().getName()));
        schema.updateVersion();
        return schema.fetchTable("FWK_UNDEFINED_IDS");
    }

    public static final void setUndefID(SQLSchema schema, String tableName, Integer value) throws SQLException {
        SQLTable.setUndefIDs(schema, Collections.singletonMap(tableName, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int setUndefIDs(SQLSchema schema, Map<String, ? extends Number> values) throws SQLException {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            int res;
            SQLTable undefT = SQLTable.getUndefTable(schema, true);
            SQLType undefType = undefT.getField("UNDEFINED_ID").getType();
            ArrayList<List<String>> toInsert = new ArrayList<List<String>>();
            ArrayList<List<String>> toUpdate = new ArrayList<List<String>>();
            Map<String, Number> currentValues = SQLTable.getUndefIDs(schema);
            SQLBase b = schema.getBase();
            SQLSystem system = b.getServer().getSQLSystem();
            for (Map.Entry<String, ? extends Number> e : values.entrySet()) {
                String string = e.getKey();
                Number undefValue = e.getValue();
                Object l = !currentValues.containsKey(string) ? toInsert : (CompareUtils.equals(currentValues.get(string), undefValue) ? null : toUpdate);
                if (l == null) continue;
                String undefSQL = undefValue == null && system == SQLSystem.POSTGRESQL ? "cast( NULL as " + undefType.getTypeName() + ")" : undefType.toString(undefValue);
                l.add(Arrays.asList(b.quoteString(string), undefSQL));
            }
            SQLSyntax syntax = system.getSyntax();
            if (toInsert.size() > 0) {
                SQLRowValues.insertCount(undefT, "(\"TABLENAME\", \"UNDEFINED_ID\") " + syntax.getValues(toInsert, 2));
            }
            if (toUpdate.size() > 0) {
                if (system == SQLSystem.H2) {
                    StringBuilder updates = new StringBuilder();
                    for (List list : toUpdate) {
                        UpdateBuilder update = new UpdateBuilder(undefT).set("UNDEFINED_ID", (String)list.get(1));
                        update.setWhere(Where.createRaw(String.valueOf(undefT.getField("TABLENAME").getFieldRef()) + " = " + (String)list.get(0), new FieldRef[0]));
                        updates.append(update.asString());
                        updates.append(";\n");
                    }
                    schema.getDBSystemRoot().getDataSource().execute(updates.toString());
                } else {
                    UpdateBuilder update = new UpdateBuilder(undefT);
                    String string = "newUndef";
                    update.addRawTable(syntax.getConstantTable(toUpdate, "newUndef", Arrays.asList("t", "v")), null);
                    update.setWhere(Where.createRaw(String.valueOf(undefT.getField("TABLENAME").getFieldRef()) + " = " + new SQLName("newUndef", "t").quote(), new FieldRef[0]));
                    update.set("UNDEFINED_ID", new SQLName("newUndef", "v").quote());
                    schema.getDBSystemRoot().getDataSource().execute(update.asString());
                }
            }
            if ((res = toInsert.size() + toUpdate.size()) > 0) {
                undefT.fireTableModified(-1);
            }
            return res;
        }
    }

    SQLTable(SQLSchema schema, String name) {
        super(schema, name);
        this.tableModifiedListeners = Collections.emptyList();
        this.transactions = new ListMap();
        this.txListener = new TransactionListener(){

            @Override
            public void transactionEnded(TransactionPoint point) {
                SQLTable.this.fireFromTransaction(point, point.getCommitted());
            }
        };
        this.fields = new CopyOnWriteMap<String, SQLField>(){

            @Override
            public Map<String, SQLField> copy(Map<? extends String, ? extends SQLField> src) {
                return new LinkedHashMap<String, SQLField>(src);
            }
        };
        assert (SQLTable.isOrdered(this.fields));
        this.primaryKeys = new LinkedHashSet<SQLField>();
        this.primaryKey = null;
        this.primaryKeyOK = true;
        this.keys = null;
        this.triggers = new HashMap<String, Trigger>();
        this.constraints = new HashSet<Constraint>();
        this.undefinedID = null;
        assert (!this.undefinedIDKnown());
    }

    synchronized void clearNonPersistent() {
        this.triggers.clear();
        this.constraints = new HashSet<Constraint>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFields(Element xml) {
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            this.version = SQLSchema.getVersion(xml);
        }
        LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
        for (Element elementField : xml.getChildren("field")) {
            SQLField f = SQLField.create(this, elementField);
            newFields.put(f.getName(), f);
        }
        Element primary = xml.getChild("primary");
        ArrayList<String> newPrimaryKeys = new ArrayList<String>();
        for (Element elementField : primary.getChildren("field")) {
            String fieldName = elementField.getAttributeValue("name");
            newPrimaryKeys.add(fieldName);
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable2 = this;
            synchronized (sQLTable2) {
                Element constraintsElem;
                this.setState(newFields, newPrimaryKeys, null);
                Element triggersElem = xml.getChild("triggers");
                if (triggersElem != null) {
                    for (Element triggerElem : triggersElem.getChildren()) {
                        this.addTrigger(Trigger.fromXML(this, triggerElem));
                    }
                }
                if ((constraintsElem = xml.getChild("constraints")) == null) {
                    this.addConstraint((Constraint)null);
                } else {
                    for (Element elem : constraintsElem.getChildren()) {
                        this.addConstraint(Constraint.fromXML(this, elem));
                    }
                }
                Element commentElem = xml.getChild("comment");
                if (commentElem != null) {
                    this.setComment(commentElem.getText());
                }
                this.setType(xml.getAttributeValue("type"));
            }
        }
    }

    private synchronized void addTrigger(Trigger t) {
        this.triggers.put(t.getName(), t);
    }

    private synchronized void addConstraint(Constraint c) {
        if (c == null) {
            this.constraints = null;
        } else {
            if (this.constraints == null) {
                this.constraints = new HashSet<Constraint>();
            }
            this.constraints.add(c);
        }
    }

    public void fetchFields() throws SQLException {
        this.getBase().fetchTables(TablesMap.createBySchemaFromTable(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fetchFields(DatabaseMetaData metaData, ResultSet rs, String version) throws SQLException {
        if (!this.isUs(rs)) {
            throw new IllegalStateException("rs current row does not describe " + this);
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                this.version = version;
                LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
                boolean hasNext = true;
                while (hasNext && this.isUs(rs)) {
                    SQLField f = SQLField.create(this, rs);
                    newFields.put(f.getName(), f);
                    hasNext = rs.next();
                }
                ArrayList<String> newPrimaryKeys = new ArrayList<String>();
                ResultSet pkRS = metaData.getPrimaryKeys(this.getBase().getMDName(), this.getSchema().getName(), this.getName());
                while (pkRS.next()) {
                    newPrimaryKeys.add(pkRS.getString("COLUMN_NAME"));
                }
                this.setState(newFields, newPrimaryKeys, null);
                return hasNext;
            }
        }
    }

    void emptyFields() {
        this.setState(new LinkedHashMap<String, SQLField>(), Collections.<String>emptyList(), null);
    }

    private boolean isUs(ResultSet rs) throws SQLException {
        String n = rs.getString("TABLE_NAME");
        String s = rs.getString("TABLE_SCHEM");
        return n.equals(this.getName()) && CompareUtils.equals(s, this.getSchema().getName());
    }

    void addTrigger(Map m) {
        this.addTrigger(new Trigger(this, m));
    }

    void addConstraint(Map<String, Object> m) {
        this.addConstraint(m == null ? null : new Constraint(this, m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fetchUndefID() {
        Number id;
        Tuple2<Boolean, Number> currentValue;
        SQLField pk;
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            pk = this.isRowable() ? this.getKey() : null;
        }
        int res = pk != null ? (!(currentValue = SQLTable.getUndefID(this.getSchema(), this.getName())).get0().booleanValue() ? this.findMinID(pk) : ((id = currentValue.get1()) == null ? -1 : id.intValue())) : -1;
        return res;
    }

    private int findMinID(SQLField pk) {
        String debugUndef = "fwk_sql.debug.undefined_id";
        if (System.getProperty("fwk_sql.debug.undefined_id") != null) {
            Log.get().warning("The system property 'fwk_sql.debug.undefined_id' is deprecated, use the 'undefined ID policy' metadata");
        }
        String policy = this.getSchema().getFwkMetadata("undefined ID policy");
        if (Boolean.getBoolean("fwk_sql.debug.undefined_id") || "min".equals(policy)) {
            SQLSelect sel = new SQLSelect(this.getBase(), true).addSelect(pk, "min");
            Number undef = (Number)this.getBase().getDataSource().executeScalar(sel.asString());
            if (undef == null) {
                throw new IllegalStateException(this + " is empty, can not infer UNDEFINED_ID");
            }
            String update = "INSERT into " + new SQLName(this.getDBRoot().getName(), "FWK_UNDEFINED_IDS") + " VALUES('" + this.getName() + "', " + undef + ");";
            Log.get().config("the first row (which should be the undefined):\n" + update);
            return undef.intValue();
        }
        if ("inDB".equals(policy)) {
            throw new IllegalStateException("Not in " + new SQLName(this.getDBRoot().getName(), "FWK_UNDEFINED_IDS") + " : " + this.getName());
        }
        if (policy != null && !"nonexistant".equals(policy)) {
            int res = Integer.parseInt(policy);
            if (res < 0) {
                throw new IllegalStateException("ID is not valid : " + res);
            }
            return res;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mutateTo(SQLTable table) {
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                this.clearNonPersistent();
                this.version = table.version;
                this.setState(table.fields, table.getPKsNames(), table.undefinedID);
                this.triggers.putAll(table.triggers);
                if (table.constraints == null) {
                    this.constraints = null;
                } else {
                    this.constraints.addAll(table.constraints);
                }
                this.setType(table.getType());
                this.setComment(table.getComment());
            }
        }
    }

    private static <K, V> boolean isOrdered(Map<K, V> m) {
        if (m instanceof CopyOnWriteMap) {
            return SQLTable.isOrdered(((CopyOnWriteMap)m).copy(Collections.emptyMap()));
        }
        return m instanceof LinkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setState(Map<String, SQLField> fields, List<String> primaryKeys, Integer undef) {
        assert (SQLTable.isOrdered(fields));
        for (SQLField newField : fields.values()) {
            if (newField.getTable().getSQLName().equals(this.getSQLName())) continue;
            throw new IllegalArgumentException(newField + " is in table " + newField.getTable().getSQLName() + " not us: " + this.getSQLName());
        }
        Object object = this.getTreeMutex();
        synchronized (object) {
            SQLTable sQLTable = this;
            synchronized (sQLTable) {
                CollectionChangeEventCreator c = this.createChildrenCreator();
                if (!fields.keySet().containsAll(this.getFieldsName())) {
                    for (String removed : CollectionUtils.substract(this.getFieldsName(), fields.keySet())) {
                        this.fields.remove(removed).dropped();
                    }
                }
                for (SQLField newField : fields.values()) {
                    if (this.getChildrenNames().contains(newField.getName())) {
                        this.getField(newField.getName()).mutateTo(newField);
                        continue;
                    }
                    SQLField fieldToAdd = newField.getTable() != this ? new SQLField(this, newField) : newField;
                    this.fields.put(newField.getName(), fieldToAdd);
                }
                this.primaryKeys.clear();
                for (String pk : primaryKeys) {
                    this.primaryKeys.add(this.getField(pk));
                }
                this.primaryKey = primaryKeys.size() == 1 ? this.getField(primaryKeys.get(0)) : null;
                this.primaryKeyOK = primaryKeys.size() <= 1;
                this.undefinedID = undef;
                this.fireChildrenChanged(c);
            }
        }
    }

    synchronized void setType(String type) {
        this.type = type;
    }

    public final synchronized String getType() {
        return this.type;
    }

    synchronized void setComment(String comm) {
        this.comment = comm;
    }

    public final synchronized String getComment() {
        return this.comment;
    }

    public final synchronized Constraint getConstraint(SQLSyntax.ConstraintType type, List<String> cols) {
        if (this.constraints == null) {
            return null;
        }
        for (Constraint c : this.constraints) {
            if (c.getType() != type || !c.getCols().equals(cols)) continue;
            return c;
        }
        return null;
    }

    public synchronized boolean isRowable() {
        return this.getPrimaryKeys().size() == 1 && Number.class.isAssignableFrom(this.getKey().getType().getJavaType());
    }

    public SQLSchema getSchema() {
        return (SQLSchema)this.getParent();
    }

    public SQLBase getBase() {
        return this.getSchema().getBase();
    }

    @Override
    public synchronized SQLField getKey() {
        if (!this.primaryKeyOK) {
            throw new IllegalStateException(this + " has more than 1 primary key: " + this.getPrimaryKeys());
        }
        return this.primaryKey;
    }

    public synchronized Set<SQLField> getPrimaryKeys() {
        return Collections.unmodifiableSet(this.primaryKeys);
    }

    public Set<SQLField> getForeignKeys() {
        return this.getDBSystemRoot().getGraph().getForeignKeys(this);
    }

    public Set<String> getForeignKeysNames() {
        return DatabaseGraph.getNames(this.getDBSystemRoot().getGraph().getForeignLinks(this));
    }

    public Set<SQLField> getForeignKeys(SQLTable foreignTable) {
        return this.getDBSystemRoot().getGraph().getForeignFields(this, foreignTable);
    }

    public String toString() {
        return "/" + this.getName() + "/";
    }

    @Override
    public SQLField getField(String fieldName) {
        SQLField res = this.getFieldRaw(fieldName);
        if (res == null) {
            throw new IllegalArgumentException("unknown field " + fieldName + " in " + this.getName() + ". The table " + this.getName() + " contains the followins fields: " + this.getFieldsName());
        }
        return res;
    }

    public SQLField getFieldRaw(String fieldName) {
        return this.fields.get(fieldName);
    }

    public Set<SQLField> getFields() {
        return new HashSet<SQLField>(this.fields.values());
    }

    public Set<SQLField> getContentFields() {
        return this.getContentFields(false);
    }

    public synchronized Set<SQLField> getContentFields(boolean includeMetadata) {
        Set<SQLField> res = this.getFields();
        res.removeAll(this.getPrimaryKeys());
        res.remove(this.getArchiveField());
        res.remove(this.getOrderField());
        if (!includeMetadata) {
            res.remove(this.getCreationDateField());
            res.remove(this.getCreationUserField());
            res.remove(this.getModifDateField());
            res.remove(this.getModifUserField());
        }
        return res;
    }

    public Set<String> getFieldsName() {
        return this.fields.keySet();
    }

    public List<SQLField> getOrderedFields() {
        return new ArrayList<SQLField>(this.fields.values());
    }

    @Override
    public Map<String, SQLField> getChildrenMap() {
        return this.fields.getImmutable();
    }

    public final SQLTable getTable(String name) {
        return this.getDesc(name, SQLTable.class);
    }

    public int getRowCount() {
        return this.getRowCount(true);
    }

    public int getRowCount(boolean includeUndefined) {
        SQLSelect sel = new SQLSelect(true).addSelectFunctionStar("count").addFrom(this);
        sel.setExcludeUndefined(!includeUndefined);
        Number count = (Number)this.getBase().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false));
        return count.intValue();
    }

    public SQLRow getRow(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.exists() ? row : null;
    }

    private SQLRow getUncheckedRow(int ID) {
        return new SQLRow(this, ID);
    }

    public SQLRow getValidRow(int ID) {
        SQLRow row = this.getRow(ID);
        return row.isValid() ? row : null;
    }

    public SQLRow checkValidity(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.isValid() ? null : row;
    }

    public SQLRow checkValidity(String foreignKey, int foreignID) {
        SQLField fk = this.getField(foreignKey);
        SQLTable foreignTable = this.getDBSystemRoot().getGraph().getForeignTable(fk);
        if (foreignTable == null) {
            throw new IllegalArgumentException("Impossible de tester '" + foreignKey + "' avec " + foreignID + " dans " + this + ". Ce n'est pas une clef \u00e9trang\u00e8re.");
        }
        return foreignTable.checkValidity(foreignID);
    }

    public SQLRow checkValidity(String foreignKey, Number foreignID) {
        if (foreignID == null) {
            return null;
        }
        return this.checkValidity(foreignKey, foreignID.intValue());
    }

    public boolean isOrdered() {
        return this.getOrderField() != null;
    }

    public SQLField getOrderField() {
        return this.getFieldRaw("ORDRE");
    }

    public final int getOrderDecimalDigits() {
        return this.getOrderField().getType().getDecimalDigits();
    }

    public final BigDecimal getOrderULP() {
        return BigDecimal.ONE.scaleByPowerOfTen(-this.getOrderDecimalDigits());
    }

    public boolean isArchivable() {
        return this.getArchiveField() != null;
    }

    public SQLField getArchiveField() {
        return this.getFieldRaw("ARCHIVE");
    }

    public SQLField getCreationDateField() {
        return this.getFieldRaw("CREATION_DATE");
    }

    public SQLField getCreationUserField() {
        return this.getFieldRaw("ID_USER_COMMON_CREATE");
    }

    public SQLField getModifDateField() {
        return this.getFieldRaw("MODIFICATION_DATE");
    }

    public SQLField getModifUserField() {
        return this.getFieldRaw("ID_USER_COMMON_MODIFY");
    }

    public final int getUndefinedID() {
        return this.getUndefinedID(false);
    }

    final synchronized boolean undefinedIDKnown() {
        return this.undefinedID != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Integer getUndefinedID(boolean internal) {
        Integer res = null;
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            if (this.undefinedID != null) {
                res = this.undefinedID;
            }
        }
        if (res == null) {
            if (!internal && this.getSchema().isFetchAllUndefinedIDs()) {
                for (SQLTable sibling : this.getSchema().getTables()) {
                    Integer siblingRes = sibling.getUndefinedID(true);
                    assert (siblingRes != null);
                    if (sibling != this) continue;
                    res = siblingRes;
                }
            } else {
                res = this.fetchUndefID();
                sQLTable = this;
                synchronized (sQLTable) {
                    this.undefinedID = res;
                }
            }
        }
        assert (this.undefinedIDKnown());
        return res;
    }

    public final Number getUndefinedIDNumber() {
        int res = this.getUndefinedID();
        if (res == -1) {
            return null;
        }
        return res;
    }

    public void addTableModifiedListener(SQLTableModifiedListener l) {
        this.addTableModifiedListener(new ListenerAndConfig(l, AFTER_TX_DEFAULT));
    }

    public void addTableModifiedListener(ListenerAndConfig l) {
        this.addTableModifiedListener(l, false);
    }

    public void addPremierTableModifiedListener(ListenerAndConfig l) {
        this.addTableModifiedListener(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTableModifiedListener(ListenerAndConfig l, boolean before) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<ListenerAndConfig> newListeners = new ArrayList<ListenerAndConfig>(this.tableModifiedListeners.size() + 1);
            if (before) {
                newListeners.add(l);
            }
            newListeners.addAll(this.tableModifiedListeners);
            if (!before) {
                newListeners.add(l);
            }
            this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
        }
    }

    public void removeTableModifiedListener(SQLTableModifiedListener l) {
        this.removeTableModifiedListener(new ListenerAndConfig(l, AFTER_TX_DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModifiedListener(ListenerAndConfig l) {
        Object object = this.listenersMutex;
        synchronized (object) {
            ArrayList<ListenerAndConfig> newListeners = new ArrayList<ListenerAndConfig>(this.tableModifiedListeners);
            if (newListeners.remove(l)) {
                this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    public void fireTableModified(int id) {
        this.fire(SQLTableEvent.Mode.ROW_UPDATED, id);
    }

    public void fireTableModified(int id, Collection<String> fields) {
        this.fire(new SQLTableEvent(this, id, SQLTableEvent.Mode.ROW_UPDATED, fields));
    }

    private void fire(SQLTableEvent.Mode mode, int id) {
        this.fire(new SQLTableEvent(this, id, mode, null));
    }

    public final void fire(SQLTableEvent evt) {
        this.fireTableModified(evt);
    }

    private static void fireTableModified(DispatchingState newTuple) {
        DispatchingState currentTuple;
        LinkedList<DispatchingState> linkedList = events.get();
        linkedList.addLast(newTuple);
        while ((currentTuple = linkedList.peekFirst()) != null) {
            Iterator iter = (Iterator)currentTuple.get0();
            SQLTableEvent currentEvt = (SQLTableEvent)currentTuple.get1();
            while (iter.hasNext()) {
                SQLTableModifiedListener l = (SQLTableModifiedListener)iter.next();
                l.tableModified(currentEvt);
            }
            linkedList.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableModified(SQLTableEvent evt) {
        Boolean callbackAfterTxListeners;
        FireState fireState;
        TransactionPoint point = this.getDBSystemRoot().getDataSource().getTransactionPoint();
        Object object = this.listenersMutex;
        synchronized (object) {
            fireState = new FireState(this.tableModifiedListeners, evt);
            if (point == null) {
                callbackAfterTxListeners = null;
            } else {
                if (!this.transactions.containsKey(point)) {
                    point.addListener(this.txListener);
                }
                this.transactions.add(point, fireState);
                callbackAfterTxListeners = false;
            }
        }
        SQLTable.fireTableModified(fireState.createDispatchingState(callbackAfterTxListeners, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFromTransaction(TransactionPoint point, boolean committed) {
        List states;
        Object object = this.listenersMutex;
        synchronized (object) {
            states = (List)this.transactions.remove(point);
        }
        ListIterator iter = CollectionUtils.getListIterator(states, !committed);
        while (iter.hasNext()) {
            FireState state = (FireState)iter.next();
            SQLTable.fireTableModified(state.createDispatchingState(committed, !committed));
        }
    }

    public synchronized String toXML() {
        StringBuilder sb = new StringBuilder(16000);
        sb.append("<table name=\"");
        sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()));
        sb.append("\"");
        String schemaName = this.getSchema().getName();
        if (schemaName != null) {
            sb.append(" schema=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(schemaName));
            sb.append('\"');
        }
        SQLSchema.appendVersionAttr(this.version, sb);
        if (this.getType() != null) {
            sb.append(" type=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getType()));
            sb.append('\"');
        }
        sb.append(">\n");
        if (this.getComment() != null) {
            sb.append("<comment>");
            sb.append(JDOMUtils.OUTPUTTER.escapeElementEntities(this.getComment()));
            sb.append("</comment>\n");
        }
        for (SQLField sQLField : this.fields.values()) {
            sb.append(sQLField.toXML());
        }
        sb.append("<primary>\n");
        for (SQLField sQLField : this.primaryKeys) {
            sb.append(sQLField.toXML());
        }
        sb.append("</primary>\n");
        if (this.triggers.size() > 0) {
            sb.append("<triggers>\n");
            for (Trigger trigger : this.triggers.values()) {
                sb.append(trigger.toXML());
            }
            sb.append("</triggers>\n");
        }
        if (this.constraints != null) {
            sb.append("<constraints>\n");
            for (Constraint constraint : this.constraints) {
                sb.append(constraint.toXML());
            }
            sb.append("</constraints>\n");
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    public SQLTableModifiedListener createTableListener(final SQLDataListener l) {
        return new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                l.dataChanged();
            }
        };
    }

    @Override
    public SQLTable getTable() {
        return this;
    }

    @Override
    public String getAlias() {
        return this.getName();
    }

    @Override
    public String getSQL() {
        return this.getSQLName().quote();
    }

    public final List<String> getPKsNames() {
        return this.getPKsNames(new ArrayList());
    }

    public final synchronized <C extends Collection<String>> C getPKsNames(C pks) {
        for (SQLField f : this.getPrimaryKeys()) {
            pks.add((String)f.getName());
        }
        return pks;
    }

    public final synchronized List<Index> getIndexes() throws SQLException {
        Set<List<String>> uniqConstraints;
        if (this.constraints != null) {
            uniqConstraints = new HashSet();
            for (Constraint c : this.constraints) {
                if (c.getType() != SQLSyntax.ConstraintType.UNIQUE) continue;
                uniqConstraints.add(c.getCols());
            }
        } else {
            uniqConstraints = Collections.emptySet();
        }
        ArrayList<Index> indexes = new ArrayList<Index>();
        Index currentIndex = null;
        for (Map<String, Object> norm : this.getServer().getSQLSystem().getSyntax().getIndexInfo(this)) {
            Index index = new Index(norm);
            short seq = ((Number)norm.get("ORDINAL_POSITION")).shortValue();
            if (seq == 1) {
                if (this.canAdd(currentIndex, uniqConstraints)) {
                    indexes.add(currentIndex);
                }
                currentIndex = index;
                continue;
            }
            currentIndex.add(index);
        }
        if (this.canAdd(currentIndex, uniqConstraints)) {
            indexes.add(currentIndex);
        }
        return indexes;
    }

    private boolean canAdd(Index currentIndex, Set<List<String>> uniqConstraints) {
        if (currentIndex == null || currentIndex.isPKIndex()) {
            return false;
        }
        return !currentIndex.isUnique() || !uniqConstraints.contains(currentIndex.getCols());
    }

    private static class DispatchingState
    extends Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent> {
        public DispatchingState(List<SQLTableModifiedListener> listeners, SQLTableEvent evt) {
            super(listeners.iterator(), evt);
        }
    }

    private static class FireState
    extends Tuple2<List<ListenerAndConfig>, SQLTableEvent> {
        public FireState(List<ListenerAndConfig> listeners, SQLTableEvent evt) {
            super(listeners, evt);
        }

        private DispatchingState createDispatchingState(Boolean callbackAfterTxListeners, boolean oppositeEvt) {
            LinkedList<SQLTableModifiedListener> listeners = new LinkedList<SQLTableModifiedListener>();
            for (ListenerAndConfig l : (List)this.get0()) {
                if (callbackAfterTxListeners != null && callbackAfterTxListeners.booleanValue() != l.callOnlyAfterTx()) continue;
                listeners.add(l.getListener());
            }
            return new DispatchingState((List<SQLTableModifiedListener>)listeners, oppositeEvt ? ((SQLTableEvent)this.get1()).opposite() : (SQLTableEvent)this.get1());
        }
    }

    public final class Index {
        private final String name;
        private final List<String> attrs;
        private final List<String> cols;
        private final boolean unique;
        private String method;
        private String filter;

        Index(Map<String, Object> row) {
            this((String)row.get("INDEX_NAME"), (String)row.get("COLUMN_NAME"), (Boolean)row.get("NON_UNIQUE"), (String)row.get("FILTER_CONDITION"));
        }

        Index(String name, String col, Boolean nonUnique, String filter) {
            this.name = name;
            this.attrs = new ArrayList<String>();
            this.cols = new ArrayList<String>();
            this.unique = nonUnique == false;
            this.method = null;
            this.filter = filter;
            this.add(this.name, col, this.unique);
        }

        public final SQLTable getTable() {
            return SQLTable.this;
        }

        final void add(String name, String col, boolean unique) {
            if (!name.equals(this.name) || this.unique != unique) {
                throw new IllegalStateException("incoherence");
            }
            this.attrs.add(col);
            if (this.getTable().contains(col)) {
                this.cols.add(col);
            }
        }

        final void add(Index o) {
            this.add(o.getName(), o.cols.get(0), o.unique);
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isUnique() {
            return this.unique;
        }

        public final List<String> getAttrs() {
            return this.attrs;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        final boolean isPKIndex() {
            return this.isUnique() && this.getAttrs().equals(SQLTable.this.getPKsNames());
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName() + " unique: " + this.isUnique() + " cols: " + this.getAttrs();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Index) {
                Index o = (Index)obj;
                return this.isUnique() == o.isUnique() && this.getAttrs().equals(o.getAttrs());
            }
            return false;
        }

        public int hashCode() {
            return this.getAttrs().hashCode() + Boolean.valueOf(this.isUnique()).hashCode();
        }
    }

    public static final class ListenerAndConfig {
        private final SQLTableModifiedListener l;
        private final boolean afterTx;

        public ListenerAndConfig(SQLTableModifiedListener l, boolean afterTx) {
            if (l == null) {
                throw new NullPointerException("Null listener");
            }
            this.l = l;
            this.afterTx = afterTx;
        }

        public final SQLTableModifiedListener getListener() {
            return this.l;
        }

        public final boolean callOnlyAfterTx() {
            return this.afterTx;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.afterTx ? 1231 : 1237);
            result = 31 * result + this.l.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListenerAndConfig other = (ListenerAndConfig)obj;
            return this.afterTx == other.afterTx && this.l.equals(other.l);
        }
    }
}

