/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.MySQLBase;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.TablesMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

class SQLSyntaxMySQL
extends SQLSyntax {
    SQLSyntaxMySQL() {
        super(SQLSystem.MYSQL);
        this.typeNames.putAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.putAll(Short.class, "smallint");
        this.typeNames.putAll(Integer.class, "integer", "int");
        this.typeNames.putAll(Long.class, "bigint");
        this.typeNames.putAll(BigDecimal.class, "decimal", "numeric");
        this.typeNames.putAll(Float.class, "float");
        this.typeNames.putAll(Double.class, "double precision", "real");
        this.typeNames.putAll(Timestamp.class, "timestamp");
        this.typeNames.putAll(Date.class, "time");
        this.typeNames.putAll(Blob.class, "blob", "tinyblob", "mediumblob", "longblob", "varbinary", "binary");
        this.typeNames.putAll(Clob.class, "text", "tinytext", "mediumtext", "longtext", "varchar", "char");
        this.typeNames.putAll(String.class, "varchar", "char");
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public String getAuto() {
        return String.valueOf(this.getIDType()) + " AUTO_INCREMENT NOT NULL";
    }

    @Override
    public String getDateAndTimeType() {
        return "datetime";
    }

    @Override
    protected String getAutoDateType(SQLField f) {
        return "timestamp";
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return null;
    }

    @Override
    protected boolean supportsDefault(String typeName) {
        return !typeName.contains("text") && !typeName.contains("blob");
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        Class<?> javaType = f.getType().getJavaType();
        String res = (String)f.getDefaultValue();
        if (res == null) {
            res = Boolean.FALSE.equals(f.isNullable()) ? null : "NULL";
        } else if (javaType == String.class) {
            res = SQLBase.quoteStringStd(res);
        } else if (res.length() == 0) {
            res = null;
        } else if (Date.class.isAssignableFrom(javaType) && !res.trim().endsWith("()") && !res.toLowerCase().contains("timestamp")) {
            res = SQLBase.quoteStringStd(res);
        } else if (javaType == Boolean.class) {
            res = res.equals("0") ? "FALSE" : "TRUE";
        }
        return res;
    }

    @Override
    public String getCreateTableSuffix() {
        return " ENGINE = InnoDB ";
    }

    @Override
    protected String getRuleSQL(Link.Rule r) {
        if (r == Link.Rule.SET_DEFAULT) {
            throw new UnsupportedOperationException((Object)((Object)r) + " isn't supported");
        }
        return super.getRuleSQL(r);
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        Map<String, Object> res;
        Object nonUnique = (res = this.copyIndexInfoMap(m)).get("NON_UNIQUE");
        res.put("NON_UNIQUE", nonUnique instanceof Boolean ? nonUnique : Boolean.valueOf((String)nonUnique));
        res.put("COLUMN_NAME", res.get("COLUMN_NAME"));
        return res;
    }

    @Override
    public List<String> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        String newDef;
        boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
        String newType = toAlter.contains((Object)SQLField.Properties.TYPE) ? type : this.getType(f);
        String string = newDef = toAlter.contains((Object)SQLField.Properties.DEFAULT) ? defaultVal : this.getDefault(f, newType);
        if (!newNullable && newDef != null && newDef.trim().toUpperCase().equals("NULL")) {
            newDef = null;
        }
        return Collections.singletonList("MODIFY COLUMN " + f.getQuotedName() + " " + this.getFieldDecl(newType, newDef, newNullable));
    }

    @Override
    public SQLBase createBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        return new MySQLBase(server, name, login, pass, dsInit);
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " <=> " + y;
        if (eq) {
            return nullSafe;
        }
        return "NOT (" + nullSafe + ")";
    }

    @Override
    public String getFormatTimestamp(String sqlTS, boolean basic) {
        return "DATE_FORMAT(" + sqlTS + ", " + SQLBase.quoteStringStd(basic ? "%Y%m%dT%H%i%s.%f" : "%Y-%m-%dT%H:%i:%s.%f") + ")";
    }

    private final void getRow(StringBuilder sb, List<String> row, int requiredColCount, List<String> columnsAlias) {
        assert (columnsAlias == null || requiredColCount == columnsAlias.size());
        int actualColCount = row.size();
        if (actualColCount != requiredColCount) {
            throw new IllegalArgumentException("Wrong number of columns, should be " + requiredColCount + " but row is " + row);
        }
        int i = 0;
        while (i < actualColCount) {
            sb.append(row.get(i));
            if (columnsAlias != null) {
                sb.append(" as ");
                sb.append(SQLBase.quoteIdentifier(columnsAlias.get(i)));
            }
            if (i < actualColCount - 1) {
                sb.append(", ");
            }
            ++i;
        }
    }

    @Override
    public String getConstantTable(List<List<String>> rows, String alias, List<String> columnsAlias) {
        int rowCount = rows.size();
        if (rowCount < 1) {
            throw new IllegalArgumentException("Empty rows will cause a syntax error");
        }
        int colCount = columnsAlias.size();
        if (colCount < 1) {
            throw new IllegalArgumentException("Empty columns will cause a syntax error");
        }
        StringBuilder sb = new StringBuilder(rows.size() * 64);
        sb.append("( SELECT ");
        this.getRow(sb, rows.get(0), colCount, columnsAlias);
        int i = 1;
        while (i < rowCount) {
            sb.append("\nUNION ALL\nSELECT ");
            this.getRow(sb, rows.get(i), colCount, null);
            ++i;
        }
        sb.append(" ) as ");
        sb.append(SQLBase.quoteIdentifier(alias));
        return sb.toString();
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "SELECT null as \"schema\", ROUTINE_NAME as \"name\", ROUTINE_DEFINITION as \"src\" FROM \"information_schema\".ROUTINES where ROUTINE_CATALOG is null and ROUTINE_SCHEMA = '" + b.getMDName() + "'";
    }

    @Override
    public String getTriggerQuery(SQLBase b, TablesMap tables) {
        return "SELECT \"TRIGGER_NAME\", null as \"TABLE_SCHEMA\", EVENT_OBJECT_TABLE as \"TABLE_NAME\", ACTION_STATEMENT as \"ACTION\", null as \"SQL\" from INFORMATION_SCHEMA.TRIGGERS " + this.getMySQLTablesMapJoin(b, tables, "EVENT_OBJECT_SCHEMA", "EVENT_OBJECT_TABLE");
    }

    private String getMySQLTablesMapJoin(SQLBase b, TablesMap tables, String schemaCol, String tableCol) {
        TablesMap translated;
        assert (tables.size() <= 1);
        if (tables.size() == 0) {
            translated = tables;
        } else {
            assert (tables.keySet().equals(Collections.singleton(null))) : tables;
            translated = new TablesMap(1);
            translated.put(b.getMDName(), (Set)tables.get(null));
        }
        return this.getTablesMapJoin(b, translated, schemaCol, tableCol);
    }

    @Override
    public String getColumnsQuery(SQLBase b, TablesMap tables) {
        return "SELECT null as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , \"CHARACTER_SET_NAME\", \"COLLATION_NAME\" from INFORMATION_SCHEMA.\"COLUMNS\" " + this.getMySQLTablesMapJoin(b, tables, "TABLE_SCHEMA", "TABLE_NAME");
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, TablesMap tables) throws SQLException {
        String sel = "SELECT null as \"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", tc.\"CONSTRAINT_TYPE\", \"COLUMN_NAME\", c.\"ORDINAL_POSITION\"\n FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE c\nJOIN (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS T " + this.getMySQLTablesMapJoin(b, tables, "TABLE_SCHEMA", "TABLE_NAME") + ") tc on tc.\"TABLE_SCHEMA\" = c.\"TABLE_SCHEMA\" and tc.\"TABLE_NAME\"=c.\"TABLE_NAME\" and tc.\"CONSTRAINT_NAME\"=c.\"CONSTRAINT_NAME\"\n" + this.getMySQLTablesMapJoin(b, tables, "c.TABLE_SCHEMA", "c.TABLE_NAME") + "order by c.\"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", c.\"ORDINAL_POSITION\"";
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    static void mergeColumnNames(List<Map<String, Object>> res) {
        Iterator<Map<String, Object>> listIter = res.iterator();
        ArrayList<String> l = null;
        while (listIter.hasNext()) {
            Map<String, Object> m = listIter.next();
            int pos = ((Number)m.remove("ORDINAL_POSITION")).intValue();
            if (pos == 1) {
                l = new ArrayList<String>();
                m.put("COLUMN_NAMES", l);
            } else {
                listIter.remove();
            }
            l.add((String)m.remove("COLUMN_NAME"));
        }
    }

    @Override
    public String getUpdate(final SQLTable t, List<String> tables, Map<String, String> setPart) {
        ArrayList<String> l = new ArrayList<String>(tables);
        l.add(0, t.getSQLName().quote());
        return String.valueOf(CollectionUtils.join(l, ", ")) + "\nSET " + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(t.getField(input.getKey()).getSQLName(t).quote()) + " = " + input.getValue();
            }
        });
    }
}

