/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.utils.EnumOrderedSet;
import org.openconcerto.utils.FileUtils;

public final class DBItemFileCache {
    private final DBFileCache root;
    private final File f;
    private final HierarchyLevel level;

    public static final String encode(String name) {
        String res = "n_";
        if (name != null) {
            res = String.valueOf(res) + "'" + DBFileCache.esc.escape(name);
        }
        return res;
    }

    public static final String decode(String name) {
        if (name.length() == "n_".length()) {
            return null;
        }
        String res = name.substring("n_".length() + 1);
        return DBFileCache.esc.unescape(res);
    }

    public static final File getDescendant(File dir, List<String> names) {
        File f = dir;
        for (String name : names) {
            f = new File(f, DBItemFileCache.encode(name));
        }
        return f;
    }

    DBItemFileCache(DBFileCache root, File f) {
        File rel;
        if (root == null) {
            throw new NullPointerException("null parent");
        }
        this.root = root;
        if (f.exists() && !f.isDirectory()) {
            throw new IllegalArgumentException("f is not a directory: " + f);
        }
        this.f = f;
        try {
            rel = new File(FileUtils.relative(root.getSystemDir(), f));
        }
        catch (IOException e) {
            throw new IllegalStateException("could not rel " + f + " to " + root, e);
        }
        List<File> ancs = FileUtils.getAncestors(rel);
        if (ancs.get(0).getName().equals("..")) {
            throw new IllegalArgumentException(f + " is not beneath " + root);
        }
        if (ancs.get(0).getName().equals(".")) {
            ancs.remove(0);
        }
        this.level = HierarchyLevel.getAll().get(ancs.size() - 1);
    }

    public final File getDir() {
        return this.f;
    }

    private final File getValidDir() {
        try {
            return FileUtils.mkdir_p(this.getDir());
        }
        catch (IOException e) {
            throw new IllegalStateException("could not create dir", e);
        }
    }

    public final HierarchyLevel getLevel() {
        return this.level;
    }

    public final DBItemFileCache getParent() {
        if (this.getLevel() == HierarchyLevel.SQLSERVER) {
            return null;
        }
        return new DBItemFileCache(this.root, this.getDir().getParentFile());
    }

    public final DBItemFileCache getChild(String name) {
        return new DBItemFileCache(this.root, new File(this.getDir(), DBItemFileCache.encode(name)));
    }

    public final String getName() {
        return DBItemFileCache.decode(this.f.getName());
    }

    public final boolean delete() {
        return this.delete(false);
    }

    public final boolean delete(boolean backup) {
        if (!this.root.getServer().getSQLSystem().getLevels().contains(this.getLevel())) {
            return this.getParent().delete(backup);
        }
        if (backup) {
            File rootDir = this.root.getSystemDir().getParentFile();
            assert (this.getDir().getPath().startsWith(rootDir.getPath()));
            File destDir = new File(rootDir, "DELETED/" + this.getDir().getPath().substring(rootDir.getPath().length()));
            try {
                FileUtils.mkdir_p(destDir.getParentFile());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            FileUtils.mvOut(destDir.getParentFile(), destDir.getName(), "");
            return FileUtils.mv(this.getDir(), destDir) == null;
        }
        return FileUtils.rmR(this.getDir());
    }

    public final List<DBItemFileCache> getSavedDesc(Class<? extends DBStructureItem<?>> clazz) {
        return this.getSavedDesc(clazz, null);
    }

    public final List<DBItemFileCache> getSavedDesc(Class<? extends DBStructureItem<?>> clazz, String name) {
        return this.getSavedDesc(this.root.getServer().getSQLSystem().getLevel(clazz), name);
    }

    private final List<DBItemFileCache> getSavedDesc(HierarchyLevel l, String name) {
        List<File> dirs = this.getSavedFiles(l, name);
        ArrayList<DBItemFileCache> res = new ArrayList<DBItemFileCache>(dirs.size());
        for (File dir : dirs) {
            res.add(new DBItemFileCache(this.root, name == null ? dir : dir.getParentFile()));
        }
        return res;
    }

    private final List<File> getSavedFiles(HierarchyLevel l, final String name) {
        FileFilter fileFilter;
        int diff;
        if (name == null) {
            diff = this.getDiff(l);
            fileFilter = FileUtils.DIR_FILTER;
        } else {
            diff = this.getDiff(l) + 1;
            fileFilter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().equals(name);
                }
            };
        }
        return FileUtils.list(this.getValidDir(), diff, fileFilter);
    }

    private int getDiff(HierarchyLevel l) {
        EnumOrderedSet<HierarchyLevel> all = HierarchyLevel.getAll();
        int diff = all.getHops(this.getLevel(), l);
        if (diff < 0) {
            throw new IllegalArgumentException((Object)((Object)l) + " is not beneath " + (Object)((Object)this.getLevel()));
        }
        return diff;
    }

    public final File getFile(String n) {
        return new File(this.getDir(), n);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getDir();
    }
}

