/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.JDOMException;
import org.openconcerto.sql.element.SQLElementNames;
import org.openconcerto.sql.element.SQLElementNamesFromXML;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.i18n.LocalizedInstances;
import org.openconcerto.utils.i18n.TranslationManager;

public final class SQLElementDirectory {
    public static final String BASENAME = SQLElementNames.class.getSimpleName();
    private static final LocalizedInstances<SQLElementNames> LOCALIZED_INSTANCES = new LocalizedInstances<SQLElementNames>(SQLElementNames.class, TranslationManager.getControl()){

        @Override
        protected SQLElementNames createInstance(String bundleName, Locale candidate, Class<?> cl) throws IOException {
            InputStream ins = cl.getResourceAsStream(String.valueOf('/') + this.getControl().toResourceName(bundleName, "xml"));
            if (ins == null) {
                return null;
            }
            SQLElementNamesFromXML res = new SQLElementNamesFromXML(candidate);
            try {
                try {
                    res.load(ins);
                }
                catch (JDOMException e) {
                    throw new IOException("Invalid XML", e);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            finally {
                ins.close();
            }
            return res;
        }
    };
    private final Map elements = new HashMap();
    private final CollectionMap<String, SQLTable> tableNames = new CollectionMap(HashSet.class);
    private final CollectionMap<String, SQLTable> byCode = new CollectionMap(HashSet.class);
    private final CollectionMap byClass = new CollectionMap(HashSet.class);
    private final List<DirectoryListener> listeners = new ArrayList<DirectoryListener>();
    private String phrasesPkgName = null;
    private final Map<String, SQLElementNames> elementNames = new HashMap<String, SQLElementNames>();

    public final synchronized void removeListener(DirectoryListener dl) {
        this.listeners.remove(dl);
    }

    public static interface DirectoryListener {
    }
}

