/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.File;
import org.openconcerto.sql.model.DBRoot;

public abstract class Configuration {
    private static Configuration instance;

    public static File getDefaultConfDir() {
        return new File(System.getProperty("user.home"), ".java/ilm/sql-config/");
    }

    public static Configuration getInstance() {
        return instance;
    }

    public abstract DBRoot getRoot();

    public abstract String getAppName();

    public final String getAppID() {
        String appName = this.getAppName();
        if (appName == null || appName.length() == 0) {
            return null;
        }
        return String.valueOf(appName) + this.getAppIDSuffix();
    }

    protected String getAppIDSuffix() {
        return "";
    }

    public File getConfDir() {
        return new File(Configuration.getDefaultConfDir(), this.getAppID());
    }
}

