/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ServerModuleManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;

public class ModuleManager {
    private static final Logger L = Logger.getLogger(ModuleManager.class.getPackage().getName());
    private static ExecutorService exec = null;
    private static final String fileMutex = new String("modules");
    private static ModuleManager instance = null;
    private boolean setupDone = false;
    private final Map factories;
    private final Map runningModules;
    private final List<ModuleReference> missingModules;
    private final Map<ModuleReference, String> infos;
    private final Map modulesElements;
    private final Map modulesComponents;
    private final DirectedGraph dependencyGraph;
    private DBRoot root = null;
    private Configuration conf = null;
    private Set<ModuleReference> knownModuleReferences = new HashSet<ModuleReference>();
    private ServerModuleManager remoteModuleManager;
    private List<ModuleReference> modulesInstalledOnServer;
    private List<ModuleReference> modulesRequiredLocally;

    public ModuleManager() {
        this.factories = new HashMap();
        this.runningModules = new HashMap();
        this.missingModules = new ArrayList<ModuleReference>();
        this.infos = new HashMap<ModuleReference, String>();
        this.dependencyGraph = new SimpleDirectedGraph(new EdgeFactory(){});
        this.modulesElements = new HashMap();
        this.modulesComponents = new HashMap();
    }

    public final synchronized void setRoot(DBRoot root) throws SQLException {
        if (this.root != root) {
            if (this.root != null) {
                throw new IllegalStateException("Root already set");
            }
            this.root = root;
            this.remoteModuleManager = new ServerModuleManager();
            this.remoteModuleManager.setRoot(root);
            this.reloadServerState();
        }
    }

    public synchronized List<ModuleReference> getRemoteInstalledModules() {
        return this.modulesInstalledOnServer;
    }

    private synchronized void reloadServerState() {
        try {
            this.modulesInstalledOnServer = this.remoteModuleManager.getDBInstalledModules();
            this.modulesRequiredLocally = this.remoteModuleManager.getRequiredModules();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> getCreatedTables(ModuleReference reference) {
        return this.remoteModuleManager.getCreatedTables(reference.getId());
    }
}

