/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class JdbcUtils {
    private static final String[] DRIVERS = new String[]{"h2:", "org.h2.Driver", "Cache:", "com.intersys.jdbc.CacheDriver", "daffodilDB://", "in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "daffodil", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "db2:", "COM.ibm.db2.jdbc.net.DB2Driver", "derby:net:", "org.apache.derby.jdbc.ClientDriver", "derby://", "org.apache.derby.jdbc.ClientDriver", "derby:", "org.apache.derby.jdbc.EmbeddedDriver", "FrontBase:", "com.frontbase.jdbc.FBJDriver", "firebirdsql:", "org.firebirdsql.jdbc.FBDriver", "hsqldb:", "org.hsqldb.jdbcDriver", "informix-sqli:", "com.informix.jdbc.IfxDriver", "jtds:", "net.sourceforge.jtds.jdbc.Driver", "microsoft:", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "mimer:", "com.mimer.jdbc.Driver", "mysql:", "com.mysql.jdbc.Driver", "odbc:", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle:", "oracle.jdbc.driver.OracleDriver", "pervasive:", "com.pervasive.jdbc.v2.Driver", "pointbase:micro:", "com.pointbase.me.jdbc.jdbcDriver", "pointbase:", "com.pointbase.jdbc.jdbcUniversalDriver", "postgresql:", "org.postgresql.Driver", "sybase:", "com.sybase.jdbc3.jdbc.SybDriver", "sqlserver:", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "teradata:", "com.ncr.teradata.TeraDriver"};

    public static void closeSilently(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String string, String string2, String string3, String string4) throws SQLException {
        Properties properties = new Properties();
        if (string3 != null) {
            properties.setProperty("user", string3);
        }
        if (string4 != null) {
            properties.setProperty("password", string4);
        }
        return JdbcUtils.getConnection(string, string2, properties);
    }

    public static String escapeMetaDataPattern(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return StringUtils.replaceAll(string, "\\", "\\\\");
    }

    public static Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        if (!StringUtils.isNullOrEmpty(string)) {
            Class<?> clazz = Utils.loadUserClass(string);
            if (Driver.class.isAssignableFrom(clazz)) {
                return DriverManager.getConnection(string2, properties);
            }
            if (Context.class.isAssignableFrom(clazz)) {
                try {
                    Context context = (Context)clazz.newInstance();
                    DataSource dataSource = (DataSource)context.lookup(string2);
                    String string3 = properties.getProperty("user");
                    String string4 = properties.getProperty("password");
                    if (StringUtils.isNullOrEmpty(string3) && StringUtils.isNullOrEmpty(string4)) {
                        return dataSource.getConnection();
                    }
                    return dataSource.getConnection(string3, string4);
                }
                catch (Exception exception) {
                    throw DbException.toSQLException(exception);
                }
            }
            return DriverManager.getConnection(string2, properties);
        }
        JdbcUtils.load(string2);
        return DriverManager.getConnection(string2, properties);
    }

    public static String getDriver(String string) {
        if (string.startsWith("jdbc:")) {
            string = string.substring("jdbc:".length());
            for (int i = 0; i < DRIVERS.length; i += 2) {
                String string2 = DRIVERS[i];
                if (!string.startsWith(string2)) continue;
                return DRIVERS[i + 1];
            }
        }
        return null;
    }

    public static void load(String string) {
        String string2 = JdbcUtils.getDriver(string);
        if (string2 != null) {
            Utils.loadUserClass(string2);
        }
    }
}

