/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RbnfLenientScanner;
import com.ibm.icu.text.RbnfLenientScannerProvider;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;

public class RbnfScannerProviderImpl
implements RbnfLenientScannerProvider {
    private Map<String, RbnfLenientScanner> cache = new HashMap<String, RbnfLenientScanner>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbnfLenientScanner get(ULocale locale, String extras) {
        RbnfLenientScanner result = null;
        String key = locale.toString() + "/" + extras;
        Map<String, RbnfLenientScanner> map = this.cache;
        synchronized (map) {
            result = this.cache.get(key);
            if (result != null) {
                return result;
            }
        }
        result = this.createScanner(locale, extras);
        map = this.cache;
        synchronized (map) {
            this.cache.put(key, result);
        }
        return result;
    }

    protected RbnfLenientScanner createScanner(ULocale locale, String extras) {
        RuleBasedCollator collator = null;
        try {
            collator = (RuleBasedCollator)Collator.getInstance(locale.toLocale());
            if (extras != null) {
                String rules = collator.getRules() + extras;
                collator = new RuleBasedCollator(rules);
            }
            collator.setDecomposition(17);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("++++");
            collator = null;
        }
        return new RbnfLenientScannerImpl(collator);
    }

    private static class RbnfLenientScannerImpl
    implements RbnfLenientScanner {
        private final RuleBasedCollator collator;

        private RbnfLenientScannerImpl(RuleBasedCollator rbc) {
            this.collator = rbc;
        }

        public boolean allIgnorable(String s) {
            CollationElementIterator iter = this.collator.getCollationElementIterator(s);
            int o = iter.next();
            while (o != -1 && CollationElementIterator.primaryOrder(o) == 0) {
                o = iter.next();
            }
            return o == -1;
        }

        public int[] findText(String str, String key, int startingAt) {
            int keyLen = 0;
            for (int p = startingAt; p < str.length() && keyLen == 0; ++p) {
                keyLen = this.prefixLength(str.substring(p), key);
                if (keyLen == 0) continue;
                return new int[]{p, keyLen};
            }
            return new int[]{-1, 0};
        }

        public int prefixLength(String str, String prefix) {
            CollationElementIterator strIter = this.collator.getCollationElementIterator(str);
            CollationElementIterator prefixIter = this.collator.getCollationElementIterator(prefix);
            int oStr = strIter.next();
            int oPrefix = prefixIter.next();
            while (oPrefix != -1) {
                while (CollationElementIterator.primaryOrder(oStr) == 0 && oStr != -1) {
                    oStr = strIter.next();
                }
                while (CollationElementIterator.primaryOrder(oPrefix) == 0 && oPrefix != -1) {
                    oPrefix = prefixIter.next();
                }
                if (oPrefix == -1) break;
                if (oStr == -1) {
                    return 0;
                }
                if (CollationElementIterator.primaryOrder(oStr) != CollationElementIterator.primaryOrder(oPrefix)) {
                    return 0;
                }
                oStr = strIter.next();
                oPrefix = prefixIter.next();
            }
            int result = strIter.getOffset();
            if (oStr != -1) {
                --result;
            }
            return result;
        }
    }
}

